/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.message.trust.issue;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTRIssueValidationConfig;
import org.eclipse.alf.security.sso.common.ws.message.trust.issue.RSTRIssueValidationResult;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SignedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityTokenResponse;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestedSecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.TokenType;

public class RSTRIssueValidator {
    static final Logger log = Logger.getLogger(RSTRIssueValidator.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RSTRIssueValidationResult validate(OMElement element, RSTRIssueValidationConfig config) {
        SecurityToken st;
        String tokenTypeURI;
        RSTRIssueValidationResult result;
        String newLine;
        block15: {
            newLine = System.getProperty("line.separator");
            result = new RSTRIssueValidationResult();
            RequestSecurityTokenResponse rstr = null;
            if (!SSOHelper.isRSTRElement(element)) {
                log.debug((Object)("RSTRIssueValidator.validate(): argument is not an RSTR element:[" + element.toString() + "]"));
                result.setCode(1);
                return result;
            }
            try {
                rstr = WSTrustObjectBuilder.buildRequestSecurityTokenResponse(element);
            }
            catch (SSOException e) {
                log.debug((Object)("RSTRIssueValidator.validate(): error deserialzing RSTR:" + newLine + "RST=[" + element.toString() + "]" + newLine + "exception message=[" + e.getMessage() + "]"));
                result.setCode(2);
                result.setMessage(e.getMessage());
                return result;
            }
            tokenTypeURI = null;
            st = null;
            RequestedSecurityToken rstObj = rstr.getRequestedSecurityToken();
            if (rstObj != null) {
                st = rstObj.getSecurityToken();
                if (st != null) {
                    TokenType tokenType = rstr.getTokenType();
                    tokenTypeURI = tokenType != null ? tokenType.getTokenType() : st.getType();
                    if (tokenTypeURI == null) {
                        result.setCode(3);
                        result.setMessage("Element <wst:TokenType> missing from RSTR");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RSTRIssueValidator.validate(): <wst:TokenType> missing from RSTR:" + newLine + "RST=[" + element.toString() + "]"));
                        }
                        return result;
                    }
                    break block15;
                } else {
                    result.setCode(4);
                    result.setMessage("Security token missing from RSTR");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RSTRIssueValidator.validate(): security token missing from RSTR:" + newLine + "RST=[" + element.toString() + "]"));
                    }
                    return result;
                }
            }
            result.setCode(5);
            result.setMessage("Element <wst:RequestedSecurityToken> missing from RSTR");
            if (log.isDebugEnabled()) {
                log.debug((Object)("RSTRIssueValidator.validate(): <wst:RequestedSecurityToken> is missing from RSTR:" + newLine + "RST=[" + element.toString() + "]"));
            }
            return result;
        }
        Iterator it = config.getSupportedTokensList();
        boolean found = false;
        while (it.hasNext()) {
            String current = (String)it.next();
            if (!tokenTypeURI.equals(current)) continue;
            found = true;
            break;
        }
        if (!found) {
            result.setCode(6);
            result.setMessage("Issued security token is of unsuppored type: {0}");
            result.setMessageParams(new Object[]{tokenTypeURI});
            if (log.isDebugEnabled()) {
                log.debug((Object)("RSTRIssueValidator.validate(): issued security token unsupported:" + newLine + "<wstTokenType>=[" + tokenTypeURI + "]" + newLine + "RST=[" + element.toString() + "]"));
            }
            return result;
        }
        if (st instanceof SignedSecurityToken) {
            result.setCode(0);
            return result;
        }
        result.setCode(6);
        result.setMessage("Issued security token is of unsuppored type: {0}");
        result.setMessageParams(new Object[]{tokenTypeURI});
        if (log.isDebugEnabled()) {
            log.debug((Object)("RSTRIssueValidator.validate(): issued security token unsupported:" + newLine + "<wstTokenType>=[" + tokenTypeURI + "]" + newLine + "RST=[" + element.toString() + "]"));
        }
        return result;
    }
}

