/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.common.ws.model.security.secext;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtObjectFactory;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.WSSecExtVersion;

public class WSSecExt {
    static final Logger log = Logger.getLogger(WSSecExt.class);
    public static final int V1 = 1;
    public static final int V2 = 2;
    public static final String WSSE_V10_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSSE_V11_NAMESPACE = "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd";
    public static final String WSSE_V10_DEFAULT_PREFIX = "wsse";
    public static final String WSSE_V11_DEFAULT_PREFIX = "wsse11";
    public static final String WSSE_SOAP_HEADER_LOCAL_NAME = "Security";
    protected WSSecExtVersion version;
    protected String namespace;
    protected String defaultPrefix;
    protected WSSecExtObjectFactory objectFactory = null;

    private void init(WSSecExtVersion version) {
        this.version = version;
        if (version == WSSecExtVersion.V10) {
            this.namespace = WSSE_V10_NAMESPACE;
            this.defaultPrefix = WSSE_V10_DEFAULT_PREFIX;
        } else {
            this.namespace = WSSE_V11_NAMESPACE;
            this.defaultPrefix = WSSE_V11_DEFAULT_PREFIX;
        }
        this.objectFactory = new WSSecExtObjectFactory(this);
    }

    public WSSecExt() {
        this.init(WSSecExtVersion.V10);
    }

    public WSSecExt(WSSecExtVersion version) {
        this.init(version);
    }

    public WSSecExtVersion getVersion() {
        return this.version;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static OMNamespace getNamespace(WSSecExtVersion version) {
        if (version == WSSecExtVersion.V10) {
            return OMAbstractFactory.getOMFactory().createOMNamespace(WSSE_V10_NAMESPACE, WSSE_V10_DEFAULT_PREFIX);
        }
        if (version == WSSecExtVersion.V11) {
            return OMAbstractFactory.getOMFactory().createOMNamespace(WSSE_V11_NAMESPACE, WSSE_V11_DEFAULT_PREFIX);
        }
        return null;
    }

    public String getPrefix() {
        return this.defaultPrefix;
    }

    public static boolean isSupportedNamespace(String namespace) {
        if (namespace.equals(WSSE_V10_NAMESPACE)) {
            return true;
        }
        return namespace.equals(WSSE_V11_NAMESPACE);
    }

    public static WSSecExt createFromNamespace(String namespace) {
        if (namespace.equals(WSSE_V10_NAMESPACE)) {
            return new WSSecExt(WSSecExtVersion.V10);
        }
        if (namespace.equals(WSSE_V11_NAMESPACE)) {
            return new WSSecExt(WSSecExtVersion.V11);
        }
        return null;
    }

    public OMElement createOMElement(String elementLocalName) {
        return OMAbstractFactory.getOMFactory().createOMElement(elementLocalName, this.getNamespace(), this.getPrefix());
    }

    public static OMElement createOMElement(WSSecExtVersion version, String elementLocalName) {
        if (version == WSSecExtVersion.V10) {
            return OMAbstractFactory.getOMFactory().createOMElement(elementLocalName, WSSE_V10_NAMESPACE, WSSE_V10_DEFAULT_PREFIX);
        }
        if (version == WSSecExtVersion.V11) {
            return OMAbstractFactory.getOMFactory().createOMElement(elementLocalName, WSSE_V11_NAMESPACE, WSSE_V11_DEFAULT_PREFIX);
        }
        return null;
    }

    public OMElement createOMElement(OMElement parent, String elementLocalName) {
        if (parent == null) {
            OMFactory fac = OMAbstractFactory.getOMFactory();
            return fac.createOMElement(elementLocalName, this.getNamespace(), this.getPrefix());
        }
        return XMLHelper.createOMElement(parent, this.getNamespace(), elementLocalName, this.getPrefix());
    }

    public OMElement createOMElement(WSSecExtVersion version, OMElement parent, String elementLocalName) {
        if (version == WSSecExtVersion.V10) {
            if (parent == null) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                return fac.createOMElement(elementLocalName, WSSE_V10_NAMESPACE, WSSE_V10_DEFAULT_PREFIX);
            }
            return XMLHelper.createOMElement(parent, WSSE_V10_NAMESPACE, elementLocalName, WSSE_V10_DEFAULT_PREFIX);
        }
        if (version == WSSecExtVersion.V11) {
            if (parent == null) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                return fac.createOMElement(elementLocalName, WSSE_V11_NAMESPACE, WSSE_V11_DEFAULT_PREFIX);
            }
            return XMLHelper.createOMElement(parent, WSSE_V11_NAMESPACE, elementLocalName, WSSE_V11_DEFAULT_PREFIX);
        }
        return null;
    }

    public WSSecExtObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public static String getFaultString(String faultCode) {
        if (StringHelper.isBlank(faultCode)) {
            return null;
        }
        if (faultCode.equals("UnsupportedSecurityToken")) {
            return "An unsupported token was provided";
        }
        if (faultCode.equals("UnsupportedAlgorithm")) {
            return "An unsupported signature or encryption algorithm was used";
        }
        if (faultCode.equals("InvalidSecurity")) {
            return "An error was discovered processing the <wsse:Security> header.";
        }
        if (faultCode.equals("InvalidSecurityToken")) {
            return "An invalid security token was provided";
        }
        if (faultCode.equals("FailedAuthentication")) {
            return "The security token could not be authenticated or authorized";
        }
        if (faultCode.equals("FailedCheck")) {
            return "The signature or decryption was invalid";
        }
        if (faultCode.equals("SecurityTokenUnavailable")) {
            return "Referenced security token could not be retrieved";
        }
        if (faultCode.equals("MessageExpired")) {
            return "The message has expired";
        }
        return null;
    }

    public static class FaultCodes {
        public static final String UNSUPPORTED_SECURITY_TOKEN = "UnsupportedSecurityToken";
        public static final String UNSUPPORTED_ALGORITHM = "UnsupportedAlgorithm";
        public static final String INVALID_SECURITY = "InvalidSecurity";
        public static final String INVALID_SECURITY_TOKEN = "InvalidSecurityToken";
        public static final String FAILED_AUTHENTICATION = "FailedAuthentication";
        public static final String FAILED_CHECK = "FailedCheck";
        public static final String SECURITY_TOKEN_UNAVAILABLE = "SecurityTokenUnavailable";
        public static final String MESSAGE_EXPIRED = "MessageExpired";
    }

    public static class TokenTypes {
        public static final String UNKNOWN = "UNKNOWN";
        public static final String USERNAME_TOKEN = "UsernameToken";
        public static final String SAML1_TOKEN = "SAML1Token";
        public static final String SAML2_TOKEN = "SAML2Token";
    }

    public static class ElementNames {
        public static final String REFERENCE = "Reference";
        public static final String EMBEDDED = "Embedded";
        public static final String ENCRYPTED_HEADER = "EncryptedHeader";
        public static final String KEY_IDENTIFIER = "KeyIdentifier";
        public static final String SECURITY_TOKEN_REFERENCE = "SecurityTokenReference";
        public static final String USERNAME_TOKEN = "UsernameToken";
    }
}

