/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;

public class CredentialsHandler {
    private static Logger log = Logger.getLogger(CredentialsHandler.class);

    public static boolean process(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        if (!requestContext.getPrincipalCredentialsAquired()) {
            boolean initialRequest;
            String username = req.getParameter("username");
            String password = req.getParameter("password");
            String opaque = req.getParameter("opaque");
            String secret = (String)req.getSession().getAttribute("ATTR_LOGINPAGE_SECRET");
            try {
                if (username != null) {
                    username = new String(username.getBytes("8859_1"), "utf-8");
                }
                if (password != null) {
                    password = new String(password.getBytes("8859_1"), "utf-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new ServletException("Unsupported encoding: " + e.getMessage(), (Throwable)e);
            }
            boolean bl = initialRequest = req.getParameter("wa") != null;
            if (req.getSession().getAttribute("ATTR_PARAMS_REMOVED_FROM_URL") != null) {
                req.getSession().removeAttribute("ATTR_PARAMS_REMOVED_FROM_URL");
                initialRequest = true;
            }
            boolean validCredentials = false;
            String message = "";
            if (initialRequest) {
                validCredentials = false;
                message = "";
            } else if (StringHelper.isNotBlank((String)secret) && StringHelper.isNotBlank((String)opaque)) {
                String secret_sha = DigestUtils.shaHex((String)secret);
                validCredentials = opaque.equals(secret_sha);
                message = !validCredentials ? FedSrvHelper.getLocalizedMessage("fedsvr.credentials.invalidChallengeResponse", req.getLocale()) : "";
            } else if (StringHelper.isBlank((String)secret) && StringHelper.isBlank((String)opaque)) {
                validCredentials = false;
                message = "";
            } else {
                if (StringHelper.isNotBlank((String)secret) && StringHelper.isBlank((String)opaque)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Session secret is not empty, however request is missing opaque data, redirecting to forbidden");
                    }
                    message = FedSrvHelper.getLocalizedMessage("fedsvr.credentials.invalidRequest", req.getLocale());
                    PageRedirector.redrectDirectFobidden(req, resp, requestContext);
                    return false;
                }
                if (StringHelper.isBlank((String)secret) && StringHelper.isNotBlank((String)opaque)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Request opaque data is not empty, however session is missing secret data, redirecting to forbidden");
                    }
                    message = FedSrvHelper.getLocalizedMessage("fedsvr.credentials.invalidSession", req.getLocale());
                    PageRedirector.redrectDirectFobidden(req, resp, requestContext);
                    return false;
                }
            }
            if (validCredentials && StringHelper.isBlank((String)username)) {
                validCredentials = false;
                message = FedSrvHelper.getLocalizedMessage("fedsvr.credentials.emptyUsername", req.getLocale());
            }
            if (requestContext.getMasterCookieData() != null && requestContext.getMasterCookieData().getToken() != null) {
                if (requestContext.getMasterCookieData().getToken().isExpired()) {
                    requestContext.setPrincipalUsername(requestContext.getMasterCookieData().getToken().getSubjectName());
                } else {
                    validCredentials = true;
                    username = requestContext.getMasterCookieData().getToken().getSubjectName();
                    requestContext.setPrincipalCredentialsAquired(true);
                }
            }
            if (validCredentials) {
                requestContext.setPrincipalUsername(username != null ? username.trim() : "");
                requestContext.setPrincipalPassword(password != null ? password.trim() : "");
                requestContext.setPrincipalCredentialsAquired(true);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Redirecting to login page for credentials");
                }
                PageRedirector.redirectToLoginPage(req, resp, requestContext, message);
                return false;
            }
        }
        return true;
    }
}

