/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.alf.security.sso.server.federationserver.handler;

import java.security.Principal;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.log4j.Logger;
import org.eclipse.alf.security.sso.common.RPURI;
import org.eclipse.alf.security.sso.common.SSOException;
import org.eclipse.alf.security.sso.common.http.configuration.CoreConfig;
import org.eclipse.alf.security.sso.common.token.SSOToken;
import org.eclipse.alf.security.sso.common.token.SSOTokenFactory;
import org.eclipse.alf.security.sso.common.util.SOAPHelper;
import org.eclipse.alf.security.sso.common.util.SSOHelper;
import org.eclipse.alf.security.sso.common.util.StringHelper;
import org.eclipse.alf.security.sso.common.util.XMLHelper;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.RSTDeserializer;
import org.eclipse.alf.security.sso.common.ws.message.soapengine.secctx.SecurityContext;
import org.eclipse.alf.security.sso.common.ws.model.WSAbstractFactory;
import org.eclipse.alf.security.sso.common.ws.model.addressing.element.EndpointReference;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.SecurityToken;
import org.eclipse.alf.security.sso.common.ws.model.security.secext.token.UsernameToken;
import org.eclipse.alf.security.sso.common.ws.model.trust.WSTrustObjectBuilder;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.OnBehalfOf;
import org.eclipse.alf.security.sso.common.ws.model.trust.element.RequestSecurityToken;
import org.eclipse.alf.security.sso.server.federationserver.FedSrvHelper;
import org.eclipse.alf.security.sso.server.federationserver.PageRedirector;
import org.eclipse.alf.security.sso.server.federationserver.RequestContext;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfig;
import org.eclipse.alf.security.sso.server.federationserver.config.FedSrvRPConfig;
import org.eclipse.alf.security.sso.server.federationserver.handler.FedSvrHandlerException;
import org.eclipse.alf.security.sso.server.federationserver.secctx.SecCtxFilterToLogonAppIncoming;

public class InboundWSTrustHandler {
    private static final Logger log = Logger.getLogger(InboundWSTrustHandler.class);

    public static boolean processRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext) throws ServletException {
        block27: {
            try {
                String payloadString = requestContext.getInboundWsfData().getWreq();
                OMElement payloadElement = null;
                if (StringHelper.isBlank((String)payloadString)) {
                    log.error((Object)"Missing request data: empty wreq");
                    String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.emptyWreq", req.getLocale());
                    PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                    return false;
                }
                try {
                    payloadElement = XMLHelper.toOM((String)payloadString);
                }
                catch (Throwable e) {
                    log.error((Object)("Error trying to build an OM element from wreq: [" + payloadString + "]"), e);
                    String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.invalidWreqXML", req.getLocale());
                    PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                    return false;
                }
                if (SOAPHelper.isSOAPEnvelope((OMElement)payloadElement)) {
                    payloadElement = InboundWSTrustHandler.extractRSTFromSOAP(req, resp, requestContext, payloadString);
                }
                if (!SSOHelper.isRSTElement((OMElement)payloadElement)) {
                    log.error((Object)("Missing RST in wreq: [" + payloadString + "]"));
                    String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.missingRSTInWreq", req.getLocale());
                    PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                    return false;
                }
                RequestSecurityToken rst = InboundWSTrustHandler.extractRequestSecurityTokenFromPayload(req, resp, requestContext, payloadElement);
                if (rst == null) {
                    return false;
                }
                if (!rst.getRequestType().isKnownRequestType()) {
                    log.error((Object)("Unknown RST request type: " + rst.getRequestType().getRequestType()));
                    String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.unknownRSTType", req.getLocale());
                    PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                    return false;
                }
                if (!rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getIssue()) && !rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getCancel())) {
                    log.error((Object)("Unsupported RST request type: " + rst.getRequestType().getRequestType()));
                    String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.unsupportedRSTType", req.getLocale());
                    PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                    return false;
                }
                String rstAppliesTo = InboundWSTrustHandler.extractAppliesToFromRST(req, resp, rst, requestContext);
                if (StringHelper.isNotBlank((String)rstAppliesTo)) {
                    RPURI rpuri = RPURI.createRPURI((String)rstAppliesTo);
                    if (rpuri == null) {
                        log.error((Object)("RST/AppliesTo contains malformed RPURI: " + rstAppliesTo));
                        String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.malformedAppliesTo", req.getLocale());
                        localizedError = MessageFormat.format(localizedError, rstAppliesTo);
                        PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                        return false;
                    }
                    FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuri.toString());
                    if (rpConfig == null) {
                        log.error((Object)("Cannot find configuration for relying party URI: " + rpuri.toString()));
                        String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.noMatchingConfigurationFound", req.getLocale());
                        localizedError = MessageFormat.format(localizedError, rpuri.toString());
                        PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                        return false;
                    }
                    requestContext.setAppliesToURI(rstAppliesTo);
                    requestContext.setRpConfig(rpConfig);
                }
                requestContext.setRST(rst);
                requestContext.setRSTElement(rst.toOM());
                if (rst.getRequestType().getRequestType().equals(rst.getWSTrust().RequestTypes.getCancel())) {
                    SSOToken cancelTarget = null;
                    try {
                        cancelTarget = SSOTokenFactory.createSSOToken((Object)rst.getCancelTarget().getSecurityToken().getNativeObject());
                    }
                    catch (SSOException e) {
                        log.error((Object)("Error processing request: could not extract cancel target from [" + payloadString + "]"));
                        String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.failedToExtractCancelTarget", req.getLocale());
                        PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                        return false;
                    }
                    requestContext.setCancelTarget(cancelTarget);
                    String[] appliesToRelyingParties = cancelTarget.getTargetRelyingParties();
                    if (appliesToRelyingParties != null && appliesToRelyingParties.length > 0) {
                        String rpuriString = appliesToRelyingParties[0];
                        if (StringHelper.isBlank((String)rpuriString)) {
                            log.error((Object)("Error processing request: invalid cancel target: no audience restriction: [" + payloadString + "]"));
                            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.failedToExtractCancelTarget", req.getLocale());
                            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                            return false;
                        }
                        RPURI rpuri = RPURI.createRPURI((String)rpuriString);
                        if (rpuri == null) {
                            log.error((Object)("Error processing request: invalid cancel target: non-compatible RPURI: [" + payloadString + "]"));
                            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.invalidCancelTarget", req.getLocale());
                            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                            return false;
                        }
                        requestContext.setAppliesToURI(rpuriString);
                        FedSrvRPConfig rpConfig = FedSrvConfig.getInstance().getRPConfig(rpuri.toString());
                        if (rpConfig == null) {
                            log.error((Object)("Error processing request: failed to find matching configuration context: [" + rpuriString + "]"));
                            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.unknownRelyingParty", req.getLocale());
                            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                            return false;
                        }
                        requestContext.setRpConfig(rpConfig);
                    }
                    break block27;
                }
                UsernameToken rstUsernameToken = InboundWSTrustHandler.extractUsernameTokenFromRSTOnBehalfOfElement(req, resp, requestContext, rst, payloadElement);
                if (rstUsernameToken != null) {
                    boolean forceLocalAuthnPrompt = requestContext.getRpConfig().getCoreConfig().getBooleanParameter("ForceLocalAuthentication", false);
                    if (forceLocalAuthnPrompt) {
                        rst.setOnBehalfOf(null);
                        requestContext.setPrincipalCredentialsAquired(false);
                    } else {
                        requestContext.setPrincipalUsername(rstUsernameToken.getUsername());
                        requestContext.setPrincipalPassword(null);
                        requestContext.setPrincipalCredentialsAquired(true);
                        requestContext.setAuthCredentialsInRST(true);
                    }
                } else {
                    Principal principal = req.getUserPrincipal();
                    if (principal != null) {
                        boolean useExistingPrincipal = requestContext.getRpConfig().getCoreConfig().getBooleanParameter("UsePrincipalUserIfPresent", false);
                        boolean isAllowedAuthnType = requestContext.getRpConfig().getCoreConfig().isAllowedPreauthenticationType(req.getAuthType());
                        if (useExistingPrincipal && isAllowedAuthnType) {
                            log.debug((Object)("Using principal user: " + principal.getName() + "/" + req.getAuthType()));
                            InboundWSTrustHandler.addPrincipalToRSTWithinOnBehalfOfElement(req, resp, principal.getName(), rst, payloadElement);
                            requestContext.setPrincipalUsername(principal.getName());
                            requestContext.setPrincipalPassword(null);
                            requestContext.setPrincipalCredentialsAquired(true);
                            requestContext.setAuthCredentialsInRST(true);
                        } else {
                            log.warn((Object)("Principal user is found on the request but authentication type is not allowed:" + principal.getName() + "/" + req.getAuthType()));
                        }
                    }
                }
            }
            catch (FedSvrHandlerException e) {
                log.error((Object)"FedSvrHandler Exception", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static OMElement extractRSTFromSOAP(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, String payloadString) throws FedSvrHandlerException, ServletException {
        SOAPEnvelope payloadElement = null;
        try {
            payloadElement = SOAPHelper.buildSOAPElement((String)payloadString);
        }
        catch (Throwable e) {
            log.error((Object)("Error trying to build a SOAP element from wreq: [" + payloadString + "]"), e);
            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.badRequestXML", req.getLocale());
            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
            throw new FedSvrHandlerException();
        }
        log.debug((Object)"Received SOAP message containing RST element");
        CoreConfig rpCoreConfig = requestContext.getRpConfig().getCoreConfig();
        try {
            RSTDeserializer soapDeserializer = new RSTDeserializer(rpCoreConfig.getAxis2ConfigurationContextReceiver());
            SecCtxFilterToLogonAppIncoming securityContext = new SecCtxFilterToLogonAppIncoming();
            soapDeserializer.setSecurityContext((SecurityContext)securityContext);
            payloadElement = soapDeserializer.receiveSOAPMessage(payloadElement.toString());
        }
        catch (SSOException e) {
            log.error((Object)("Error deserializing SOAP message:[" + payloadString + "]"), (Throwable)e);
            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.badRequestSOAP", req.getLocale());
            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
            throw new FedSvrHandlerException();
        }
        catch (AxisFault e) {
            log.error((Object)("Axis fault: Error sending/receiving SOAP message locally:[" + payloadString + "]"), (Throwable)e);
            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.failedSOAPProcessing", req.getLocale());
            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
            throw new FedSvrHandlerException();
        }
        return payloadElement;
    }

    private static RequestSecurityToken extractRequestSecurityTokenFromPayload(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        RequestSecurityToken rst = null;
        try {
            rst = WSTrustObjectBuilder.buildRequestSecurityToken((OMElement)payloadElement);
        }
        catch (SSOException e) {
            log.error((Object)("Error deserializing RST element: [" + payloadElement.toString() + "]"));
            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.failedRSTProcessing", req.getLocale());
            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
            return null;
        }
        return rst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UsernameToken extractUsernameTokenFromRSTOnBehalfOfElement(HttpServletRequest req, HttpServletResponse resp, RequestContext requestContext, RequestSecurityToken rst, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        UsernameToken onBehalfOfUsernameToken = null;
        if (rst.getOnBehalfOf() == null) return onBehalfOfUsernameToken;
        if (rst.getOnBehalfOf().getSecurityToken() != null) {
            if (rst.getOnBehalfOf().getSecurityToken().getType().equals("UsernameToken")) {
                onBehalfOfUsernameToken = (UsernameToken)rst.getOnBehalfOf().getSecurityToken().getNativeObject();
                if (onBehalfOfUsernameToken.getUsername() != null && onBehalfOfUsernameToken.getUsername().trim().length() != 0) return onBehalfOfUsernameToken;
                log.error((Object)("Unsuppored RST - incompatible profile - missing <Username>: [" + payloadElement.toString() + "]"));
                String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.invalidRST.missingUsernameElement", req.getLocale());
                PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
                throw new FedSvrHandlerException();
            }
            log.error((Object)("Unsuppored RST - incompatible profile - incompatible token: [" + payloadElement.toString() + "]"));
            String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.invalidRST.incompatibleToken", req.getLocale());
            PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
            throw new FedSvrHandlerException();
        }
        log.error((Object)("Unsuppored RST - incompatible profile - missing <UsernameToken>: [" + payloadElement.toString() + "]"));
        String localizedError = FedSrvHelper.getLocalizedMessage("fedsvr.requestProcessTrust.invalidRST.missingUsernameToken", req.getLocale());
        PageRedirector.redirectAppError(req, resp, requestContext, localizedError);
        throw new FedSvrHandlerException();
    }

    private static RequestSecurityToken addPrincipalToRSTWithinOnBehalfOfElement(HttpServletRequest req, HttpServletResponse resp, String principal, RequestSecurityToken rst, OMElement payloadElement) throws FedSvrHandlerException, ServletException {
        OnBehalfOf onBehalfOf = rst.getWSTrust().getObjectFactory().createOnBehalfOf();
        UsernameToken usernameToken = WSAbstractFactory.getWSSEObjectFactory().createUsernameToken();
        usernameToken.addId();
        usernameToken.addCreated();
        usernameToken.setUsername(principal);
        onBehalfOf.setSecurityToken((SecurityToken)usernameToken);
        rst.setOnBehalfOf(onBehalfOf);
        return rst;
    }

    private static String extractAppliesToFromRST(HttpServletRequest req, HttpServletResponse resp, RequestSecurityToken rst, RequestContext requestContext) throws FedSvrHandlerException, ServletException {
        if (rst.getAppliesTo() == null) {
            return null;
        }
        if (rst.getAppliesTo().getKnownObjectsList() == null) {
            return null;
        }
        if (rst.getAppliesTo().getKnownObjectsList().size() == 0) {
            return null;
        }
        Iterator it = rst.getAppliesTo().getKnownObjectsList().iterator();
        if (it != null) {
            while (it.hasNext()) {
                EndpointReference epr;
                Object obj = it.next();
                if (!(obj instanceof EndpointReference) || (epr = (EndpointReference)obj).getAddress() == null || epr.getAddress().getAddress() == null) continue;
                return epr.getAddress().getAddress();
            }
        }
        return null;
    }
}

