<%@ page contentType="text/html" %>

<%-- Use the taglibs for Servlet Spec 2.4, JSP 2.0, and JSTL 1.1 --%>
<%@ taglib prefix="c"   uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<!-- Determine the Resource bundle for I18N and customizing ALF SSO page appearance -->
<!-- Choice of bundle used is driven by browsers Accept-Language Header -->
<fmt:bundle basename="i18n.ALFSSOI18N">

<html>
<!--loginform-->
 <head>
  <title><fmt:message key="loginPageTitle" /></title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <script type="text/javascript">

      function init() {
        document.LoginForm.authUID.focus();
        
        if(top != self) {//if the login page is in a frame, we need to reload the top
          top.location.reload();
        }
     }
    </script>
    
  <style type="text/css">
    body {
      background-color:<fmt:message key="pageBackgroundColor" />;;
      FONT-WEIGHT:normal;
      MARGIN:80px;
      color:black;
      font-family:Verdana;
      font-size:12;
    }
    .inputField
    {
      font-size:14;
      width:100%;
    }
    .inputButton
    {
      padding-top:5px;
      padding-bottom:5px;
      padding-left:10px;
      padding-right:10px;
      font-size:12;
    }
    .label
    {
      color:black;
      font-family:Verdana;
      font-size:12;
    }
    .heading
    {
      font-family:Verdana;
      font-size:24;
    }
    .wrapper
    {
      vertical-align:center;
      background-color:white;
      border: 3px groove #181818;
      text-align:middle;
      width:70%;
    }
    .warningHeading
        {
          vertical-align:center;
          background-color:white;
          text-align:middle;
          color:black;
          FONT-WEIGHT:bold;
          font-family:Verdana;
          font-size:18;
    }
    .warningText
    {
      vertical-align:center;
      background-color:white;
      border: 1px groove #181818;
      text-align:middle;
      width:90%;
      color:black;
      font-family:Verdana;
      font-size:7;
    }
    A 
    {
      font-size:12;
      text-decoration:none;
      color:#4D463B;
    }
    A.visited 
    {
      color:#4D463B;
    }
    A.notVisited 
    {
      color:#4D463B;
    }    
    A:hover, A.visited:hover, A.notVisited:hover 
    { 
      text-decoration:none;
      border-bottom:dashed 1px;
    }
    .err
    {
      color:Maroon;
      font-size:16;
    }
  </style>

</head>


<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onLoad="init();">

<!--FOR I18N DEBUGGING Resource Bundle processing
<table width="100%" border="0" cellspacing="0" 
       cellpadding="8" bgcolor="#EEEEEE">
       
    <tr><td><b>Name</b></td><td><b>Value</b></td></tr>
    <tr><td colspan="2" width="100%" height="2" bgcolor="#000000"></td></tr>
    
    <c:forEach var="hname" items="${pageContext.request.headerNames}">
    
        <c:forEach var="hvalue" items="${headerValues[hname]}">
	
            <tr><td valign="top"><c:out value="${hname}"/></td>
            <td valign="top"><c:out value="${hvalue}"/></td></tr>
            <tr><td colspan="2" bgcolor="#000000" width="100%" height="1"></td></tr>
	    
        </c:forEach>
	
    </c:forEach>
</table>

<H1>HTTP Headers and JSTL variables access to HTTP header info</H1>
<c:set var="browser" value="${header['User-Agent']}"/>
<P>UserAgent  : <c:out value="${browser}" /></P>
<P>header Accept-L: <c:out value="${header['Accept-Language']}" default="NULL" /></P>
<P>calc       : <c:out value="${1 + 2 + 3}" /> (Simple test if JSTL is working.)<\P>
<P>Browser's Accept-Language HTTP header: <c:out value="${header['Accept-Language']}" default="NULL" /></P>
<P>Using strings from resource bundle for: <fmt:message key="resourceBundleLocale" /></P>
END OF I18N DEBUGGING -->


<!-- Extract sessionContext attributes  -->
<c:set var="opaque"          scope="page" value="${ATTR_OPAQUE}" />
<c:set var="rpFriendlyName"  scope="page" value="${ATTR_RP_FRIENDLY_NAME}" />
<c:set var="replyURL"        scope="page" value="${ATTR_WREPLY}" />

<!-- Construct the welcome message on the login page  -->
<fmt:message key="loginPageWelcomeString" var="welcomeTo" scope="page" />
<fmt:message key="loginPageWelcomeWord"   var="welcomeOnly" scope="page" />
<c:choose>
  <c:when test="${not empty rpFriendlyName}">
     <c:set var="welcomeMessage" scope="page" value="${welcomeTo} ${rpFriendlyName}" />
  </c:when>
  <c:otherwise>
    <c:set var="welcomeMessage" scope="page" value="${welcomeOnly}" />
  </c:otherwise>
</c:choose>


<!-- TO DO: Can we replace the following Scriptlet with JSTL Expression Language -->
<%
		String authType = request.getAuthType();
		if (authType == null) authType = new String();
		if (authType.equals("NTLM") == false) {
			String message = (String) request.getAttribute("ATTR_MESSAGE");
			
			if (request.getAttribute("ATTR_MESSAGE") != null) {
				request.removeAttribute("ATTR_MESSAGE");
			}
%>

  <center>
    <div class=wrapper>

      <br><br>
      <img src="<fmt:message key="systemLogo" />" align="left"alt="<fmt:message key="systemLogoAlt" />" title="<fmt:message key="systemLogoTitle" />">
      <br clear="left" />
      <p>
      <center>
        <span class="heading"><c:out value="${welcomeMessage}" /></span><p></p>
        
        <p class=""warningHeading"><fmt:message key="loginWarningStatementTitle" /></p>
        <p class="warningText"><font face="Arial" size="-3" color="#000066">
           <fmt:message key="loginWarningLine1" />
           <fmt:message key="loginWarningLine2" />
           <fmt:message key="loginWarningLine3" />
           <fmt:message key="loginWarningLine4" />
           <fmt:message key="loginWarningLine5" />
           <fmt:message key="loginWarningLine6" />
           <fmt:message key="loginWarningLine7" />
           <fmt:message key="loginWarningLine8" />
           <fmt:message key="loginWarningLine9" />
         </p>

        <form name="LoginForm" method="POST" action="login" onsubmit="return doSubmit()">

          <table summary="" border="0" cellspacing="10" cellpadding="5" width="60%">
            <tr>
              <td align="left" class="label">
                 <label for="authUID"><fmt:message key="loginUserIdLabel" />:</label></td>
              <td class="middle" width="100%">
                 <input class="inputField" type="text" id="authUID" name="username" size="36" title="<fmt:message key="loginUserIdTitle" />">
              </td>
            </tr>
            <tr>
              <td align="left" class="label">
                 <label for="authPWD"><fmt:message key="loginPasswordLabel" />:</label></td>
              <td class="middle" width="100%">
                 <input class="inputField" type="password" id="authPWD" name="password" size="36" title="<fmt:message key="loginPasswordTitle" />">
              </td>
            </tr>
            <tr>
              <td colspan="2" align="center" class="middle">
                 <input class="inputButton" type="submit" name="Submit" value="<fmt:message key="loginSubmitButtonName" />" title="<fmt:message key="loginSubmitTitle" />">
                 <!-- Hidden field for application to pass data -->
                 <input type="hidden" name="opaque" value="<c:out value="${opaque}" />"/>
              </td>
            </tr>
            <tr>
              <td colspan="2" align="center" class="middle"><span class="err"></span></td>
            </tr>
            
            <c:if test="${not empty replyURL}">
		<tr>
   		    <td colspan="2" align="center">
			<a href="<c:out value="${replyURL}" />"><c:out value="${replyURL}" /></a>
		    </td>
		</tr>
	     </c:if>
         
 	     <!-- TO DO: Replace the following Scriptlet with JSTL Expression Language -->           
             <% if (message != null) { %>
		<tr>
		    <td colspan="2" align="center">
			<%=message%>
		    </td>
		</tr>
             <% } %>		             
          </table>
          
          <p align="right"><font face="Arial" size="-1"color="#000066">
	     <i><fmt:message key="poweredByALF" />&nbsp;&nbsp;</i>
	 </p>
          
        </form>
        
<%} else { 
	request.getRequestDispatcher("/login").forward(request, response);
}
%>        

      </center>
    </div>
  </center>
</body>
</html>
</fmt:bundle>
