<%@ page contentType="text/html" %>

<%-- Use the taglibs for Servlet Spec 2.4, JSP 2.0, and JSTL 1.1 --%>
<%@ taglib prefix="c"   uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<%@page import="java.util.ArrayList"%>
<%@page import="java.util.HashSet"%>
<%@page import="java.util.Iterator"%>


<!-- Determine the Resource bundle for I18N and customizing ALF SSO page appearance -->
<!-- Choice of bundle used is driven by browsers Accept-Language Header -->
<fmt:bundle basename="i18n.ALFSSOI18N">

<html>
<!--logoutform-->
 <head>
  <title><fmt:message key="logoutPageTitle" /></title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <script type="text/javascript">

      function init() {
        
        if(top != self) {//if the login page is in a frame, we need to reload the top
          top.location.reload();
        }
     }
    </script>
        
  <style type="text/css">
    body {
      background-color:<fmt:message key="pageBackgroundColor" />;;
      FONT-WEIGHT:normal;
      MARGIN:80px;
      color:black;
      font-family:Verdana;
      font-size:12;
    }
    .inputField
    {
      font-size:14;
      width:100%;
    }
    .inputButton
    {
      padding-top:5px;
      padding-bottom:5px;
      padding-left:10px;
      padding-right:10px;
      font-size:12;
    }
    .label
    {
      color:black;
      font-family:Verdana;
      font-size:12;
    }
    .heading
    {
      font-family:Verdana;
      font-size:24;
    }
    .wrapper
    {
      vertical-align:center;
      background-color:white;
      border: 3px groove #181818;
      text-align:middle;
      width:70%;
    }
    A 
    {
      font-size:12;
      text-decoration:none;
      color:#4D463B;
    }
    A.visited 
    {
      color:#4D463B;
    }
    A.notVisited 
    {
      color:#4D463B;
    }    
    A:hover, A.visited:hover, A.notVisited:hover 
    { 
      text-decoration:none;
      border-bottom:dashed 1px;
    }
    .err
    {
      color:Maroon;
      font-size:16;
    }
  </style>

</head>

<!-- Extract sessionContext attributes  -->
<c:set var="replyURL"        scope="page" value="${ATTR_WREPLY}" />


		<%
		ArrayList signoutURIs = (ArrayList) request.getAttribute("ATTR_LOGOUT_SIGNOUT_URLS");
		if (signoutURIs == null)
			signoutURIs = new ArrayList();
		HashSet signoutFriendlyNames = (HashSet) request.getAttribute("ATTR_SIGNOUT_SERVICE_NAMES");
		if (signoutFriendlyNames == null)
			signoutFriendlyNames = new HashSet();
		%>
		
<c:set var="logoutSubject"   scope="page" value="${ATTR_LOGOUT_SUBJECT}" />
<c:choose>
  <c:when test="${not empty logoutSubject}">
     <fmt:message key="logoutLogoutOnly"  var="msgFrag" scope="page"/>
     <c:set var="msg" scope="page" value="${msgFrag} ${logoutSubject}" />
  </c:when>
  <c:otherwise>
     <fmt:message key="logoutLogoutOnly"  var="msg" scope="page"/>
  </c:otherwise>
</c:choose>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onLoad="init();">

<!--FOR I18N DEBUGGING Resource Bundle processing
<table width="100%" border="0" cellspacing="0" 
       cellpadding="8" bgcolor="#EEEEEE">
       
    <tr><td><b>Name</b></td><td><b>Value</b></td></tr>
    <tr><td colspan="2" width="100%" height="2" bgcolor="#000000"></td></tr>
    
    <c:forEach var="hname" items="${pageContext.request.headerNames}">
    
        <c:forEach var="hvalue" items="${headerValues[hname]}">
	
            <tr><td valign="top"><c:out value="${hname}"/></td>
            <td valign="top"><c:out value="${hvalue}"/></td></tr>
            <tr><td colspan="2" bgcolor="#000000" width="100%" height="1"></td></tr>
	    
        </c:forEach>
	
    </c:forEach>
</table>

<H1>HTTP Headers and JSTL variables access to HTTP header info</H1>
<c:set var="browser" value="${header['User-Agent']}"/>
<P>UserAgent  : <c:out value="${browser}" /></P>
<P>header Accept-L: <c:out value="${header['Accept-Language']}" default="NULL" /></P>
<P>calc       : <c:out value="${1 + 2 + 3}" /> (Simple test if JSTL is working.)<\P>
<P>Browser's Accept-Language HTTP header: <c:out value="${header['Accept-Language']}" default="NULL" /></P>
<P>Using strings from resource bundle for: <fmt:message key="resourceBundleLocale" /></P>
END OF I18N DEBUGGING -->

  <center>
    <div class=wrapper>

      <br><br>
      <img src="<fmt:message key="logoutLogo" />" align="left"alt="<fmt:message key="logoutLogoAlt" />" title="<fmt:message key="logoutLogoTitle" />">
      <br clear="left" />
      <p>
      <center>
        <span class="heading"><c:out value="${msg}" /></span><p></p>
		<table summary="" border="0" cellspacing="10" cellpadding="5" width="60%">
			<% Iterator it = signoutFriendlyNames.iterator();
				while (it.hasNext()) { 
			%>
					<tr><td align="center" class="label"><fmt:message key="logoutLoggingOutOf" /> "<%=(String) it.next()%>"</td></tr>
			<% } %>
			
			<!-- Display the reply URL -->
			<c:if test="${not empty replyURL}">
				<tr><td colspan="2" align="center"><a href="<c:out value="${replyURL}" />"><fmt:message key="logoutReloginPrompt" /></a></td></tr>
			</c:if>             
			
		</table>
		
		<% for (int i=0; i < signoutURIs.size(); i ++) { %>
			<div style="visibility:hidden"><iframe src="<%=(String)signoutURIs.get(i)%>"></iframe></div>
		<% } %>
      </center>
    </div>
  </center>
</body>
</html>
</fmt:bundle>
