<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<%@ page contentType="text/html" %>

<%-- Use the taglibs for Servlet Spec 2.4, JSP 2.0, and JSTL 1.1 --%>
<%@ taglib prefix="c"   uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<%@page import="org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedData"%>
<%@page import="org.eclipse.alf.security.sso.common.ws.federation.passive.remotedata.RemoteDataStorage"%>
<%@page import="org.eclipse.alf.security.sso.server.federationserver.PageRedirector"%>
<%@page import="org.eclipse.alf.security.sso.server.federationserver.config.FedSrvConfigConstants"%>
<%@page import="org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedConstants"%>
<%@page import="org.eclipse.alf.security.sso.common.http.configuration.CoreConfigConstants"%>
<%@page import="org.eclipse.alf.security.sso.common.util.StringHelper"%>
<%@page import="org.eclipse.alf.security.sso.common.ws.federation.passive.WSFedHelper"%>
<%@page import="org.eclipse.alf.security.sso.common.util.EscapeCharHelper"%>

<!-- Determine the Resource bundle for I18N and customizing ALF SSO page appearance -->
<!-- Choice of bundle used is driven by browsers Accept-Language Header -->
<fmt:bundle basename="i18n.ALFSSOI18N">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">

	<%
		response.setHeader("Expires","19-Mar-1971 08:23:00 GMT");
		response.setHeader("Cache-control","no-cache");
		response.setHeader("Pragma","no-cache");
		
		WSFedData wsfData = null;
		wsfData = WSFedHelper.getWSFDataFromRequestAttributes(request);
		String rdKey = request.getParameter(PageRedirector.RD_PARAM);
		String redirectMethod = (String) request.getAttribute(PageRedirector.METHOD_ATTR);
		if (StringHelper.isBlank(redirectMethod)) {
			redirectMethod = (String) request.getParameter(PageRedirector.METHOD_PARAM);
		}
		if ((StringHelper.isBlank(redirectMethod)) || 
			((redirectMethod.equalsIgnoreCase("POST") == false) &&
			 (redirectMethod.equalsIgnoreCase("GET") == false))) {
			
			redirectMethod = CoreConfigConstants.HTTP_REDIRECT_METHOD_DEFAULT;
		}
		
		if (rdKey != null) {
			RemoteDataStorage rd = RemoteDataStorage.getInstance();
			wsfData = (WSFedData) rd.getDataWithRemove(rdKey);
		}
	%>

	<head>
		<!-- <meta http-equiv="refresh" content="0;url=<%=wsfData.getWreply()%>"/> -->
	    <title><fmt:message key="redirectPageTitle" /></title>
	</head>

	<body onload="document.forms[0].submit()">
	
		<script type="text/javascript">
			document.write("<p><fmt:message key="redirectPageJSMessage" /></p>");
		</script>	
		
		<noscript>
			<p>
				<strong><fmt:message key="redirectPageNoJSMessageLeader" /></strong><fmt:message key="redirectPageNoJSMessageLeader" />
			</p>
		</noscript>
		
	
		<form id="postRedirect"  action="<%=wsfData.getWreply()%>" method="<%=redirectMethod%>">
			<div>
				<%if (StringHelper.isNotBlank(wsfData.getWa())) {%>
					<input type="hidden" name="<%=WSFedConstants.PARAM_WA%>" value="<%=EscapeCharHelper.forHTMLTag(wsfData.getWa())%>"/>
				<%}%>
				<%if (StringHelper.isNotBlank(wsfData.getWctx())) {%>
					<input type="hidden" name="<%=WSFedConstants.PARAM_WCTX%>" value="<%=EscapeCharHelper.forHTMLTag(wsfData.getWctx())%>"/>
				<%}%>
				<%if (StringHelper.isNotBlank(wsfData.getWresult())) {%>
					<input type="hidden" name="<%=WSFedConstants.PARAM_WRESULT%>" value="<%=EscapeCharHelper.forHTMLTag(wsfData.getWresult())%>"/>
				<%}%>
				<%if (StringHelper.isNotBlank(wsfData.getWresultptr())) {%>
					<input type="hidden" name="<%=WSFedConstants.PARAM_WRESULTPTR%>" value="<%=EscapeCharHelper.forHTMLTag(wsfData.getWresultptr())%>"/>
				<%}%>
			</div>
			
			<noscript>
				<div>
				<input type="submit" value="<fmt:message key="redirectPageContinueButtonName" />" />
				</div>
			</noscript>
		</form>
	</body>
</html>
</fmt:bundle>
