/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.ImaDestinationType;
import com.ibm.ima.plugin.ImaPluginException;
import com.ibm.ima.plugin.impl.ImaMessageImpl;
import com.ibm.ima.plugin.impl.ImaPluginConstants;
import com.ibm.ima.plugin.impl.ImaPluginMain;
import com.ibm.ima.plugin.impl.ImaXidImpl;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;

public class ImaPluginUtils
implements ImaPluginConstants {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    static final ThreadLocal<byte[]> tempByte = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1000];
        }
    };
    static final ThreadLocal<char[]> tempChar = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1000];
        }
    };
    private static final int[] States = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 1};
    private static final int[] StateMask = new int[]{0, 0, 31, 15, 7};

    private ImaPluginUtils() {
    }

    static final ByteBuffer ensureBuffer(ByteBuffer bb, int len) {
        if (bb != null) {
            if (bb.remaining() >= len) {
                return bb;
            }
            int newlen = bb.capacity() + len + 1024;
            ByteBuffer newbb = bb.isDirect() ? ByteBuffer.allocateDirect(newlen) : ByteBuffer.allocate(newlen);
            bb.flip();
            newbb.put(bb);
            return newbb;
        }
        bb = ByteBuffer.allocate(len + 1024);
        return bb;
    }

    static final int getObjectType(ByteBuffer bb) {
        if (bb.remaining() == 0) {
            ImaPluginException jex = new ImaPluginException("CWLNA0013", "The end of the message has been reached.");
            throw jex;
        }
        return bb.get() & 0xFF;
    }

    static final void checkBodyLength(ByteBuffer bb, int len) {
        if (bb == null || bb.remaining() < len) {
            ImaPluginException jex = new ImaPluginException("CWLNA0105", "The message data is not valid");
            throw jex;
        }
    }

    static final String getStringValue(ByteBuffer bb, int otype) {
        int len;
        ImaPluginConstants.S_Type type = FieldTypes[otype];
        switch (type) {
            case StrLen: {
                len = ImaPluginUtils.getIntValue(bb, otype - 40);
                break;
            }
            case String: {
                len = otype & 0x3F;
                break;
            }
            default: {
                return null;
            }
        }
        ImaPluginUtils.checkBodyLength(bb, len);
        String s = ImaPluginUtils.fromUTF8(bb, len - 1, true);
        if (bb.get() != 0) {
            // empty if block
        }
        return s;
    }

    static final String getNameValue(ByteBuffer bb, int otype) {
        int len;
        ImaPluginConstants.S_Type type = FieldTypes[otype];
        short id = 0;
        switch (type) {
            case Name: {
                len = otype & 0x1F;
                break;
            }
            case NameLen: {
                len = ImaPluginUtils.getIntValue(bb, otype);
                break;
            }
            case ID: {
                int len2 = otype & 3;
                id = len2 == 3 ? -ImaPluginUtils.getShortValue(bb, 2) : ImaPluginUtils.getShortValue(bb, len2);
                return "" + id;
            }
            default: {
                ImaPluginException jex = new ImaPluginException("CWLNA0105", "The message content data is not valid.");
                throw jex;
            }
        }
        ImaPluginUtils.checkBodyLength(bb, len);
        String s = ImaPluginUtils.fromUTF8(bb, len - 1, true);
        if (bb.get() != 0) {
            // empty if block
        }
        return s;
    }

    static final byte getByteValue(ByteBuffer bb, int otype) {
        if (otype >= 48) {
            return (byte)(otype - 48);
        }
        ImaPluginUtils.checkBodyLength(bb, 1);
        return bb.get();
    }

    static final char getCharValue(ByteBuffer bb, int otype) {
        return (char)ImaPluginUtils.getShortValue(bb, otype);
    }

    static final short getShortValue(ByteBuffer bb, int otype) {
        int len = otype & 3;
        int val = 0;
        ImaPluginUtils.checkBodyLength(bb, len);
        while (len-- > 0) {
            val = val << 8 | bb.get() & 0xFF;
        }
        return (short)val;
    }

    static final int getIntValue(ByteBuffer bb, int otype) {
        int len = otype & 7;
        int val = 0;
        ImaPluginUtils.checkBodyLength(bb, len);
        while (len-- > 0) {
            val = val << 8 | bb.get() & 0xFF;
        }
        return val;
    }

    static final long getLongValue(ByteBuffer bb, int otype) {
        int len = otype & 0xF;
        long val = 0L;
        ImaPluginUtils.checkBodyLength(bb, len);
        while (len-- > 0) {
            val = val << 8 | (long)(bb.get() & 0xFF);
        }
        return val;
    }

    static final float getFloatValue(ByteBuffer bb, int otype) {
        if ((otype & 1) == 0) {
            return 0.0f;
        }
        return Float.intBitsToFloat(ImaPluginUtils.getIntValue(bb, 4));
    }

    static final double getDoubleValue(ByteBuffer bb, int otype) {
        if ((otype & 1) == 0) {
            return 0.0;
        }
        return Double.longBitsToDouble(ImaPluginUtils.getLongValue(bb, 8));
    }

    static final ByteBuffer getByteBufferValue(ByteBuffer bb, int otype) {
        int len = ImaPluginUtils.getIntValue(bb, otype);
        ImaPluginUtils.checkBodyLength(bb, len);
        byte[] ba = new byte[len];
        bb.get(ba);
        ByteBuffer result = ByteBuffer.wrap(ba);
        return result;
    }

    static final byte[] getByteArrayValue(ByteBuffer bb, int otype) {
        int len = ImaPluginUtils.getIntValue(bb, otype);
        ImaPluginUtils.checkBodyLength(bb, len);
        byte[] ba = new byte[len];
        bb.get(ba);
        return ba;
    }

    static final Object getUserValue(ByteBuffer bb, int otype) {
        int len = ImaPluginUtils.getIntValue(bb, otype);
        Object ret = null;
        ImaPluginUtils.checkBodyLength(bb, len);
        int kind = bb.get() & 0xFF;
        if (kind >= 96 && kind < 128) {
            ret = ImaPluginUtils.fromUTF8(bb, len - 1, true);
        } else {
            byte[] ba = new byte[len - 1];
            bb.get(ba);
            ret = ByteBuffer.wrap(ba);
        }
        return ret;
    }

    static final Object getXidValue(ByteBuffer bb, int otype) {
        int formatid = 0;
        int len = bb.get() & 0xFF;
        int branchq_len = 0;
        int globalid_len = 0;
        ImaPluginUtils.checkBodyLength(bb, len);
        if (len >= 6) {
            formatid = bb.getInt();
            globalid_len = bb.get() & 0xFF;
            branchq_len = bb.get() & 0xFF;
        }
        if (len != branchq_len + globalid_len + 6) {
            ImaPluginException jex = new ImaPluginException("CWLNA0105", "The message data is not valid");
            throw jex;
        }
        byte[] branchq = new byte[branchq_len];
        bb.get(branchq);
        byte[] globalid = new byte[globalid_len];
        bb.get(globalid);
        ImaXidImpl ret = new ImaXidImpl(formatid, globalid, branchq);
        return ret;
    }

    static final int getInteger(ByteBuffer bb) {
        int ret;
        int otype = ImaPluginUtils.getObjectType(bb);
        ImaPluginConstants.S_Type type = FieldTypes[otype];
        switch (type) {
            case Int: 
            case UInt: {
                ret = ImaPluginUtils.getIntValue(bb, otype);
                break;
            }
            case Byte: {
                ret = ImaPluginUtils.getByteValue(bb, otype);
                break;
            }
            case UByte: {
                ret = ImaPluginUtils.getByteValue(bb, otype) & 0xFF;
                break;
            }
            case Short: {
                ret = ImaPluginUtils.getShortValue(bb, otype);
                break;
            }
            case UShort: {
                ret = ImaPluginUtils.getShortValue(bb, otype) & 0xFFFF;
                break;
            }
            case Char: {
                ret = ImaPluginUtils.getCharValue(bb, otype);
                break;
            }
            case Null: {
                ret = 0;
                break;
            }
            case Boolean: {
                ret = otype & 1;
                break;
            }
            default: {
                ret = -1;
            }
        }
        return ret;
    }

    static final long getLong(ByteBuffer bb) {
        long ret;
        int otype = ImaPluginUtils.getObjectType(bb);
        ImaPluginConstants.S_Type type = FieldTypes[otype];
        switch (type) {
            case Long: 
            case ULong: {
                ret = ImaPluginUtils.getLongValue(bb, otype);
                break;
            }
            case Int: 
            case UInt: {
                ret = ImaPluginUtils.getIntValue(bb, otype);
                break;
            }
            case Byte: {
                ret = ImaPluginUtils.getByteValue(bb, otype);
                break;
            }
            case UByte: {
                ret = ImaPluginUtils.getByteValue(bb, otype) & 0xFF;
                break;
            }
            case Short: {
                ret = ImaPluginUtils.getShortValue(bb, otype);
                break;
            }
            case UShort: {
                ret = ImaPluginUtils.getShortValue(bb, otype) & 0xFFFF;
                break;
            }
            case Char: {
                ret = ImaPluginUtils.getCharValue(bb, otype);
                break;
            }
            case Null: {
                ret = 0L;
                break;
            }
            case Boolean: {
                ret = otype & 1;
                break;
            }
            default: {
                ret = -1L;
            }
        }
        return ret;
    }

    static final Object getObjectValue(ByteBuffer bb) {
        HashMap<String, Object> obj;
        int otype = ImaPluginUtils.getObjectType(bb);
        ImaPluginConstants.S_Type type = FieldTypes[otype];
        switch (type) {
            case Null: {
                obj = null;
                break;
            }
            case Boolean: {
                obj = (otype & 1) == 1;
                break;
            }
            case Byte: {
                obj = ImaPluginUtils.getByteValue(bb, otype);
                break;
            }
            case UByte: {
                obj = ImaPluginUtils.getByteValue(bb, otype) & 0xFF;
                break;
            }
            case Short: {
                obj = ImaPluginUtils.getShortValue(bb, otype);
                break;
            }
            case UShort: {
                obj = ImaPluginUtils.getShortValue(bb, otype) & 0xFFFF;
                break;
            }
            case Char: {
                obj = Character.valueOf(ImaPluginUtils.getCharValue(bb, otype));
                break;
            }
            case Int: 
            case UInt: {
                obj = ImaPluginUtils.getIntValue(bb, otype);
                break;
            }
            case Long: 
            case ULong: 
            case Time: {
                obj = ImaPluginUtils.getLongValue(bb, otype);
                break;
            }
            case Float: {
                obj = Float.valueOf(ImaPluginUtils.getFloatValue(bb, otype));
                break;
            }
            case Double: {
                obj = ImaPluginUtils.getDoubleValue(bb, otype);
                break;
            }
            case StrLen: 
            case String: {
                obj = ImaPluginUtils.getStringValue(bb, otype);
                break;
            }
            case BArray: {
                obj = (HashMap<String, Object>)ImaPluginUtils.getByteArrayValue(bb, otype);
                break;
            }
            case User: {
                obj = ImaPluginUtils.getUserValue(bb, otype);
                break;
            }
            case Xid: {
                obj = ImaPluginUtils.getXidValue(bb, otype);
                break;
            }
            case Map: {
                bb.position(bb.position() - 1);
                obj = ImaPluginUtils.getMapValue(bb, null);
                break;
            }
            case Array: {
                int alen = ImaPluginUtils.getIntValue(bb, otype);
                while (alen-- > 0) {
                    ImaPluginUtils.getObjectValue(bb);
                }
                obj = null;
                break;
            }
            default: {
                ImaPluginException jex = new ImaPluginException("CWLNA0105", "The message content data is not valid");
                throw jex;
            }
        }
        return obj;
    }

    static final HashMap<String, Object> getMapValue(ByteBuffer bb, ImaMessageImpl msg) {
        int otype = ImaPluginUtils.getObjectType(bb);
        if (otype == 72 || otype == 1) {
            return null;
        }
        if (otype < 72 || otype > 76) {
            ImaPluginException jex = new ImaPluginException("CWLNA0118", "Message properties not valid, otype=" + otype);
            throw jex;
        }
        int maplen = ImaPluginUtils.getIntValue(bb, otype);
        ImaPluginUtils.checkBodyLength(bb, maplen);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int endpos = bb.position() + maplen;
        while (bb.position() < endpos) {
            Object value;
            otype = ImaPluginUtils.getObjectType(bb);
            if (otype == 21) {
                int which = ImaPluginUtils.getObjectType(bb);
                value = ImaPluginUtils.getObjectValue(bb);
                if (msg != null) {
                    switch (which) {
                        case 9: {
                            msg.dest = (String)value;
                            msg.destType = ImaDestinationType.topic;
                        }
                    }
                }
                map.put("" + which, value);
                continue;
            }
            if (otype == 20 || otype == 22 || otype == 23) {
                short which = ImaPluginUtils.getShortValue(bb, otype);
                value = ImaPluginUtils.getObjectValue(bb);
                map.put("" + which, value);
                continue;
            }
            String key = ImaPluginUtils.getNameValue(bb, otype);
            value = ImaPluginUtils.getObjectValue(bb);
            map.put(key, value);
        }
        if (bb.position() != endpos) {
            ImaPluginException jex = new ImaPluginException("CWLNA0118", "The message properties length is not valid");
            throw jex;
        }
        return map;
    }

    static final ByteBuffer putNullValue(ByteBuffer bb) {
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        bb.put((byte)1);
        return bb;
    }

    static final ByteBuffer putBooleanValue(ByteBuffer bb, boolean val) {
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        byte b = val ? (byte)3 : 2;
        bb.put(b);
        return bb;
    }

    static final ByteBuffer putByteValue(ByteBuffer bb, byte val) {
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        if (val >= 0 && val <= 20) {
            bb.put((byte)(48 + val));
        } else {
            bb.put((byte)16);
            bb.put(val);
        }
        return bb;
    }

    static final ByteBuffer putShortValue(ByteBuffer bb, short val) {
        return ImaPluginUtils.putSmallValue(bb, val & 0xFFFF, 80);
    }

    static final ByteBuffer putCharValue(ByteBuffer bb, char val) {
        return ImaPluginUtils.putSmallValue(bb, val, 28);
    }

    static final ByteBuffer putSmallValue(ByteBuffer bb, int val, int otype) {
        int count = 0;
        int savepos = bb.position();
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        bb.position(savepos + 1);
        for (int shift = 24; shift >= 0; shift -= 8) {
            int bval = val >> shift;
            if (count == 0 && bval != 0) {
                count = (shift >> 3) + 1;
            }
            if (count <= 0) continue;
            bb.put((byte)bval);
        }
        bb.put(savepos, (byte)(otype + count));
        return bb;
    }

    static final ByteBuffer putIntValue(ByteBuffer bb, int val) {
        int count = 0;
        int savepos = bb.position();
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        bb.position(savepos + 1);
        for (int shift = 24; shift >= 0; shift -= 8) {
            int bval = val >> shift;
            if (count == 0 && bval != 0) {
                count = (shift >> 3) + 1;
            }
            if (count <= 0) continue;
            bb.put((byte)bval);
        }
        bb.put(savepos, (byte)(96 + count));
        return bb;
    }

    static final ByteBuffer putLongValue(ByteBuffer bb, long val) {
        int count = 0;
        int savepos = bb.position();
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        bb.position(savepos + 1);
        for (int shift = 56; shift >= 0; shift -= 8) {
            int bval = (int)(val >> shift);
            if (count == 0 && bval != 0) {
                count = (shift >> 3) + 1;
            }
            if (count <= 0) continue;
            bb.put((byte)bval);
        }
        bb.put(savepos, (byte)(112 + count));
        return bb;
    }

    static final ByteBuffer putFloatValue(ByteBuffer bb, float val) {
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        if (val == 0.0f) {
            bb.put((byte)4);
        } else {
            bb.put((byte)5);
            int ival = Float.floatToRawIntBits(val);
            bb.putInt(ival);
        }
        return bb;
    }

    static final ByteBuffer putDoubleValue(ByteBuffer bb, double val) {
        bb = ImaPluginUtils.ensureBuffer(bb, 16);
        if (val == 0.0) {
            bb.put((byte)6);
        } else {
            bb.put((byte)7);
            long lval = Double.doubleToRawLongBits(val);
            bb.putLong(lval);
        }
        return bb;
    }

    static final ByteBuffer putStringValue(ByteBuffer bb, String val) {
        if (val == null) {
            return ImaPluginUtils.putNullValue(bb);
        }
        int len = ImaPluginUtils.sizeUTF8(val);
        if (len < 0) {
            ImaPluginException jex = new ImaPluginException("CWLNA0122", "The UTF-16 string encoding is not valid");
            throw jex;
        }
        if (++len <= 60) {
            bb.put((byte)(192 + len));
        } else {
            bb = ImaPluginUtils.putSmallValue(bb, len, 40);
        }
        if (len > 0) {
            bb = ImaPluginUtils.ensureBuffer(bb, len + 6);
            ImaPluginUtils.makeUTF8(val, --len, bb);
        }
        bb.put((byte)0);
        return bb;
    }

    static final ByteBuffer putXidValue(ByteBuffer bb, Xid val) {
        byte[] globalid;
        byte[] branchq = val.getBranchQualifier();
        int len = branchq.length + (globalid = val.getGlobalTransactionId()).length + 6;
        if (len > 256) {
            return ImaPluginUtils.putNullValue(bb);
        }
        bb = ImaPluginUtils.ensureBuffer(bb, len + 2);
        bb.put((byte)94);
        bb.put((byte)len);
        bb.putInt(val.getFormatId());
        bb.put((byte)globalid.length);
        bb.put((byte)branchq.length);
        bb.put(branchq);
        bb.put(globalid);
        return bb;
    }

    static final int getSimpleValue(String s) {
        int len;
        int val = 0;
        int n = len = s == null ? -1 : s.length();
        if (len > 0 && (s.charAt(0) != '0' || len == 1)) {
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (ch < '0' || ch > '9') {
                    val = -1;
                    break;
                }
                val = val * 10 + (ch - 48);
            }
        } else {
            val = -1;
        }
        return val > 65535 ? -1 : val;
    }

    static final ByteBuffer putNameValue(ByteBuffer bb, String val) {
        int id = ImaPluginUtils.getSimpleValue(val);
        if (id >= 0) {
            bb = ImaPluginUtils.putSmallValue(bb, id, 20);
        } else {
            int len = ImaPluginUtils.sizeUTF8(val);
            if (len < 0) {
                ImaPluginException jex = new ImaPluginException("CWLNA0122", "The UTF-16 encoding is not valid in name: " + val);
                throw jex;
            }
            bb = ImaPluginUtils.ensureBuffer(bb, 64 + ++len);
            if (len < 30) {
                bb.put((byte)(160 + len));
            } else {
                bb = ImaPluginUtils.putSmallValue(bb, len, 88);
            }
            if (len > 0) {
                bb = ImaPluginUtils.makeUTF8(val, --len, bb);
                bb.put((byte)0);
            }
        }
        return bb;
    }

    static final ByteBuffer putByteArrayValue(ByteBuffer bb, byte[] val, int pos, int len) {
        bb = ImaPluginUtils.ensureBuffer(bb, len + 5);
        bb = ImaPluginUtils.putSmallValue(bb, len, 144);
        bb.put(val, pos, len);
        return bb;
    }

    static final ByteBuffer putMapValue(ByteBuffer bb, Map<String, Object> props, ImaMessageImpl msg, ImaDestinationType desttype, String dest) {
        bb = ImaPluginUtils.ensureBuffer(bb, 32);
        int savepos = bb.position();
        bb.put(savepos, (byte)75);
        bb.position(savepos + 4);
        if (desttype == ImaDestinationType.topic) {
            if (dest != null && dest.length() > 0) {
                bb.put((byte)21);
                bb.put((byte)9);
                bb = ImaPluginUtils.putStringValue(bb, dest);
            }
            if (msg.retain != 0) {
                bb.put((byte)21);
                bb.put((byte)22);
                bb = ImaPluginUtils.putLongValue(bb, System.currentTimeMillis() * 1000000L);
                bb.put((byte)21);
                bb.put((byte)23);
                bb = ImaPluginUtils.putStringValue(bb, ImaPluginMain.getStringConfig("ServerUID"));
            }
        }
        if (props == null || props.size() == 0) {
            if (bb.position() == savepos + 4) {
                bb.put(savepos, (byte)72);
                bb.position(savepos + 1);
                return bb;
            }
        } else {
            for (String key : props.keySet()) {
                if (key.length() > 0 && key.charAt(0) <= '9' && key.charAt(1) >= '0') {
                    int val = 0;
                    for (int digit = 0; digit < key.length(); ++digit) {
                        char ch = key.charAt(digit);
                        if (ch < '0' || ch > '9') {
                            val = -1;
                            break;
                        }
                        val = val * 10 + (ch - 48);
                    }
                    if (val >= 0x1000000) {
                        val = -1;
                    }
                    bb = val >= 0 ? ImaPluginUtils.putSmallValue(bb, val, 20) : ImaPluginUtils.putNameValue(bb, key);
                } else {
                    bb = ImaPluginUtils.putNameValue(bb, key);
                }
                bb = ImaPluginUtils.putObjectValue(bb, props.get(key));
            }
        }
        int len = bb.position() - savepos - 4;
        bb.put(savepos + 1, (byte)(len >> 16));
        bb.put(savepos + 2, (byte)(len >> 8 & 0xFF));
        bb.put(savepos + 3, (byte)(len & 0xFF));
        return bb;
    }

    static final ByteBuffer putMapValue(ByteBuffer bb, Map<String, Object> props) {
        bb = ImaPluginUtils.ensureBuffer(bb, 32);
        int savepos = bb.position();
        bb.put(savepos, (byte)75);
        bb.position(savepos + 4);
        if (props == null || props.size() == 0) {
            bb.put(savepos, (byte)72);
            bb.position(savepos + 1);
            return bb;
        }
        for (String key : props.keySet()) {
            bb = ImaPluginUtils.putNameValue(bb, key);
            bb = ImaPluginUtils.putObjectValue(bb, props.get(key));
        }
        int len = bb.position() - savepos - 4;
        bb.put(savepos + 1, (byte)(len >> 16));
        bb.put(savepos + 2, (byte)(len >> 8 & 0xFF));
        bb.put(savepos + 3, (byte)(len & 0xFF));
        return bb;
    }

    static final ByteBuffer putObjectValue(ByteBuffer bb, Object value) {
        if (value == null) {
            bb = ImaPluginUtils.putNullValue(bb);
        } else if (value instanceof String) {
            bb = ImaPluginUtils.putStringValue(bb, (String)value);
        } else if (value instanceof Integer) {
            bb = ImaPluginUtils.putIntValue(bb, (Integer)value);
        } else if (value instanceof Boolean) {
            bb = ImaPluginUtils.putBooleanValue(bb, (Boolean)value);
        } else if (value instanceof Byte) {
            bb = ImaPluginUtils.putByteValue(bb, (Byte)value);
        } else if (value instanceof Long) {
            bb = ImaPluginUtils.putLongValue(bb, (Long)value);
        } else if (value instanceof byte[]) {
            bb = ImaPluginUtils.putByteArrayValue(bb, (byte[])value, 0, ((byte[])value).length);
        } else if (value instanceof Double) {
            bb = ImaPluginUtils.putDoubleValue(bb, (Double)value);
        } else if (value instanceof Float) {
            bb = ImaPluginUtils.putFloatValue(bb, ((Float)value).floatValue());
        } else if (value instanceof Character) {
            ImaPluginUtils.putCharValue(bb, ((Character)value).charValue());
        } else {
            bb = value instanceof Short ? ImaPluginUtils.putShortValue(bb, (Short)value) : (value instanceof Xid ? ImaPluginUtils.putXidValue(bb, (Xid)value) : ImaPluginUtils.putStringValue(bb, String.valueOf(value)));
        }
        return bb;
    }

    static byte[] makeModifiedUTF8(String str, int utflen, byte[] ba, int pos) {
        int strlen = str.length();
        if (ba == null || utflen > ba.length) {
            ba = new byte[utflen];
        }
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ba[pos++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                ba[pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                ba[pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                ba[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            ba[pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            ba[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return ba;
    }

    static int sizeModifiedUTF8(String str) {
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    static ByteBuffer makeUTF8(String str, int utflen, ByteBuffer ba) {
        int strlen = str.length();
        if (ba == null || utflen > ba.capacity()) {
            ba = ByteBuffer.allocate(utflen);
        }
        for (int i = 0; i < strlen; ++i) {
            int c = str.charAt(i);
            if (c <= 127) {
                ba.put((byte)c);
                continue;
            }
            if (c > 2047) {
                if (c >= 55296 && c <= 56319) {
                    c = ((c & 0x3FF) << 10) + (str.charAt(++i) & 0x3FF) + 65536;
                    ba.put((byte)(0xF0 | c >> 18 & 7));
                    ba.put((byte)(0x80 | c >> 12 & 0x3F));
                    ba.put((byte)(0x80 | c >> 6 & 0x3F));
                    ba.put((byte)(0x80 | c & 0x3F));
                    continue;
                }
                ba.put((byte)(0xE0 | c >> 12 & 0xF));
                ba.put((byte)(0x80 | c >> 6 & 0x3F));
                ba.put((byte)(0x80 | c & 0x3F));
                continue;
            }
            ba.put((byte)(0xC0 | c >> 6 & 0x1F));
            ba.put((byte)(0x80 | c & 0x3F));
        }
        return ba;
    }

    private static boolean validSecond(boolean checkValid, int state, int byte1, int byte2) {
        if (byte2 < 128 || byte2 > 191) {
            return false;
        }
        boolean ret = true;
        if (checkValid) {
            switch (state) {
                case 2: {
                    if (byte1 >= 2) break;
                    ret = false;
                    break;
                }
                case 3: {
                    if (byte1 == 0 && byte2 < 160) {
                        ret = false;
                    }
                    if (byte1 != 13 || byte2 <= 159) break;
                    ret = false;
                    break;
                }
                case 4: {
                    if (byte1 == 0 && byte2 < 144) {
                        ret = false;
                        break;
                    }
                    if (byte1 == 4 && byte2 > 143) {
                        ret = false;
                        break;
                    }
                    if (byte1 <= 4) break;
                    ret = false;
                }
            }
        }
        return ret;
    }

    static String fromUTF8(ByteBuffer buf, int len, boolean checkValid) {
        char[] tbuf = tempChar.get();
        if (tbuf.length < len * 2) {
            tbuf = new char[len * 2];
            tempChar.set(tbuf);
        }
        int byte1 = 0;
        int byteend = buf.position() + len;
        int charoff = 0;
        int state = 0;
        int value = 0;
        int inputsize = 0;
        while (buf.position() < byteend) {
            if (state == 0) {
                while ((byte1 = buf.get()) >= 0) {
                    tbuf[charoff++] = (char)byte1;
                    if (buf.position() < byteend) continue;
                    return new String(tbuf, 0, charoff);
                }
                state = States[(byte1 & 0xFF) >> 3];
                value = byte1 &= StateMask[state];
                inputsize = 1;
                if (state != 1) continue;
                ImaPluginException jex = new ImaPluginException("CWLNA0122", "The UTF-8 text encoding is not valid.");
                throw jex;
            }
            int byte2 = buf.get() & 0xFF;
            if (inputsize == 1 && !ImaPluginUtils.validSecond(checkValid, state, byte1, byte2) || inputsize > 1 && byte2 < 128 || byte2 > 191) {
                ImaPluginException jex = new ImaPluginException("CWLNA0122", "The UTF-8 text encoding is not valid.");
                throw jex;
            }
            value = value << 6 | byte2 & 0x3F;
            if (inputsize + 1 >= state) {
                if (value < 65536) {
                    tbuf[charoff++] = (char)value;
                } else {
                    tbuf[charoff++] = (char)(value - 65536 >> 10 | 0xD800);
                    tbuf[charoff++] = (char)(value - 65536 & 0x3FF | 0xDC00);
                }
                state = 0;
                continue;
            }
            ++inputsize;
        }
        return new String(tbuf, 0, charoff);
    }

    static int sizeUTF8(String str) {
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c <= '\u07ff') {
                utflen += 2;
                continue;
            }
            if (c >= '\udc00' && c <= '\udfff') {
                return -1;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                if (i + 1 >= strlen) {
                    return -1;
                }
                if ((c = str.charAt(++i)) >= '\udc00' && c <= '\udfff') {
                    utflen += 4;
                    continue;
                }
                return -1;
            }
            utflen += 3;
        }
        return utflen;
    }

    static boolean isValidUTF16(String str) {
        return ImaPluginUtils.sizeUTF8(str) >= 0;
    }
}

