/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import javax.transaction.xa.Xid;

public final class ImaXidImpl
implements Xid {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    private final int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;
    static final String myhex = "0123456789ABCDEF";

    public ImaXidImpl(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        this.formatId = formatId;
        this.branchQualifier = branchQualifier;
        this.globalTransactionId = globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    static String toString(Xid xid) {
        int i;
        char[] out = new char[278];
        int outp = 0;
        byte[] branchQualifier = xid.getBranchQualifier();
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        if (branchQualifier == null || branchQualifier.length > 64 || globalTransactionId == null || globalTransactionId.length > 64) {
            return "Xid@" + xid.hashCode();
        }
        out[outp++] = 58;
        for (i = 0; i < globalTransactionId.length; ++i) {
            out[outp++] = myhex.charAt(globalTransactionId[i] >> 4 & 0xF);
            out[outp++] = myhex.charAt(globalTransactionId[i] & 0xF);
        }
        out[outp++] = 58;
        for (i = 0; i < branchQualifier.length; ++i) {
            out[outp++] = myhex.charAt(branchQualifier[i] >> 4 & 0xF);
            out[outp++] = myhex.charAt(branchQualifier[i] & 0xF);
        }
        return Integer.toHexString(xid.getFormatId()).toUpperCase() + new String(out, 0, outp);
    }

    public String toString() {
        return ImaXidImpl.toString(this);
    }
}

