/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ImaJson {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    int ent_count;
    int ent_alloc = 100;
    Entry[] ent = new Entry[this.ent_alloc];
    char[] source;
    int src_len;
    int pos;
    int left;
    int[] where = new int[100];
    String name;
    String value;
    int line;
    boolean comments = false;
    static String hexChar = "0123456789ABCDEF";

    public void setAllowComments(boolean allowComments) {
        this.comments = allowComments;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getLine() {
        return this.line;
    }

    public int getEntryCount() {
        return this.ent_count;
    }

    public Entry getEntry(int i) {
        if (i < this.ent_count) {
            return this.ent[i];
        }
        return null;
    }

    public Entry[] getEntries() {
        return this.ent;
    }

    public int parse(String jsonstr) {
        JState state;
        int entnum;
        int level = 0;
        boolean inarray = false;
        int rc = 0;
        this.line = 1;
        this.ent_count = 0;
        this.source = jsonstr.toCharArray();
        this.src_len = jsonstr.length();
        this.pos = 0;
        this.left = this.src_len;
        this.where[0] = 0;
        JToken token = this.jsonToken();
        switch (token) {
            case StartObject: {
                entnum = this.jsonNewEnt(JObject.JsonObject, null, null, level);
                state = JState.Name;
                break;
            }
            case StartArray: {
                entnum = this.jsonNewEnt(JObject.JsonArray, null, null, level);
                state = JState.Value;
                inarray = true;
                this.name = null;
                break;
            }
            case End: {
                level = -1;
                state = JState.Done;
                break;
            }
            case Incomplete: {
                return -1;
            }
            default: {
                return -2;
            }
        }
        while (state != JState.Done) {
            block6 : switch (state) {
                case Name: {
                    token = this.jsonToken();
                    this.name = this.value;
                    switch (token) {
                        case EndObject: {
                            if (inarray) {
                                rc = -2;
                                state = JState.Done;
                                break block6;
                            }
                            this.ent[this.where[level]].count = this.ent_count - this.where[level] - 1;
                            if (--level >= 0) {
                                inarray = this.ent[this.where[level]].objtype == JObject.JsonArray;
                                state = JState.Comma;
                                break block6;
                            }
                            state = JState.Done;
                            break block6;
                        }
                        case String: {
                            token = this.jsonToken();
                            if (token != JToken.Colon) {
                                rc = -2;
                                state = JState.Done;
                                break block6;
                            }
                            state = JState.Value;
                            break block6;
                        }
                    }
                    rc = -2;
                    state = JState.Done;
                    break;
                }
                case Value: {
                    token = this.jsonToken();
                    switch (token) {
                        case String: {
                            entnum = this.jsonNewEnt(JObject.JsonString, this.name, this.value, level);
                            state = JState.Comma;
                            break block6;
                        }
                        case Integer: {
                            entnum = this.jsonNewEnt(JObject.JsonInteger, this.name, this.value, level);
                            if (this.value.length() < 10) {
                                this.ent[entnum].count = Integer.valueOf(this.value);
                            } else {
                                this.ent[entnum].objtype = JObject.JsonNumber;
                            }
                            state = JState.Comma;
                            break block6;
                        }
                        case Number: {
                            entnum = this.jsonNewEnt(JObject.JsonNumber, this.name, this.value, level);
                            state = JState.Comma;
                            break block6;
                        }
                        case StartObject: {
                            entnum = this.jsonNewEnt(JObject.JsonObject, this.name, this.value, level);
                            this.where[++level] = entnum;
                            inarray = false;
                            state = JState.Name;
                            break block6;
                        }
                        case StartArray: {
                            entnum = this.jsonNewEnt(JObject.JsonArray, this.name, null, level);
                            this.where[++level] = entnum;
                            state = JState.Value;
                            inarray = true;
                            this.name = null;
                            break block6;
                        }
                        case True: {
                            entnum = this.jsonNewEnt(JObject.JsonTrue, this.name, null, level);
                            state = JState.Comma;
                            break block6;
                        }
                        case False: {
                            entnum = this.jsonNewEnt(JObject.JsonFalse, this.name, null, level);
                            state = JState.Comma;
                            break block6;
                        }
                        case Null: {
                            entnum = this.jsonNewEnt(JObject.JsonNull, this.name, null, level);
                            state = JState.Comma;
                            break block6;
                        }
                        case EndArray: {
                            if (!inarray) {
                                rc = -2;
                                state = JState.Done;
                                break block6;
                            }
                            this.ent[this.where[level]].count = this.ent_count - this.where[level] - 1;
                            if (--level >= 0) {
                                inarray = this.ent[this.where[level]].objtype == JObject.JsonArray;
                                state = JState.Comma;
                                break block6;
                            }
                            state = JState.Done;
                            break block6;
                        }
                    }
                    state = JState.Done;
                    break;
                }
                case Comma: {
                    token = this.jsonToken();
                    switch (token) {
                        case Comma: {
                            state = inarray ? JState.Value : JState.Name;
                            break block6;
                        }
                        case EndObject: {
                            if (inarray) {
                                rc = -2;
                                state = JState.Done;
                                break block6;
                            }
                            this.ent[this.where[level]].count = this.ent_count - this.where[level] - 1;
                            if (--level >= 0) {
                                inarray = this.ent[this.where[level]].objtype == JObject.JsonArray;
                                state = JState.Comma;
                                break block6;
                            }
                            state = JState.Done;
                            break block6;
                        }
                        case EndArray: {
                            if (!inarray) {
                                rc = -2;
                                state = JState.Done;
                                break block6;
                            }
                            this.ent[this.where[level]].count = this.ent_count - this.where[level] - 1;
                            if (--level >= 0) {
                                inarray = this.ent[this.where[level]].objtype == JObject.JsonArray;
                                state = JState.Comma;
                                break block6;
                            }
                            state = JState.Done;
                            break block6;
                        }
                        case End: {
                            state = JState.Done;
                            break block6;
                        }
                        case Incomplete: {
                            rc = -1;
                            state = JState.Done;
                            break block6;
                        }
                    }
                    rc = -2;
                    state = JState.Done;
                }
            }
        }
        if (rc == 0 && level >= 0) {
            rc = -1;
        }
        if (rc == 0) {
            this.skipWhite();
        }
        return rc != 0 ? rc : this.ent_count;
    }

    public void parse(File file) throws Exception {
        StringBuilder sb = new StringBuilder((int)(file.length() + 1024L));
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
        }
        catch (Exception ex) {
            throw new Exception("Failed to parse JSON file: " + file.getName(), ex);
        }
        if (this.parse(sb.toString()) < 0) {
            throw new Exception("Failed to parse JSON file: " + file.getName());
        }
    }

    int jsonNewEnt(JObject objtype, String name, String value, int level) {
        int entnum;
        if (this.ent_count >= this.ent_alloc) {
            int newalloc = this.ent_alloc < 25 ? 100 : this.ent_alloc * 4;
            Entry[] newent = new Entry[newalloc];
            System.arraycopy(this.ent, 0, newent, 0, this.ent_alloc);
            this.ent = newent;
            this.ent_alloc = newalloc;
        }
        if (this.ent[entnum = this.ent_count++] == null) {
            this.ent[entnum] = new Entry();
        }
        this.ent[entnum].objtype = objtype;
        this.ent[entnum].name = name;
        this.ent[entnum].value = value;
        this.ent[entnum].level = level;
        this.ent[entnum].line = this.line;
        return entnum;
    }

    void skipWhite() {
        while (this.left-- > 0) {
            char ch = this.source[this.pos++];
            switch (ch) {
                default: {
                    --this.pos;
                    return;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
            }
        }
    }

    JToken jsonToken() {
        block16: while (this.left-- > 0) {
            char ch = this.source[this.pos++];
            block0 : switch (ch) {
                case '\t': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '\n': {
                    ++this.line;
                    break;
                }
                case '{': {
                    return JToken.StartObject;
                }
                case '}': {
                    return JToken.EndObject;
                }
                case '[': {
                    return JToken.StartArray;
                }
                case ']': {
                    return JToken.EndArray;
                }
                case ':': {
                    return JToken.Colon;
                }
                case ',': {
                    return JToken.Comma;
                }
                case '\"': {
                    return this.jsonString();
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.jsonNumber();
                }
                case 't': {
                    return this.jsonKeyword(JToken.True, "true", 3);
                }
                case 'f': {
                    return this.jsonKeyword(JToken.False, "false", 4);
                }
                case 'n': {
                    return this.jsonKeyword(JToken.Null, "null", 3);
                }
                case '/': {
                    if (this.comments) {
                        if (this.left-- <= 0) {
                            return JToken.Incomplete;
                        }
                        if ((ch = this.source[this.pos++]) != '*' && ch != '/') {
                            return JToken.Error;
                        }
                        if (ch == '*') {
                            while (this.left-- > 0) {
                                if ((ch = this.source[this.pos++]) == '*') {
                                    if (this.left-- <= 0) {
                                        return JToken.Incomplete;
                                    }
                                    if ((ch = this.source[this.pos++]) == '/') break;
                                }
                                if (ch != '\n') continue;
                                ++this.line;
                            }
                            if (this.left >= 0) continue block16;
                            return JToken.Incomplete;
                        }
                        while (this.left-- > 0) {
                            if ((ch = this.source[this.pos++]) == '\n') {
                                ++this.line;
                            }
                            if (ch == '\r') continue block16;
                            if (ch != '\n') continue;
                            break block0;
                        }
                        continue block16;
                    }
                    return JToken.Error;
                }
                default: {
                    return JToken.Error;
                }
            }
        }
        return JToken.End;
    }

    JToken jsonKeyword(JToken otype, String match, int len) {
        if (this.left >= len) {
            for (int i = 0; i < len; ++i) {
                if (this.source[this.pos + i] == match.charAt(i + 1)) continue;
                return JToken.Error;
            }
            this.pos += len;
            this.left -= len;
            this.value = match;
            return otype;
        }
        return JToken.Incomplete;
    }

    static int hexValue(char ch) {
        if (ch <= '9' && ch >= '0') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    JToken jsonString() {
        int ip;
        int op = ip = this.pos;
        while (this.left > 0) {
            int ch;
            if ((ch = this.source[ip++]) == 34) {
                --this.left;
                this.value = new String(this.source, this.pos, op - this.pos);
                this.pos = ip;
                return JToken.String;
            }
            if (ch == 92) {
                if (this.left < 2) {
                    return JToken.Incomplete;
                }
                ch = this.source[ip++];
                --this.left;
                switch (ch) {
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 117: {
                        if (this.left < 4) {
                            return JToken.Incomplete;
                        }
                        int val = 0;
                        for (int i = 0; i < 4; ++i) {
                            int digit;
                            if ((digit = ImaJson.hexValue(this.source[ip++])) < 0) {
                                return JToken.Incomplete;
                            }
                            val = val << 4 | digit;
                        }
                        this.left -= 4;
                        ch = (char)val;
                        break;
                    }
                    case 34: 
                    case 47: 
                    case 92: {
                        break;
                    }
                    default: {
                        return JToken.Error;
                    }
                }
                this.source[op++] = ch;
            } else {
                this.source[op++] = ch;
            }
            --this.left;
        }
        return JToken.Error;
    }

    JToken jsonNumber() {
        int dp = this.pos - 1;
        int state = this.source[dp] == '-' ? 0 : 1;
        boolean waszero = false;
        int digits = 0;
        ++this.left;
        while (this.left > 0) {
            char ch = this.source[dp];
            switch (ch) {
                case '0': {
                    if (state == 1 && waszero) {
                        return JToken.Error;
                    }
                    waszero = true;
                    if (state == 4) {
                        state = 5;
                    }
                    ++digits;
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 1) {
                        state = 2;
                    }
                    if (state == 4) {
                        state = 5;
                    }
                    waszero = false;
                    ++digits;
                    break;
                }
                case '.': {
                    if (state != 1 && state != 2) {
                        return JToken.Error;
                    }
                    state = 3;
                    digits = 0;
                    break;
                }
                case '-': {
                    if (state != 0 && state != 4) {
                        return JToken.Error;
                    }
                    ++state;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (state == 0 || state > 3) {
                        return JToken.Error;
                    }
                    state = 4;
                    digits = 0;
                    break;
                }
                case '+': {
                    if (state != 4) {
                        return JToken.Error;
                    }
                    state = 5;
                    digits = 0;
                    break;
                }
                default: {
                    if (state == 3 && digits == 0 || state == 5 && digits == 0) {
                        return JToken.Error;
                    }
                    this.value = new String(this.source, this.pos - 1, dp - this.pos + 1);
                    this.pos = dp;
                    return state > 2 ? JToken.Number : JToken.Integer;
                }
            }
            ++dp;
            --this.left;
        }
        this.pos = dp;
        this.left = 0;
        return JToken.Incomplete;
    }

    static int jsonExtra(String str) {
        int extra = 0;
        block3: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= ' ') {
                if (ch != '\"' && ch != '\\') continue;
                ++extra;
                continue;
            }
            switch (ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    ++extra;
                    continue block3;
                }
                default: {
                    extra += 5;
                }
            }
        }
        return extra;
    }

    public static StringBuffer escape(StringBuffer to, String from) {
        block7: for (int i = 0; i < from.length(); ++i) {
            char ch = from.charAt(i);
            if (ch >= ' ') {
                if (ch == '\"' || ch == '\\') {
                    to.append('\\');
                }
                to.append(ch);
                continue;
            }
            to.append('\\');
            switch (ch) {
                case '\n': {
                    to.append('n');
                    continue block7;
                }
                case '\r': {
                    to.append('r');
                    continue block7;
                }
                case '\b': {
                    to.append('b');
                    continue block7;
                }
                case '\t': {
                    to.append('t');
                    continue block7;
                }
                case '\f': {
                    to.append('f');
                    continue block7;
                }
                default: {
                    to.append('u');
                    to.append('0');
                    to.append('0');
                    to.append(hexChar.charAt(ch >> 4 & 0xF));
                    to.append(hexChar.charAt(ch & 0xF));
                }
            }
        }
        return to;
    }

    public static void putString(StringBuffer buf, String str) {
        buf.append('\"');
        int extra = ImaJson.jsonExtra(str);
        if (extra == 0) {
            buf.append(str);
        } else {
            ImaJson.escape(buf, str);
        }
        buf.append('\"');
    }

    public static void put(StringBuffer buf, Object obj) {
        if (obj == null) {
            buf.append("null");
        } else if (obj instanceof String) {
            ImaJson.putString(buf, (String)obj);
        } else if (obj instanceof Number) {
            buf.append("" + (Number)obj);
        } else if (obj instanceof Boolean) {
            buf.append((Boolean)obj != false ? "true" : "false");
        } else if (obj instanceof String[]) {
            String[] val = (String[])obj;
            buf.append('[');
            for (int i = 0; i < val.length; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                ImaJson.putString(buf, val[i]);
            }
            buf.append(']');
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            Iterator it = map.keySet().iterator();
            buf.append("{ ");
            boolean isFirst = true;
            while (it.hasNext()) {
                String name = (String)it.next();
                Object value = map.get(name);
                if (!isFirst) {
                    buf.append(", ");
                    isFirst = false;
                }
                ImaJson.putString(buf, name);
                buf.append(":");
                ImaJson.put(buf, value);
            }
            buf.append(" }");
        } else {
            buf.append("null");
        }
    }

    int get(int entnum, String name) {
        if (entnum < 0 || entnum >= this.ent_count || this.ent[entnum].objtype != JObject.JsonObject) {
            return -1;
        }
        int maxent = entnum + this.ent[entnum].count;
        ++entnum;
        while (entnum <= maxent) {
            if (name.equals(this.ent[entnum].name)) {
                return entnum;
            }
            if (this.ent[entnum].objtype == JObject.JsonObject || this.ent[entnum].objtype == JObject.JsonArray) {
                entnum += this.ent[entnum].count;
                continue;
            }
            ++entnum;
        }
        return -1;
    }

    public String getString(String name) {
        int entnum = this.get(0, name);
        if (entnum < 0) {
            return null;
        }
        switch (this.ent[entnum].objtype) {
            case JsonTrue: {
                return "true";
            }
            case JsonFalse: {
                return "false";
            }
            case JsonNull: {
                return "null";
            }
            default: {
                return null;
            }
            case JsonInteger: 
            case JsonString: 
            case JsonNumber: 
        }
        return this.ent[entnum].value;
    }

    public int getInt(String name, int default_value) {
        int val;
        int entnum = this.get(0, name);
        if (entnum < 0) {
            return default_value;
        }
        switch (this.ent[entnum].objtype) {
            case JsonInteger: {
                return this.ent[entnum].count;
            }
            case JsonTrue: {
                return 1;
            }
            case JsonFalse: {
                return 0;
            }
            default: {
                return default_value;
            }
            case JsonString: 
            case JsonNumber: 
        }
        try {
            val = Integer.valueOf(this.ent[entnum].value);
        }
        catch (Exception e) {
            val = default_value;
        }
        return val;
    }

    public static String fromMap(Map<String, Object> map) {
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        Iterator<String> it = map.keySet().iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            String name = it.next();
            Object value = map.get(name);
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            ImaJson.putString(sb, name);
            sb.append(":");
            ImaJson.put(sb, value);
        }
        sb.append(" }\n");
        return sb.toString();
    }

    public Object getValue(int entnum) {
        if (entnum >= this.ent_count) {
            return null;
        }
        switch (this.ent[entnum].objtype) {
            case JsonString: {
                return this.ent[entnum].value;
            }
            case JsonInteger: {
                return this.ent[entnum].count;
            }
            case JsonNumber: {
                return Double.parseDouble(this.ent[entnum].value);
            }
            case JsonTrue: {
                return true;
            }
            case JsonFalse: {
                return false;
            }
        }
        return null;
    }

    public String[] toArray(int entnum) {
        if (entnum >= this.ent_count || this.ent[entnum].objtype != JObject.JsonArray) {
            return null;
        }
        String[] ret = new String[this.ent[entnum].count];
        int maxent = this.ent[entnum].count + entnum + 1;
        int which = 0;
        block8: for (int i = entnum + 1; i < maxent; ++i) {
            switch (this.ent[i].objtype) {
                case JsonObject: 
                case JsonArray: {
                    return null;
                }
                case JsonString: 
                case JsonNumber: {
                    ret[which++] = this.ent[i].value;
                    continue block8;
                }
                case JsonInteger: {
                    ret[which++] = "" + this.ent[i].count;
                    continue block8;
                }
                case JsonTrue: {
                    ret[which++] = "true";
                    continue block8;
                }
                case JsonFalse: {
                    ret[which++] = "false";
                    continue block8;
                }
                case JsonNull: {
                    ret[which++] = null;
                }
            }
        }
        return ret;
    }

    public boolean getBoolean(String name, boolean deflt) {
        int entnum = this.get(0, name);
        if (entnum < 0) {
            return deflt;
        }
        switch (this.ent[entnum].objtype) {
            case JsonTrue: {
                return true;
            }
            case JsonFalse: {
                return false;
            }
            case JsonNull: {
                return deflt;
            }
            default: {
                return deflt;
            }
            case JsonInteger: {
                return this.ent[entnum].count != 0;
            }
            case JsonString: 
        }
        if ("true".equalsIgnoreCase(this.ent[entnum].value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.ent[entnum].value)) {
            return false;
        }
        return deflt;
    }

    public Map<String, Object> toMap(int entnum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (entnum >= this.ent_count || this.ent[entnum].objtype != JObject.JsonObject) {
            return null;
        }
        int maxent = this.ent[entnum].count + entnum + 1;
        block10: for (int i = entnum + 1; i < maxent; ++i) {
            switch (this.ent[i].objtype) {
                case JsonObject: {
                    map.put(this.ent[i].name, this.toMap(i));
                    i += this.ent[i].count;
                    continue block10;
                }
                case JsonArray: {
                    String[] sa = new String[this.ent[i].count];
                    for (int j = 0; j < this.ent[i].count; ++j) {
                        sa[j] = this.ent[i + j + 1].value;
                    }
                    map.put(this.ent[i].name, sa);
                    i += this.ent[i].count;
                    continue block10;
                }
                case JsonInteger: {
                    map.put(this.ent[i].name, this.ent[i].count);
                    continue block10;
                }
                case JsonNumber: {
                    map.put(this.ent[i].name, Double.parseDouble(this.ent[i].value));
                    continue block10;
                }
                case JsonString: {
                    map.put(this.ent[i].name, this.ent[i].value);
                    continue block10;
                }
                case JsonTrue: {
                    map.put(this.ent[i].name, true);
                    continue block10;
                }
                case JsonFalse: {
                    map.put(this.ent[i].name, false);
                    continue block10;
                }
                case JsonNull: {
                    map.put(this.ent[i].name, null);
                }
            }
        }
        return map;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, 0, 0);
        return sb.toString();
    }

    int toString(StringBuffer sb, int entnum, int options) {
        int startent = entnum;
        if (entnum < 0 || entnum >= this.ent_count) {
            return -1;
        }
        int maxent = entnum;
        if (this.ent[entnum].name != null) {
            sb.append('\"');
            ImaJson.escape(sb, this.ent[entnum].name);
            sb.append("\":");
        }
        switch (this.ent[entnum].objtype) {
            case JsonObject: {
                sb.append('{');
                maxent = entnum + this.ent[entnum].count;
                break;
            }
            case JsonArray: {
                sb.append('[');
                maxent = entnum + this.ent[entnum].count;
                break;
            }
            case JsonInteger: {
                sb.append("" + this.ent[entnum].count);
                break;
            }
            case JsonNumber: {
                sb.append(this.ent[entnum].value);
                break;
            }
            case JsonString: {
                sb.append('\"');
                ImaJson.escape(sb, this.ent[entnum].value);
                sb.append('\"');
                break;
            }
            case JsonTrue: {
                sb.append("true");
                break;
            }
            case JsonFalse: {
                sb.append("false");
                break;
            }
            case JsonNull: {
                sb.append("null");
            }
        }
        boolean first = true;
        ++entnum;
        while (entnum > 0 && entnum <= maxent) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            entnum = this.toString(sb, entnum, options);
        }
        switch (this.ent[startent].objtype) {
            case JsonObject: {
                sb.append('}');
                break;
            }
            case JsonArray: {
                sb.append(']');
            }
        }
        return entnum;
    }

    static enum JState {
        Name,
        Value,
        Comma,
        Done;

    }

    static enum JToken {
        Error,
        StartObject,
        EndObject,
        StartArray,
        EndArray,
        Colon,
        Comma,
        String,
        Number,
        Integer,
        True,
        False,
        Null,
        End,
        Incomplete;

    }

    public static enum JObject {
        JsonString,
        JsonInteger,
        JsonNumber,
        JsonObject,
        JsonArray,
        JsonTrue,
        JsonFalse,
        JsonNull;

    }

    public class Entry {
        public String name;
        public String value;
        public int count;
        public int level;
        public int line;
        public JObject objtype;
    }
}

