/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.ImaEndpoint;
import com.ibm.ima.plugin.impl.ImaPluginMain;
import java.util.HashMap;
import java.util.Map;

public class ImaEndpointImpl
implements ImaEndpoint {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    private String name;
    private String address;
    private String msgHub;
    private int maxMessageSize;
    private int port;
    private int flags;
    private long protomask;
    static final int F_Enabled = 1;
    static final int F_Secure = 2;
    static final int F_Reliable = 4;
    static final int F_UseCert = 8;
    static final int F_UsePW = 16;
    static HashMap<String, ImaEndpointImpl> endpoints = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImaEndpointImpl(Map<String, Object> map) {
        Class<ImaEndpointImpl> clazz = ImaEndpointImpl.class;
        synchronized (ImaEndpointImpl.class) {
            this.name = ImaEndpointImpl.getStringProperty(map, "Name");
            if (this.name == null) {
                throw new IllegalArgumentException("Endpoint does not include name");
            }
            this.address = ImaEndpointImpl.getStringProperty(map, "Interface");
            this.port = ImaEndpointImpl.getIntProperty(map, "Port", 0);
            this.msgHub = ImaEndpointImpl.getStringProperty(map, "MessageHub");
            this.maxMessageSize = ImaEndpointImpl.getIntProperty(map, "MaxMessageSize", 0);
            this.protomask = ImaEndpointImpl.getLongProperty(map, "ProtoMask", 0L);
            if (ImaEndpointImpl.getIntProperty(map, "Enabled", 0) != 0) {
                this.flags |= 1;
            }
            if (ImaEndpointImpl.getIntProperty(map, "Secure", 0) != 0) {
                this.flags |= 2;
            }
            if (ImaEndpointImpl.getIntProperty(map, "Reliable", 1) != 0) {
                this.flags |= 4;
            }
            if (ImaEndpointImpl.getIntProperty(map, "UseClientCertificate", 0) != 0) {
                this.flags |= 8;
            }
            if (ImaEndpointImpl.getIntProperty(map, "UsePassword", 0) != 0) {
                this.flags |= 0x10;
            }
            endpoints.put(this.name, this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (ImaPluginMain.trace.isTraceable(4)) {
                ImaPluginMain.trace.trace("" + this);
            }
            return;
        }
    }

    private ImaEndpointImpl(String name) {
        endpoints.put(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImaEndpointImpl getEndpoint(String name, boolean create) {
        Class<ImaEndpointImpl> clazz = ImaEndpointImpl.class;
        synchronized (ImaEndpointImpl.class) {
            ImaEndpointImpl ret = endpoints.get(name);
            if (ret == null && create) {
                ret = new ImaEndpointImpl(name);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    static String getStringProperty(Map<String, Object> map, String name) {
        Object obj = map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "" + obj;
    }

    static int getIntProperty(Map<String, Object> map, String name, int defval) {
        Object obj = map.get(name);
        if (obj == null) {
            return defval;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return defval;
    }

    static long getLongProperty(Map<String, Object> map, String name, long defval) {
        Object obj = map.get(name);
        if (obj == null) {
            return defval;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return defval;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getMaxMessgeSize() {
        return this.maxMessageSize;
    }

    @Override
    public String getMessageHub() {
        return this.msgHub;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public long getProtocolMask() {
        return this.protomask;
    }

    @Override
    public boolean isSecure() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isReliable() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean useClientCert() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean usePassword() {
        return (this.flags & 0x10) != 0;
    }

    public String toString() {
        return "ImaEndpointImpl Name=\"" + this.name + "\" Interface=\"" + this.address + "\" Port=" + this.port;
    }
}

