/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.ImaDestinationType;
import com.ibm.ima.plugin.ImaMessage;
import com.ibm.ima.plugin.ImaMessageType;
import com.ibm.ima.plugin.ImaReliability;
import com.ibm.ima.plugin.ImaTransaction;
import com.ibm.ima.plugin.impl.ImaConnectionImpl;
import com.ibm.ima.plugin.impl.ImaPluginUtils;
import com.ibm.ima.plugin.impl.ImaTransactionImpl;
import com.ibm.ima.plugin.util.ImaJson;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ImaMessageImpl
implements ImaMessage {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    ImaMessageType msgtype;
    boolean persistent;
    ImaReliability qos;
    long expiration;
    Map<String, Object> props;
    byte[] body;
    int retain;
    String dest;
    ImaDestinationType destType;
    ImaConnectionImpl connection;
    final int seqnum;
    Object userData;
    static Charset utf8 = Charset.forName("UTF-8");

    public ImaMessageImpl(ImaMessageType mtype) {
        this.msgtype = mtype;
        this.qos = ImaReliability.qos0;
        this.seqnum = 0;
    }

    ImaMessageImpl(ImaConnectionImpl con, int seqnum, int type, int flags, String dest, Map<String, Object> props, byte[] body) {
        this.msgtype = ImaMessageImpl.toMessageType(type);
        this.qos = ImaMessageImpl.toQoS(flags);
        this.persistent = (flags & 4) != 0;
        this.retain = flags >> 3 & 3;
        this.dest = dest;
        this.destType = (flags & 0x20) != 0 ? ImaDestinationType.queue : ImaDestinationType.topic;
        this.connection = con;
        this.props = props;
        this.body = body;
        this.seqnum = seqnum;
    }

    static ImaMessageType toMessageType(int type) {
        switch (type) {
            case 1: {
                return ImaMessageType.jmsMessage;
            }
            case 2: {
                return ImaMessageType.jmsBytesMessage;
            }
            case 3: {
                return ImaMessageType.jmsMapMessage;
            }
            case 4: {
                return ImaMessageType.jmsObjectMessage;
            }
            case 5: {
                return ImaMessageType.jmsStreamMessage;
            }
            case 6: {
                return ImaMessageType.jmsTextMessage;
            }
            case 7: {
                return ImaMessageType.jmsTextMessage;
            }
            case 17: {
                return ImaMessageType.bytes;
            }
            case 18: {
                return ImaMessageType.text;
            }
            case 20: {
                return ImaMessageType.jsonObject;
            }
            case 21: {
                return ImaMessageType.jsonArray;
            }
            case 32: {
                return ImaMessageType.nullRetained;
            }
        }
        return ImaMessageType.bytes;
    }

    static int fromMessageType(ImaMessageType type) {
        switch (type) {
            case bytes: {
                return 17;
            }
            case text: {
                return 18;
            }
            case jsonObject: {
                return 20;
            }
            case jsonArray: {
                return 21;
            }
            case jmsMessage: {
                return 1;
            }
            case jmsBytesMessage: {
                return 2;
            }
            case jmsMapMessage: {
                return 3;
            }
            case jmsObjectMessage: {
                return 4;
            }
            case jmsStreamMessage: {
                return 5;
            }
            case jmsTextMessage: {
                return 6;
            }
            case nullRetained: {
                return 32;
            }
        }
        return 17;
    }

    static ImaReliability toQoS(int flags) {
        switch (flags & 3) {
            case 0: {
                return ImaReliability.qos0;
            }
            case 1: {
                return ImaReliability.qos1;
            }
            case 2: {
                return ImaReliability.qos2;
            }
        }
        return ImaReliability.qos0;
    }

    static int fromQoS(ImaReliability qos) {
        switch (qos) {
            case qos0: {
                return 0;
            }
            case qos1: {
                return 1;
            }
            case qos2: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public ImaMessage addProperties(Map<String, Object> newprops) {
        if (this.props == null) {
            this.props = new HashMap<String, Object>();
        }
        this.props.putAll(newprops);
        return this;
    }

    @Override
    public void acknowledge(int rc, ImaTransaction transaction) {
        if (this.seqnum != 0) {
            this.connection.acknowledge(this, rc, (ImaTransactionImpl)transaction);
            return;
        }
        if (transaction != null) {
            throw new RuntimeException("Message with sequence number 0 can not be added to transaction");
        }
    }

    @Override
    public void acknowledge(int rc) {
        if (this.seqnum != 0) {
            this.connection.acknowledge(this, rc, null);
        }
    }

    @Override
    public ImaMessage clearProperties() {
        this.props = null;
        return this;
    }

    @Override
    public byte[] getBodyBytes() {
        return this.body;
    }

    @Override
    public Map<String, Object> getBodyMap() {
        return null;
    }

    @Override
    public String getBodyText() {
        ByteBuffer bb = ByteBuffer.wrap(this.body);
        String text = ImaPluginUtils.fromUTF8(bb, bb.remaining(), true);
        return text;
    }

    @Override
    public boolean getBooleanProperty(String name, boolean default_value) {
        Object obj = this.getProperty(name);
        if (obj == null) {
            return default_value;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            if ("true".equalsIgnoreCase((String)obj)) {
                return true;
            }
            if ("false".equalsIgnoreCase((String)obj)) {
                return false;
            }
        } else if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        return default_value;
    }

    @Override
    public String getDestination() {
        return this.dest;
    }

    @Override
    public ImaDestinationType getDestinationType() {
        return this.destType;
    }

    @Override
    public ImaMessageType getMessageType() {
        return this.msgtype;
    }

    @Override
    public boolean getPersistence() {
        return this.persistent;
    }

    @Override
    public ImaReliability getReliability() {
        return this.qos;
    }

    @Override
    public boolean getRetain() {
        return (this.retain & 2) != 0;
    }

    @Override
    public boolean getRetainAsPublished() {
        return this.retain != 0;
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    @Override
    public int getIntPropery(String name, int default_value) {
        Object obj = this.getProperty(name);
        if (obj == null) {
            return default_value;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof String) {
            try {
                return Integer.valueOf((String)obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return default_value;
    }

    @Override
    public Object getProperty(String name) {
        if (this.props == null) {
            return null;
        }
        return this.props.get(name);
    }

    @Override
    public String getStringProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj instanceof String) {
            return (String)obj;
        }
        return "" + obj;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public boolean propertyExists(String name) {
        if (this.props == null) {
            return false;
        }
        return this.props.containsValue(name);
    }

    @Override
    public ImaMessage setMessageType(ImaMessageType msgtype) {
        this.msgtype = msgtype;
        return this;
    }

    @Override
    public ImaMessage setBodyBytes(byte[] body) {
        this.body = body;
        return this;
    }

    @Override
    public ImaMessage setBodyMap(Map<String, Object> body) {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        sb.append("{");
        for (String key : body.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            ImaJson.putString(sb, key);
            sb.append(":");
            ImaJson.put(sb, body.get(key));
        }
        sb.append("}");
        this.body = new String(sb).getBytes(utf8);
        return this;
    }

    @Override
    public ImaMessage setBodyText(String body) {
        this.body = (byte[])(body != null ? body.getBytes(utf8) : null);
        return this;
    }

    @Override
    public ImaMessage setPersistent(boolean persist) {
        this.persistent = persist;
        return this;
    }

    @Override
    public ImaMessage setReliability(ImaReliability reliability) {
        this.qos = reliability;
        return this;
    }

    @Override
    public ImaMessage setRetain(boolean retain) {
        this.retain = retain ? 3 : 0;
        return this;
    }

    @Override
    public void setUserData(Object userdata) {
        this.userData = userdata;
    }
}

