/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.impl.ImaChannel;
import com.ibm.ima.plugin.impl.ImaConnectionImpl;
import com.ibm.ima.plugin.impl.ImaEndpointImpl;
import com.ibm.ima.plugin.impl.ImaMessageImpl;
import com.ibm.ima.plugin.impl.ImaPluginImpl;
import com.ibm.ima.plugin.impl.ImaPluginMain;
import com.ibm.ima.plugin.impl.ImaPluginUtils;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class ImaPluginAction {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    public static final int Initialize = 1;
    public static final int StartMessaging = 2;
    public static final int Terminate = 3;
    public static final int DefinePlugin = 4;
    public static final int Endpoint = 5;
    public static final int InitChannel = 6;
    public static final int Authenticate = 10;
    public static final int GetStats = 13;
    public static final int InitConnection = 15;
    public static final int OnConnection = 20;
    public static final int OnClose = 21;
    public static final int OnComplete = 22;
    public static final int OnData = 23;
    public static final int OnMessage = 24;
    public static final int OnConnected = 26;
    public static final int OnLivenessCheck = 27;
    public static final int OnHttpData = 28;
    public static final int SuspendDelivery = 29;
    public static final int OnGetMessage = 30;
    public static final int NewConnection = 41;
    public static final int Stats = 44;
    public static final int Reply = 45;
    public static final int Log = 46;
    public static final int SendData = 50;
    public static final int Accept = 51;
    public static final int Identify = 52;
    public static final int Subscribe = 53;
    public static final int CloseSub = 55;
    public static final int DestroySub = 56;
    public static final int Send = 57;
    public static final int Close = 58;
    public static final int AsyncReply = 59;
    public static final int SetKeepAlive = 60;
    public static final int Acknowledge = 61;
    public static final int DeleteRetain = 62;
    public static final int SendHttp = 63;
    public static final int ResumeDelivery = 64;
    public static final int GetMessage = 65;
    public static final int CreateTransaction = 66;
    public static final int CommitTransaction = 67;
    public static final int RollbackTransaction = 68;
    public static final int UpdateProperties = 69;
    ByteBuffer bb;
    int action;
    ImaChannel channel;
    Object obj;
    static ImaPluginImpl[] plugins = new ImaPluginImpl[50];
    static int plugin_count = 0;
    static long baseStatTime;
    static long lastStatTime;
    static long baseGcCount;
    static long lastGcCount;
    static long baseCpuTime;
    static long lastCpuTime;
    static long baseCpuValue;
    static long lastCpuValue;

    public ImaPluginAction(int action, int size, int headers) {
        if (size < 256) {
            size = 256;
        }
        this.action = action;
        this.bb = ByteBuffer.allocate(size);
        this.bb.put(0, (byte)action);
        this.bb.put(1, (byte)headers);
        this.bb.position(6);
    }

    public ImaPluginAction(int act) {
        this(act, 256, 0);
    }

    public ImaPluginAction(ImaChannel channel, byte[] b, int len) {
        this.channel = channel;
        this.bb = ByteBuffer.wrap(b, 0, len);
        if (len > 0) {
            this.action = b[0];
        }
    }

    public void setHeaders(int headers) {
        this.bb.put(1, (byte)headers);
    }

    public void setObject(Object obj) {
        this.obj = obj;
    }

    public void send(ImaChannel channel) {
        this.bb.putInt(2, this.bb.position() - 6);
        this.bb.flip();
        channel.send(this.bb);
    }

    public void send(ImaChannel channel, byte[] b, int len) throws IOException {
        if (b != null && len > 0) {
            this.bb = ImaPluginUtils.ensureBuffer(this.bb, len + 32);
            ImaPluginUtils.putSmallValue(this.bb, len, 144);
            this.bb.put(b);
        }
        this.send(channel);
    }

    public void doReply(int rc) {
        ImaPluginAction action = new ImaPluginAction(45, 32, 1);
        action.bb = ImaPluginUtils.putIntValue(action.bb, rc);
        if (ImaPluginMain.trace.isTraceable(7)) {
            ImaPluginMain.trace.trace("Reply channel " + this.channel.id + ": " + rc);
        }
        action.send(this.channel);
    }

    public void process() {
        int i;
        Object[] hdr = null;
        HashMap<String, Object> props = null;
        byte[] body = null;
        ImaMessageImpl msg = null;
        int headers = this.bb.get(1);
        this.bb.position(6);
        if (headers > 0) {
            hdr = new Object[headers];
            for (i = 0; i < headers; ++i) {
                hdr[i] = ImaPluginUtils.getObjectValue(this.bb);
            }
        }
        if (this.bb.remaining() > 0) {
            Object obj;
            props = ImaPluginUtils.getMapValue(this.bb, msg);
            if (this.bb.remaining() > 0 && (obj = ImaPluginUtils.getObjectValue(this.bb)) instanceof byte[]) {
                body = (byte[])obj;
            }
        }
        switch (this.action) {
            case 23: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    connect.onData(body);
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("OnData: connection not found: " + connectid);
                break;
            }
            case 24: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    int seqnum = ((Number)hdr[1]).intValue();
                    int msgtype = 0;
                    if (hdr[2] instanceof Number) {
                        msgtype = ((Number)hdr[2]).intValue();
                    }
                    int flags = 0;
                    if (hdr[3] instanceof Number) {
                        flags = ((Number)hdr[3]).intValue();
                    }
                    String subname = (String)hdr[4];
                    String dest = (String)hdr[5];
                    msg = new ImaMessageImpl(connect, seqnum, msgtype, flags, dest, props, body);
                    connect.onMessage(subname, msg);
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("OnMessage: connection not found: " + connectid);
                break;
            }
            case 30: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                int rc = ((Number)hdr[2]).intValue();
                if (ImaPluginMain.trace.isTraceable(8)) {
                    ImaPluginMain.trace.trace("OnGetMessage: connect=" + connectid + " rc=" + rc);
                }
                if (connect != null) {
                    int seqnum = ((Number)hdr[1]).intValue();
                    if (rc == 0) {
                        int msgtype = 0;
                        if (hdr[3] instanceof Number) {
                            msgtype = ((Number)hdr[3]).intValue();
                        }
                        int flags = 0;
                        if (hdr[4] instanceof Number) {
                            flags = ((Number)hdr[4]).intValue();
                        }
                        String dest = (String)hdr[5];
                        msg = new ImaMessageImpl(connect, seqnum, msgtype, flags, dest, props, body);
                    }
                    ImaPluginAction workact = null;
                    Object correlate = null;
                    if (seqnum != 0 && seqnum != 1) {
                        workact = connect.getWork(seqnum);
                        correlate = workact.obj;
                    }
                    connect.listener.onGetMessage(correlate, rc, msg);
                    break;
                }
                ImaPluginMain.trace.trace("OnGetMessage: Connection not found: " + connectid);
                break;
            }
            case 28: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    connect.onHttpData(body, (char)((Number)hdr[1]).intValue(), (String)hdr[2], (String)hdr[3], props);
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("OnHttpData: connection not found: " + connectid);
                break;
            }
            case 22: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    connect.onComplete(hdr);
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("OnComplete: connection not found: " + connectid);
                break;
            }
            case 20: {
                ImaConnectionImpl connect;
                int connectid = ((Number)hdr[0]).intValue();
                int seqnum = ((Number)hdr[1]).intValue();
                int conntype = ((Number)hdr[2]).intValue();
                if (conntype == 3) {
                    int newconnid = ((Number)hdr[3]).intValue();
                    connect = ImaConnectionImpl.connects.get(connectid);
                    if (connect != null && newconnid != 0) {
                        ImaConnectionImpl.connects.remove(connectid);
                        ImaConnectionImpl.connects.put(newconnid, connect);
                        connect.connectID = newconnid;
                        connect.index = newconnid;
                        connect.channel = this.channel;
                        connect.state = 2;
                        Object pobj = props.get("Protocol");
                        String protocol = connect.plugin.alias;
                        if (pobj != null && pobj instanceof String) {
                            protocol = (String)pobj;
                        }
                        connect.listener = connect.plugin.plugin.onConnection(connect, protocol);
                        if (connect.listener == null) {
                            connect.close(0, "Connection is rejected by the plugin");
                            break;
                        }
                        connect.listener.onData(new byte[0], 0, 0);
                        break;
                    }
                    if (ImaPluginMain.trace.isTraceable(1)) {
                        ImaPluginMain.trace.trace("OnConnection: virtual connection not found: " + connectid);
                    }
                } else {
                    connect = ImaConnectionImpl.connects.get(connectid);
                    if (connect == null) {
                        connect = new ImaConnectionImpl(this.channel, connectid, props);
                    }
                }
                if (connect != null) {
                    if (connect.getEndpoint() != null) {
                        switch (conntype) {
                            case 0: {
                                connect.onData(body);
                                break;
                            }
                            case 1: 
                            case 2: {
                                connect.onData(new byte[0]);
                            }
                        }
                        break;
                    }
                    connect.close(351, "The Endpoint is not configured");
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("OnConnection: connection not found: " + connectid);
                break;
            }
            case 29: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    connect.suspendMessageDelivery();
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("SuspendDelivery: connection not found: " + connectid);
                break;
            }
            case 64: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    connect.resumeMessageDelivery();
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("ResumeDelivery: connection not found: " + connectid);
                break;
            }
            case 1: {
                if (ImaPluginMain.trace.isTraceable(2)) {
                    ImaPluginMain.trace.trace("Initialize: " + props);
                }
                ImaPluginMain.setConfig(props);
                this.channel.setID((Integer)hdr[0]);
                this.doReply(0);
                break;
            }
            case 2: {
                int role = 0;
                if (hdr[0] instanceof Number) {
                    role = ((Number)hdr[0]).intValue();
                }
                if (ImaPluginMain.trace.isTraceable(2)) {
                    ImaPluginMain.trace.trace("Start Messaging: " + role);
                }
                for (i = 0; i < plugin_count; ++i) {
                    ImaPluginAction.plugins[i].plugin.startMessaging(role != 0);
                }
                this.doReply(0);
                break;
            }
            case 3: {
                int rc = 0;
                if (hdr[0] instanceof Number) {
                    rc = ((Number)hdr[0]).intValue();
                }
                for (i = 0; i < plugin_count; ++i) {
                    ImaPluginAction.plugins[i].plugin.terminate(rc);
                }
                ImaPluginMain.terminate(rc, (String)hdr[1]);
                this.doReply(0);
                break;
            }
            case 4: {
                try {
                    if (ImaPluginMain.trace.isTraceable(2)) {
                        ImaPluginMain.trace.trace("Define plug-in: " + props);
                    }
                    ImaPluginImpl pii = new ImaPluginImpl(props, this.channel);
                    if (plugin_count >= plugins.length) {
                        this.doReply(101);
                        break;
                    }
                    ImaPluginAction.plugins[ImaPluginAction.plugin_count++] = pii;
                    this.doReply(0);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    this.doReply(100);
                }
                break;
            }
            case 5: {
                if (ImaPluginMain.trace.isTraceable(2)) {
                    ImaPluginMain.trace.trace("Define endpoint: " + props);
                }
                try {
                    new ImaEndpointImpl(props);
                    this.doReply(0);
                }
                catch (Exception e) {
                    this.doReply(100);
                }
                break;
            }
            case 6: {
                this.channel.setID((Integer)hdr[0]);
                if (ImaPluginMain.trace.isTraceable(2)) {
                    ImaPluginMain.trace.trace("initChannel: " + (Integer)hdr[0]);
                }
                this.doReply(0);
                break;
            }
            case 10: {
                break;
            }
            case 13: {
                int stattype = ((Number)hdr[0]).intValue();
                MemoryMXBean mm = ManagementFactory.getMemoryMXBean();
                ImaPluginAction action = new ImaPluginAction(44, 512, 5);
                ImaPluginUtils.putIntValue(action.bb, stattype);
                ImaPluginUtils.putLongValue(action.bb, mm.getHeapMemoryUsage().getMax());
                ImaPluginUtils.putLongValue(action.bb, mm.getHeapMemoryUsage().getUsed());
                ImaPluginUtils.putIntValue(action.bb, ImaPluginAction.getGCRate());
                ImaPluginUtils.putIntValue(action.bb, ImaPluginAction.getProcessCPU());
                action.send(this.channel);
                break;
            }
            case 21: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    connect.listener.onClose(((Number)hdr[2]).intValue(), (String)hdr[3]);
                    connect.close(((Number)hdr[2]).intValue(), (String)hdr[3]);
                    break;
                }
                if (ImaPluginMain.trace.isTraceable(2)) {
                    ImaPluginMain.trace.trace("OnClose: connection not found: " + connectid);
                }
                ImaPluginAction action = new ImaPluginAction(58, 256, 4);
                ImaPluginUtils.putIntValue(action.bb, connectid);
                ImaPluginUtils.putIntValue(action.bb, 0);
                ImaPluginUtils.putIntValue(action.bb, -1);
                ImaPluginUtils.putNullValue(action.bb);
                action.send(this.channel);
                break;
            }
            case 69: {
                if (props == null) break;
                String pluginname = ImaPluginImpl.getStringProperty(props, "Name");
                ImaPluginImpl iplugin = ImaPluginAction.findPluginByName(pluginname);
                iplugin.updateConfig(props);
                break;
            }
            case 27: {
                int connectid = ((Number)hdr[0]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    connect.onLivenessCheck();
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("OnLivenessCheck: connection not found: " + connectid);
                break;
            }
            case 26: {
                int connectid = ((Number)hdr[0]).intValue();
                int seqnum = ((Number)hdr[1]).intValue();
                ImaConnectionImpl connect = ImaConnectionImpl.connects.get(connectid);
                if (connect != null) {
                    int xrc = ((Number)hdr[2]).intValue();
                    if (xrc == 0) {
                        connect.state = 4;
                    }
                    connect.listener.onConnected(xrc, (String)hdr[3]);
                    if (xrc == 0) break;
                    connect.close(xrc, (String)hdr[3]);
                    break;
                }
                if (!ImaPluginMain.trace.isTraceable(1)) break;
                ImaPluginMain.trace.trace("OnConnected: " + connectid);
            }
        }
    }

    public static long getCurrentGC() {
        int total = 0;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = gc.getCollectionCount();
            if (count < 0L) continue;
            total = (int)((long)total + count);
        }
        return total;
    }

    public static int getGCRate() {
        long now = System.currentTimeMillis();
        long nowCount = ImaPluginAction.getCurrentGC();
        if (now - lastStatTime > 5000L) {
            baseStatTime = lastStatTime;
            baseGcCount = lastGcCount;
        }
        int ret = (int)((nowCount - baseGcCount) * 60000L / (now - baseStatTime));
        lastStatTime = now;
        lastGcCount = nowCount;
        return ret;
    }

    public static int getProcessCPU() {
        ThreadMXBean tm = ManagementFactory.getThreadMXBean();
        long[] threads = tm.getAllThreadIds();
        long cpuns = 0L;
        for (long threadid : threads) {
            long ns = tm.getThreadCpuTime(threadid);
            if (ns <= 0L) continue;
            cpuns += ns;
        }
        long now = System.currentTimeMillis();
        if (now - lastCpuTime > 900L) {
            baseCpuTime = lastCpuTime;
            baseCpuValue = lastCpuValue;
        }
        long delta = (cpuns - baseCpuValue) / (now - baseStatTime);
        lastCpuTime = now;
        lastCpuValue = cpuns;
        if (delta < 0L) {
            delta = 0L;
        }
        return (int)(delta / 1000000L);
    }

    public static String getActionName(int action) {
        switch (action) {
            case 1: {
                return "Initialize";
            }
            case 2: {
                return "StartMessaging";
            }
            case 3: {
                return "Terminate";
            }
            case 4: {
                return "DefinePlugin";
            }
            case 5: {
                return "Endpoint";
            }
            case 10: {
                return "Authenticate";
            }
            case 13: {
                return "GetStats";
            }
            case 15: {
                return "InitConnection";
            }
            case 20: {
                return "OnConnection";
            }
            case 21: {
                return "OnClose";
            }
            case 22: {
                return "OnComplete";
            }
            case 26: {
                return "OnConnected";
            }
            case 27: {
                return "ConLivenessCheck";
            }
            case 28: {
                return "OnHttpData";
            }
            case 29: {
                return "SuspendDelivery";
            }
            case 23: {
                return "OnData";
            }
            case 24: {
                return "OnMessage";
            }
            case 44: {
                return "Stats";
            }
            case 45: {
                return "Reply";
            }
            case 46: {
                return "Log";
            }
            case 50: {
                return "SendData";
            }
            case 51: {
                return "Accept";
            }
            case 52: {
                return "Identify";
            }
            case 53: {
                return "Subscribe";
            }
            case 55: {
                return "CloseSub";
            }
            case 56: {
                return "DestroySub";
            }
            case 57: {
                return "Send";
            }
            case 58: {
                return "Close";
            }
            case 59: {
                return "AsyncReply";
            }
            case 60: {
                return "SetKeepAlive";
            }
            case 61: {
                return "Acknowledge";
            }
            case 62: {
                return "DeleteRetain";
            }
            case 63: {
                return "SendHttp";
            }
            case 64: {
                return "ResumeDelivery";
            }
            case 66: {
                return "CreateTransaction";
            }
            case 67: {
                return "CommitTransaction";
            }
            case 68: {
                return "RollbackTransaction";
            }
        }
        return "Unknown";
    }

    static ImaPluginImpl findPlugin(String protocol) {
        if (protocol.length() > 0 && protocol.charAt(0) == '/') {
            for (int i = 0; i < plugin_count; ++i) {
                if (ImaPluginAction.plugins[i].alias == null || !ImaPluginAction.plugins[i].alias.equals(protocol)) continue;
                return plugins[i];
            }
        } else {
            for (int i = 0; i < plugin_count; ++i) {
                if (!plugins[i].isWebSocket(protocol)) continue;
                return plugins[i];
            }
        }
        return null;
    }

    static ImaPluginImpl findPluginByName(String name) {
        if (name != null) {
            for (int i = 0; i < plugin_count; ++i) {
                if (!plugins[i].getName().equals(name)) continue;
                return plugins[i];
            }
        }
        return null;
    }

    static int findPlugin(ImaConnectionImpl connect, byte[] body) {
        boolean rejected = true;
        for (int i = 0; i < plugin_count; ++i) {
            int more;
            if (!plugins[i].isInitialByte(body[0]) || (more = ImaPluginAction.plugins[i].plugin.onProtocolCheck(connect, body)) < 0) continue;
            rejected = false;
            if (more != 0) continue;
            return i;
        }
        if (rejected) {
            return -1;
        }
        return -2;
    }

    static {
        lastStatTime = baseStatTime = System.currentTimeMillis();
        lastGcCount = baseGcCount = ImaPluginAction.getCurrentGC();
        lastCpuTime = baseCpuTime = System.currentTimeMillis();
        baseCpuValue = 0L;
        lastCpuValue = 0L;
    }
}

