/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.ImaConnection;
import com.ibm.ima.plugin.ImaMessage;
import com.ibm.ima.plugin.ImaMessageType;
import com.ibm.ima.plugin.ImaPlugin;
import com.ibm.ima.plugin.ImaPluginConfigValidator;
import com.ibm.ima.plugin.ImaPluginListener;
import com.ibm.ima.plugin.impl.ImaChannel;
import com.ibm.ima.plugin.impl.ImaConnectionImpl;
import com.ibm.ima.plugin.impl.ImaEndpointImpl;
import com.ibm.ima.plugin.impl.ImaMessageImpl;
import com.ibm.ima.plugin.impl.ImaPluginAction;
import com.ibm.ima.plugin.impl.ImaPluginInstaller;
import com.ibm.ima.plugin.impl.ImaPluginMain;
import com.ibm.ima.plugin.impl.ImaPluginTraceImpl;
import com.ibm.ima.plugin.impl.ImaPluginUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ImaPluginImpl
implements ImaPlugin {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    private String name;
    private String protocol;
    private String classname;
    private String[] classpath;
    private String[] websocket;
    String[] httpheader;
    private byte[] initial_byte;
    private int initial_byte_count;
    private int capability;
    String author;
    String version;
    int modification;
    String copyright;
    String build;
    String description;
    String license;
    String title;
    String alias;
    private ImaPluginTraceImpl trace;
    private Map<String, Object> props;
    ImaPluginListener plugin;
    ImaChannel channel;
    private final boolean isValidator;
    private final URLClassLoader loader;
    static int vconn = 0x7F000000;
    static final String CONFIG_DIR;
    static String PLUGINS_DIR;
    static HashMap<String, ImaPluginImpl> plugins;

    ImaPluginImpl(Map<String, Object> map, ImaChannel channel) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException {
        Class<?> cls;
        String pluginFolder;
        this.channel = channel;
        this.name = ImaPluginImpl.getStringProperty(map, "Name");
        if (this.name == null) {
            throw new IllegalArgumentException("Plugin definition does not include name");
        }
        if (channel == null) {
            this.isValidator = true;
            this.trace = ImaPluginInstaller.trace;
            pluginFolder = ImaPluginImpl.getStringProperty(map, "ValidateConfigFolder") + File.separator;
            map.remove("ValidateConfigFolder");
        } else {
            pluginFolder = PLUGINS_DIR + this.name + File.separator;
            this.trace = ImaPluginMain.trace;
            this.isValidator = false;
        }
        this.protocol = ImaPluginImpl.getStringProperty(map, "Protocol");
        this.classname = ImaPluginImpl.getStringProperty(map, "Class");
        this.capability = ImaPluginImpl.getIntProperty(map, "Capabilities", 0);
        Object obj = map.get("Properties");
        if (obj instanceof Map) {
            this.props = (Map)obj;
        }
        this.classpath = ImaPluginImpl.getStringArray(map, "Classpath");
        this.websocket = ImaPluginImpl.getStringArray(map, "WebSocket");
        this.httpheader = ImaPluginImpl.getStringArray(map, "HttpHeader");
        this.author = ImaPluginImpl.getStringProperty(map, "Author");
        this.version = ImaPluginImpl.getStringProperty(map, "Version");
        this.copyright = ImaPluginImpl.getStringProperty(map, "Copyright");
        this.modification = ImaPluginImpl.getIntProperty(map, "Modification", 1);
        this.build = ImaPluginImpl.getStringProperty(map, "Build");
        this.description = ImaPluginImpl.getStringProperty(map, "Description");
        this.license = ImaPluginImpl.getStringProperty(map, "License");
        this.title = ImaPluginImpl.getStringProperty(map, "Title");
        this.alias = ImaPluginImpl.getStringProperty(map, "Alias");
        String initialByte = ImaPluginImpl.getStringProperty(map, "InitialByte");
        if ("All".equals(initialByte)) {
            this.initial_byte_count = 256;
        } else if ("List".equals(initialByte)) {
            this.initial_byte = new byte[256];
            int i = 0;
            while ((obj = map.get("InitialByte." + i)) != null && obj instanceof Number) {
                this.initial_byte[((Number)obj).intValue() & 0xFF] = 1;
                ++this.initial_byte_count;
                ++i;
            }
        }
        URL[] urls = new URL[this.classpath.length];
        File pluginFile = null;
        File abPluginFile = null;
        int count = 0;
        for (String path : this.classpath) {
            pluginFile = new File(path);
            if (!pluginFile.isAbsolute()) {
                String abpath = pluginFolder + path;
                abPluginFile = new File(abpath);
            } else {
                abPluginFile = pluginFile;
            }
            urls[count++] = abPluginFile.toURI().toURL();
        }
        this.loader = URLClassLoader.newInstance(urls, this.getClass().getClassLoader());
        if (this.trace.isTraceable(5)) {
            this.trace.trace("Create plug-in: " + this);
        }
        if (!ImaPluginListener.class.isAssignableFrom(cls = Class.forName(this.classname, true, this.loader))) {
            throw new IllegalArgumentException("The class is not an ImaPluginListener");
        }
        Constructor<?> init = cls.getConstructor(new Class[0]);
        if (init == null) {
            throw new IllegalArgumentException("The class does not have an empty constructor");
        }
        this.plugin = (ImaPluginListener)init.newInstance(new Object[0]);
        if (!this.isValidator) {
            try {
                plugins.put(this.name, this);
                this.plugin.initialize(this);
            }
            catch (Throwable th) {
                plugins.remove(this.name);
                throw new RuntimeException("Initialization failed for plugin: " + this.name, th);
            }
        } else if (this.plugin instanceof ImaPluginConfigValidator) {
            ((ImaPluginConfigValidator)((Object)this.plugin)).validate(this);
        }
    }

    static synchronized int virtualConnectionID() {
        if (vconn == Integer.MAX_VALUE) {
            vconn = 0x7F000000;
        }
        return vconn++;
    }

    public static ImaPluginImpl getPlugin(String name) {
        return plugins.get(name);
    }

    static String getStringProperty(Map<String, Object> map, String name) {
        Object obj = map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "" + obj;
    }

    static int getIntProperty(Map<String, Object> map, String name, int defval) {
        Object obj = map.get(name);
        if (obj == null) {
            return defval;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return defval;
    }

    static String[] getStringArray(Map<String, Object> map, String name) {
        Object obj;
        int count = 0;
        int i = 0;
        while ((obj = map.get(name + '.' + i)) != null && obj instanceof String) {
            ++count;
            ++i;
        }
        String[] ret = new String[count];
        for (i = 0; i < count; ++i) {
            ret[i] = (String)map.get(name + '.' + i);
        }
        return ret;
    }

    @Override
    public ImaConnection createConnection(String protocol, String endpoint) {
        if (this.isValidator) {
            throw new RuntimeException("This call is not allowed from validation code");
        }
        ImaEndpointImpl endp = ImaEndpointImpl.getEndpoint(endpoint, false);
        if (endp == null) {
            throw new RuntimeException("The endpoint is not known");
        }
        ImaConnectionImpl connect = new ImaConnectionImpl(this, ImaPluginImpl.virtualConnectionID(), null, 0, endp, 4);
        connect.state = 1;
        connect.setProtocol(protocol);
        ImaPluginAction action = new ImaPluginAction(41, 512, 4);
        action.setObject(this);
        ImaPluginUtils.putIntValue(action.bb, connect.connectID);
        action.bb = ImaPluginUtils.putStringValue(action.bb, protocol);
        action.bb = ImaPluginUtils.putStringValue(action.bb, endpoint);
        action.bb = ImaPluginUtils.putStringValue(action.bb, this.protocol);
        action.send(this.channel);
        return connect;
    }

    @Override
    public ImaMessage createMessage(ImaMessageType mtype) {
        return new ImaMessageImpl(mtype);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProtocolFamily() {
        return this.protocol;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.props;
    }

    String[] getClasspath() {
        return this.classpath;
    }

    String[] getWebsocket() {
        return this.websocket;
    }

    String getClassName() {
        return this.classname;
    }

    int getCapabilities() {
        return this.capability;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    int getModification() {
        return this.modification;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getBuild() {
        return this.build;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    boolean isInitialByte(byte b) {
        if (this.initial_byte_count >= 256) {
            return true;
        }
        if (this.initial_byte_count == 0 || this.initial_byte == null) {
            return false;
        }
        return this.initial_byte[b & 0xFF] != 0;
    }

    boolean isWebSocket(String s) {
        if (this.websocket == null || s == null) {
            return false;
        }
        for (int i = 0; i < this.websocket.length; ++i) {
            if (!s.equalsIgnoreCase(this.websocket[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void log(String msgid, int level, String category, String msgformat, Object ... repl) {
        if (this.isValidator) {
            throw new RuntimeException("This call is not allowed from validation code");
        }
        Exception e = new Exception();
        StackTraceElement[] elem = e.getStackTrace();
        String filen = "java";
        int lineno = 0;
        if (elem.length > 1) {
            filen = elem[1].getFileName();
            if (filen == null) {
                filen = "java";
            } else {
                int pos;
                for (pos = filen.length(); pos > 0 && filen.charAt(pos - 1) != '/' && filen.charAt(pos - 1) != '\\'; --pos) {
                }
                filen = filen.substring(pos);
            }
            lineno = elem[1].getLineNumber();
        }
        this.trace(4, "log " + (msgid != null ? msgid : "*") + " " + filen + ':' + lineno + " " + (category != null ? category : "*") + " " + msgformat);
        HashMap<String, Object> map = null;
        if (repl.length > 0) {
            map = new HashMap<String, Object>(repl.length);
            for (int i = 0; i < repl.length; ++i) {
                map.put("" + i, repl[i]);
            }
        }
        ImaPluginAction action = new ImaPluginAction(46, 1024, 6);
        action.setObject(this);
        action.bb = ImaPluginUtils.putStringValue(action.bb, msgid);
        action.bb = ImaPluginUtils.putIntValue(action.bb, level);
        action.bb = ImaPluginUtils.putStringValue(action.bb, category);
        action.bb = ImaPluginUtils.putStringValue(action.bb, filen);
        action.bb = ImaPluginUtils.putIntValue(action.bb, lineno);
        action.bb = ImaPluginUtils.putStringValue(action.bb, msgformat);
        action.bb = ImaPluginUtils.putMapValue(action.bb, map);
        action.send(this.channel);
    }

    @Override
    public boolean isTraceable(int level) {
        return this.trace.isTraceable(level);
    }

    @Override
    public void trace(int level, String message) {
        if (level <= this.trace.traceLevel) {
            this.trace.trace(message);
        }
    }

    @Override
    public void trace(String message) {
        this.trace.trace(message);
    }

    @Override
    public void traceException(Throwable ex) {
        this.trace.traceException(ex);
    }

    @Override
    public void traceException(int level, Throwable ex) {
        if (level <= this.trace.traceLevel) {
            this.trace.traceException(ex);
        }
    }

    public void updateConfig(Map<String, Object> imap) {
        Object obj = imap.get("Properties");
        if (obj instanceof Map) {
            String okey;
            Map iprops = (Map)obj;
            HashSet<String> pendingRemoveKeySet = new HashSet<String>();
            for (Map.Entry<String, Object> entry : this.props.entrySet()) {
                okey = entry.getKey();
                if (iprops.containsKey(okey)) continue;
                pendingRemoveKeySet.add(okey);
            }
            for (Map.Entry<String, Object> entry : iprops.entrySet()) {
                okey = entry.getKey();
                Object value = entry.getValue();
                Object oldvalue = this.props.put(okey, value);
                Object subkey = null;
                Object subvalue = null;
                if (value instanceof Map && oldvalue != null) {
                    Map oldvaluemap = (Map)oldvalue;
                    Map valuemap = (Map)value;
                    HashSet pendingValueRemoveKeySet = new HashSet();
                    for (Map.Entry subentry : oldvaluemap.entrySet()) {
                        subkey = subentry.getKey();
                        if (valuemap.containsKey(subkey)) continue;
                        pendingValueRemoveKeySet.add(subkey);
                    }
                    for (Map.Entry subentry : valuemap.entrySet()) {
                        subkey = subentry.getKey();
                        subvalue = subentry.getValue();
                        this.plugin.onConfigUpdate(okey, subkey, subvalue);
                    }
                    for (Map.Entry removeKey : pendingValueRemoveKeySet) {
                        this.plugin.onConfigUpdate(okey, removeKey, null);
                    }
                    continue;
                }
                this.plugin.onConfigUpdate(okey, null, value);
            }
            for (String string : pendingRemoveKeySet) {
                this.props.remove(string);
                this.plugin.onConfigUpdate(string, null, null);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ImaPluginImpl ");
        sb.append("Name=\"" + this.name + "\" ");
        if (this.title != null) {
            sb.append("Title=\"" + this.title + "\" ");
        }
        if (this.version != null) {
            sb.append("Version=\"" + this.version + "\" ");
        }
        if (this.build != null) {
            sb.append("Build=\"" + this.build + "\" ");
            sb.append("Modification=\"" + this.modification + "\" ");
        }
        sb.append("Protocol=\"" + this.protocol + "\" ");
        if (this.alias != null) {
            sb.append("Alias=\"" + this.alias + "\" ");
        }
        sb.append("Classpath=" + this.loader.getURLs());
        return sb.toString();
    }

    static {
        Map<String, String> env = System.getenv();
        CONFIG_DIR = env.containsKey("IMA_CONFIG_DIR") ? env.get("IMA_CONFIG_DIR") : "/usr/share/amlen-server/config/";
        PLUGINS_DIR = CONFIG_DIR + "plugin/plugins/";
        plugins = new HashMap();
    }
}

