/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.impl.ImaPluginImpl;
import com.ibm.ima.plugin.impl.ImaPluginTraceImpl;
import com.ibm.ima.plugin.impl.ImaTrace;
import com.ibm.ima.plugin.util.ImaJson;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ImaPluginInstaller {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    static final Path USERFILES_DIR;
    static final String CONFIG_DIR;
    static final Path STAGING_INSTALL_DIR;
    static final Path STAGING_UNINSTALL_DIR;
    static final Path PLUGINS_DIR;
    static final String PLUGIN_CONFIG_NAME = "plugin.json";
    static final String PLUGIN_PROPS_FILE_NAME = "pluginproperties.json";
    static final int CAPABILITY_USETOPIC = 1;
    static final int CAPABILITY_USESHARED = 2;
    static final int CAPABILITY_USEQUEUE = 4;
    static final int CAPABILITY_USEBROWSE = 8;
    static final Path PLUGIN_TMP_FOLDER;
    static final ImaPluginTraceImpl trace;
    static final HashSet<String> allowedStringProps;
    static final HashSet<String> allowedIntProps;
    static final HashSet<String> allowedBooleanProps;
    static final HashSet<String> allowedArrayProps;
    static final HashSet<String> allowedObjectProps;

    private static Map<String, Object> parseConfigProperties(ImaJson jsConfig, int startIndex, int count) {
        HashMap<String, Object> result = new HashMap<String, Object>(count);
        block9: for (int index = 0; index < count; ++index) {
            ImaJson.Entry entry = jsConfig.getEntry(index + startIndex);
            switch (entry.objtype) {
                case JsonString: {
                    result.put(entry.name, entry.value);
                    continue block9;
                }
                case JsonInteger: {
                    result.put(entry.name, new Integer(entry.count));
                    continue block9;
                }
                case JsonNumber: {
                    result.put(entry.name, new Double(entry.value));
                    continue block9;
                }
                case JsonTrue: {
                    result.put(entry.name, Boolean.TRUE);
                    continue block9;
                }
                case JsonFalse: {
                    result.put(entry.name, Boolean.FALSE);
                    continue block9;
                }
                case JsonNull: {
                    result.put(entry.name, null);
                    continue block9;
                }
                case JsonObject: 
                case JsonArray: {
                    index += entry.count;
                }
            }
        }
        return result;
    }

    private static Map<String, Object> parseConfig(Path configPath, boolean mustExist) {
        Path configFilePath = configPath.resolve(PLUGIN_CONFIG_NAME);
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            if (mustExist) {
                System.err.println("Configuration file does not exist: " + configFilePath);
            }
            return null;
        }
        ImaJson jsConfig = new ImaJson();
        jsConfig.setAllowComments(true);
        try {
            int capability = 0;
            jsConfig.parse(configFilePath.toFile());
            HashMap<String, Object> config = new HashMap<String, Object>();
            for (int index = 1; index < jsConfig.getEntryCount(); ++index) {
                ImaJson.Entry entry = jsConfig.getEntry(index);
                boolean found = false;
                switch (entry.objtype) {
                    case JsonString: {
                        if (!allowedStringProps.contains(entry.name)) break;
                        config.put(entry.name, jsConfig.getValue(index));
                        found = true;
                        break;
                    }
                    case JsonInteger: {
                        if (!allowedIntProps.contains(entry.name)) break;
                        config.put(entry.name, jsConfig.getValue(index));
                        found = true;
                        break;
                    }
                    case JsonTrue: {
                        if ("UseQueue".equals(entry.name)) {
                            capability |= 4;
                            found = true;
                            break;
                        }
                        if ("UseTopic".equals(entry.name)) {
                            capability |= 1;
                            found = true;
                            break;
                        }
                        if ("UseBrowse".equals(entry.name)) {
                            capability |= 8;
                            found = true;
                            break;
                        }
                        if (!"UseShared".equals(entry.name)) break;
                        capability |= 2;
                        found = true;
                        break;
                    }
                    case JsonFalse: {
                        if (!allowedBooleanProps.contains(entry.name)) break;
                        found = true;
                        break;
                    }
                    case JsonArray: {
                        if (allowedArrayProps.contains(entry.name)) {
                            ImaJson.Entry arrayEntry;
                            int j;
                            if (!"InitialByte".equals(entry.name)) {
                                for (j = 0; j < entry.count; ++j) {
                                    arrayEntry = jsConfig.getEntry(index + j + 1);
                                    if (arrayEntry.objtype != ImaJson.JObject.JsonString) {
                                        System.err.println("The plug-in configuration property is not valid: Property=" + entry.name);
                                        return null;
                                    }
                                    String key = entry.name + '.' + j;
                                    config.put(key, arrayEntry.value);
                                }
                            } else {
                                if (entry.count > 255) {
                                    System.err.println("The plug-in \"InitialByte\" configuration property is not valid: Too many array entries");
                                    return null;
                                }
                                for (j = 0; j < entry.count; ++j) {
                                    Integer value;
                                    arrayEntry = jsConfig.getEntry(index + j + 1);
                                    if (arrayEntry.objtype == ImaJson.JObject.JsonString) {
                                        value = new Integer(arrayEntry.value.getBytes()[0]);
                                    } else if (arrayEntry.objtype == ImaJson.JObject.JsonInteger) {
                                        value = new Integer(arrayEntry.count & 0xFF);
                                    } else {
                                        System.err.println("The plug-in configuration property is not valid: Property=" + entry.name);
                                        return null;
                                    }
                                    String key = entry.name + '.' + j;
                                    config.put(key, value);
                                }
                            }
                            found = true;
                        }
                        index += entry.count;
                        break;
                    }
                    case JsonObject: {
                        if (allowedObjectProps.contains(entry.name)) {
                            Map<String, Object> props = ImaPluginInstaller.parseConfigProperties(jsConfig, index + 1, entry.count);
                            config.put(entry.name, props);
                            found = true;
                        }
                        index += entry.count;
                        break;
                    }
                }
                if (found) continue;
                System.err.println("The plug-in configuration property is unknown or not valid: Property=" + entry.name);
            }
            config.put("Capabilities", new Integer(capability));
            config.put("ProtocolMask", new Long(0x100000L));
            configFilePath = configPath.resolve(PLUGIN_PROPS_FILE_NAME);
            if (Files.exists(configFilePath, new LinkOption[0])) {
                ImaJson jsProps = new ImaJson();
                jsProps.setAllowComments(true);
                try {
                    jsProps.parse(configFilePath.toFile());
                    if (jsProps.getEntryCount() > 1) {
                        Map<String, Object> props = ImaPluginInstaller.parseConfigProperties(jsProps, 1, jsProps.getEntryCount() - 1);
                        config.put("Properties", props);
                    }
                }
                catch (Exception ex) {
                    System.err.println("The parsing of plug-in configuration properties has failed.");
                    ex.printStackTrace();
                    return null;
                }
            }
            return config;
        }
        catch (Exception ex) {
            System.err.println("The parsing of plug-in configuration has failed.");
            ex.printStackTrace();
            return null;
        }
    }

    static boolean validate(Path configPath, boolean createPluginInstance) {
        Map<String, Object> config = ImaPluginInstaller.parseConfig(configPath, true);
        if (config == null) {
            return false;
        }
        return ImaPluginInstaller.validate(configPath, config, createPluginInstance);
    }

    static boolean validate(Path configPath, Map<String, Object> config, boolean createPluginInstance) {
        String classPath;
        int i = 0;
        int j = 0;
        if (!config.containsKey("Name")) {
            System.err.println("A required plug-in property (Name) is not set");
            return false;
        }
        String name = (String)config.get("Name");
        if (name == null || name.isEmpty()) {
            System.err.println("Plugin name property is empty");
            return false;
        }
        while ((classPath = (String)config.get("Classpath." + i)) != null) {
            ++i;
            String jarPath = classPath.startsWith(File.separator) ? classPath : configPath + File.separator + classPath;
            File file = new File(jarPath);
            if (file.exists()) {
                ++j;
                continue;
            }
            System.err.println("A specifiled Classpath entry does not exists: " + classPath + " (" + file.getAbsolutePath() + ')');
        }
        if (i == 0) {
            System.err.println("A required plug-in property (Classpath) is not set");
            return false;
        }
        if (j < i) {
            return false;
        }
        if (!config.containsKey("Class")) {
            System.err.println("A required plug-in property (Class) is not set");
            return false;
        }
        if (!config.containsKey("Protocol")) {
            System.err.println("A required plug-in property (Protocol) is not set");
            return false;
        }
        if (createPluginInstance) {
            try {
                config.put("ValidateConfigFolder", configPath.toString());
                ImaPluginImpl plugin = new ImaPluginImpl(config, null);
                System.err.println("Plugin instance creation validated successfully for plugin " + plugin);
            }
            catch (Throwable th) {
                System.err.println("Plugin instance creation has failed.");
                th.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int rc;
        block23: {
            if (args.length == 0 || "test".equals(args[0])) {
                System.err.println("Java plugin process started successfully.");
                System.exit(0);
            }
            rc = 255;
            String action = args[0];
            try {
                Files.createDirectories(PLUGIN_TMP_FOLDER, new FileAttribute[0]);
                String dir = System.getenv("PLUGINS_DIR");
                if (dir != null) {
                    ImaPluginImpl.PLUGINS_DIR = dir;
                }
                if (action.equals("Install")) {
                    boolean allowOverwrite = true;
                    String pluginName = null;
                    Path zipFile = null;
                    Path propsFile = null;
                    for (int i = 1; i < args.length; ++i) {
                        if (args[i].startsWith("Zip=")) {
                            String pluginZip = args[i].substring("Zip=".length(), args[i].length());
                            if (pluginZip.length() <= 0 || Files.exists(zipFile = USERFILES_DIR.resolve(pluginZip), new LinkOption[0])) continue;
                            zipFile = null;
                            continue;
                        }
                        if (args[i].startsWith("allowOverwrite=")) {
                            allowOverwrite = Boolean.parseBoolean(args[i].substring("allowOverwrite=".length(), args[i].length()));
                            continue;
                        }
                        if (args[i].startsWith("propertiesFile=")) {
                            String propertiesFile = args[i].substring("propertiesFile=".length(), args[i].length());
                            if (propertiesFile.length() <= 0 || Files.exists(propsFile = USERFILES_DIR.resolve(propertiesFile), new LinkOption[0])) continue;
                            propsFile = null;
                            continue;
                        }
                        if (args[i].startsWith("Name=")) {
                            pluginName = args[i].substring("Name=".length(), args[i].length());
                            continue;
                        }
                        System.err.println("Unknown parameter for plugin install action: " + args[i]);
                    }
                    if (!ImaPluginInstaller.installPlugin(pluginName, zipFile, propsFile, allowOverwrite)) break block23;
                    rc = 0;
                    if (zipFile != null) {
                        try {
                            Files.delete(zipFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (propsFile != null) {
                        try {
                            Files.delete(propsFile);
                        }
                        catch (Exception exception) {}
                    }
                    break block23;
                }
                if (action.equals("Remove")) {
                    String pluginName = null;
                    for (int i = 1; i < args.length; ++i) {
                        if (args[i].startsWith("Name=")) {
                            pluginName = args[i].substring("Name=".length(), args[i].length());
                            continue;
                        }
                        System.err.println("Unknown parameter for plugin remove action: " + args[i]);
                    }
                    if (ImaPluginInstaller.uninstallPlugin(pluginName)) {
                        rc = 0;
                    }
                } else {
                    System.err.println("Unknown action: " + action);
                }
            }
            catch (Throwable th) {
                System.err.println("Action " + action + " failed.");
                th.printStackTrace();
            }
        }
        Remover rm = new Remover(PLUGIN_TMP_FOLDER);
        try {
            rm.execute();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(rc);
    }

    static boolean uninstallPlugin(String pluginName) {
        if (pluginName == null || pluginName.length() == 0) {
            System.err.println("Plugin name was not specified for uninstall action");
            return false;
        }
        try {
            boolean found = false;
            Path pluginPath = PLUGINS_DIR.resolve(pluginName);
            if (Files.exists(pluginPath, new LinkOption[0])) {
                Path stagingPath = STAGING_UNINSTALL_DIR.resolve(pluginName);
                if (!Files.exists(stagingPath, new LinkOption[0])) {
                    Files.createDirectory(stagingPath, new FileAttribute[0]);
                }
                found = true;
            }
            if (Files.exists(pluginPath = STAGING_INSTALL_DIR.resolve(pluginName), new LinkOption[0])) {
                Remover rm = new Remover(pluginPath);
                rm.execute();
                found = true;
            }
            if (found) {
                System.err.println("Plugin " + pluginName + " was uninstalled successfully");
            } else {
                System.err.println("Plugin " + pluginName + " is not installed");
            }
            return found;
        }
        catch (Throwable th) {
            System.err.println("Uninstall failed for plugin: " + pluginName);
            th.printStackTrace();
            return false;
        }
    }

    static boolean installPlugin(String pluginName, Path zipFile, Path propsFile, boolean allowOverwrite) {
        if (zipFile == null) {
            if (propsFile == null) {
                System.err.println("Neither new plugin zip nor new properties file exist. Keep existing configuration.");
                return true;
            }
            return ImaPluginInstaller.updatePluginProperites(pluginName, propsFile, allowOverwrite);
        }
        if (pluginName == null || pluginName.length() == 0) {
            System.err.println("Plugin name was not specified for install action");
            return false;
        }
        Path tmpPath = PLUGIN_TMP_FOLDER.resolve("plugin." + System.currentTimeMillis());
        try {
            Map<String, Object> config;
            ImaPluginInstaller.validateZipFile(zipFile);
            ImaPluginInstaller.unzipPluginFile(zipFile.toFile(), tmpPath);
            if (propsFile != null) {
                Files.copy(propsFile, tmpPath.resolve(PLUGIN_PROPS_FILE_NAME), new CopyOption[0]);
            }
            if ((config = ImaPluginInstaller.parseConfig(tmpPath, true)) == null) {
                return false;
            }
            if (config.containsKey("Name")) {
                if (!pluginName.equals(config.get("Name"))) {
                    System.err.println("Requested plug-in name is different from the configured name.");
                    return false;
                }
            } else {
                config.put("Name", pluginName);
            }
            ConfigValidator cv = new ConfigValidator(config, allowOverwrite);
            cv.execute();
            if (cv.getResult()) {
                System.err.println("Configuration conflict with existing plug-in detected.");
                return false;
            }
            if (!ImaPluginInstaller.validate(tmpPath, config, true)) {
                System.err.println("Plugin validation failed.");
                return false;
            }
            Path pluginFolder = STAGING_INSTALL_DIR.resolve(pluginName);
            if (Files.exists(pluginFolder, new LinkOption[0])) {
                Remover rm = new Remover(pluginFolder);
                rm.execute();
            }
            Copier cp = new Copier(tmpPath, pluginFolder, true);
            cp.execute();
            System.err.println("Plug-in was installed successfully: " + pluginName);
            return true;
        }
        catch (Throwable th) {
            String error = "Failed to install plugin using : " + zipFile.toFile().getName();
            if (propsFile != null) {
                error = error + " and " + propsFile.toFile().getName();
            }
            System.err.println(error);
            th.printStackTrace();
            return false;
        }
    }

    static void validateZipFile(Path pluginZip) throws IOException {
        try {
            ZipFile zipfile = new ZipFile(pluginZip.toFile());
            zipfile.close();
        }
        catch (IOException ex) {
            System.err.println("Plugin zip file is corrupted");
            throw ex;
        }
    }

    static void unzipPluginFile(File pluginZip, Path pluginFolder) throws IOException {
        byte[] data = new byte[8192];
        if (!Files.exists(pluginFolder, new LinkOption[0])) {
            Files.createDirectories(pluginFolder, new FileAttribute[0]);
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(pluginZip));
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            Path path = pluginFolder.resolve(entry.getName());
            if (!entry.isDirectory()) {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path.toFile()));
                int n = zis.read(data);
                while (n != -1) {
                    bos.write(data, 0, n);
                    n = zis.read(data);
                }
                bos.close();
            } else {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
        zis.close();
    }

    static boolean updatePluginProperites(String pluginName, Path propsFile, boolean allowOverwrite) {
        Path stagingDir;
        boolean exists = false;
        if (pluginName == null || pluginName.length() == 0) {
            System.err.println("Plugin name was not specified for update properties action");
            return false;
        }
        Path tmpPath = PLUGIN_TMP_FOLDER.resolve(pluginName);
        Path pluginDir = PLUGINS_DIR.resolve(pluginName);
        if (Files.exists(pluginDir, new LinkOption[0])) {
            exists = true;
            Copier cp = new Copier(pluginDir, tmpPath, true);
            try {
                cp.execute();
            }
            catch (IOException e) {
                System.err.println("Failed to copy plugin directory into temporary area.");
                e.printStackTrace();
                return false;
            }
        }
        if (Files.exists(stagingDir = STAGING_INSTALL_DIR.resolve(pluginName), new LinkOption[0])) {
            exists = true;
            Copier cp = new Copier(stagingDir, tmpPath, true);
            try {
                cp.execute();
            }
            catch (IOException e) {
                System.err.println("Failed to copy plugin(staging) directory in temporary area.");
                e.printStackTrace();
                return false;
            }
        }
        if (!exists) {
            System.err.println("Plugin " + pluginName + " does not exist. Update is not allowed for a non-existing object.");
            return false;
        }
        Path dstFile = tmpPath.resolve(PLUGIN_PROPS_FILE_NAME);
        try {
            if (allowOverwrite) {
                Files.copy(propsFile, dstFile, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(propsFile, dstFile, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to copy plug-in properties file to temporary location.");
            e.printStackTrace();
            return false;
        }
        if (ImaPluginInstaller.validate(tmpPath, true)) {
            dstFile = stagingDir.resolve(PLUGIN_PROPS_FILE_NAME);
            try {
                if (!Files.exists(stagingDir, new LinkOption[0])) {
                    Files.createDirectory(stagingDir, new FileAttribute[0]);
                }
                Files.copy(propsFile, dstFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                System.err.println("Failed to copy plug-in properties file to staging folder.");
                e.printStackTrace();
                return false;
            }
            System.err.println("Configuration properties were updated successfully for plugin: " + pluginName);
            return true;
        }
        System.err.println("Configuration properties were not updated for plugin: " + pluginName);
        return false;
    }

    static {
        Map<String, String> env = System.getenv();
        CONFIG_DIR = env.containsKey("IMA_CONFIG_DIR") ? env.get("IMA_CONFIG_DIR") : "/usr/share/amlen-server/config/";
        USERFILES_DIR = env.containsKey("IMA_USERFILES_DIR") ? Paths.get(env.get("IMA_USERFILES_DIR"), new String[0]) : Paths.get("IMA_SVR_DATA_PATH/userfiles/", new String[0]);
        STAGING_INSTALL_DIR = Paths.get(CONFIG_DIR + "plugin/staging/install/", new String[0]);
        STAGING_UNINSTALL_DIR = Paths.get(CONFIG_DIR + "plugin/staging/uninstall/", new String[0]);
        PLUGINS_DIR = Paths.get(CONFIG_DIR + "plugin/plugins", new String[0]);
        PLUGIN_TMP_FOLDER = Paths.get("/tmp/plugin", new String[0]);
        trace = ImaTrace.init("stderr", 9, false);
        allowedStringProps = new HashSet(32);
        allowedIntProps = new HashSet(32);
        allowedBooleanProps = new HashSet(32);
        allowedArrayProps = new HashSet(32);
        allowedObjectProps = new HashSet(32);
        allowedStringProps.add("Name");
        allowedStringProps.add("Class");
        allowedStringProps.add("Method");
        allowedStringProps.add("Protocol");
        allowedStringProps.add("Author");
        allowedStringProps.add("Version");
        allowedStringProps.add("Copyright");
        allowedStringProps.add("Build");
        allowedStringProps.add("Description");
        allowedStringProps.add("License");
        allowedStringProps.add("Title");
        allowedStringProps.add("Alias");
        allowedIntProps.add("Modification");
        allowedBooleanProps.add("UseQueue");
        allowedBooleanProps.add("UseTopic");
        allowedBooleanProps.add("UseBrowse");
        allowedBooleanProps.add("UseShared");
        allowedObjectProps.add("Properties");
        allowedArrayProps.add("Classpath");
        allowedArrayProps.add("WebSocket");
        allowedArrayProps.add("HttpHeader");
        allowedArrayProps.add("InitialByte");
    }

    private static final class ConfigValidator
    extends SimpleFileVisitor<Path> {
        private final Map<String, Object> newConfig;
        private final String name;
        private final String protocol;
        private final String[] webSockets;
        private final boolean allowOverwrite;
        private boolean result = false;

        ConfigValidator(Map<String, Object> config, boolean overwrite) {
            String ws;
            this.newConfig = config;
            this.allowOverwrite = overwrite;
            this.name = (String)this.newConfig.get("Name");
            this.protocol = (String)this.newConfig.get("Protocol");
            LinkedList<String> list = new LinkedList<String>();
            int i = 0;
            while ((ws = (String)config.get("WebSocket." + i)) != null) {
                list.addLast(ws);
                ++i;
            }
            String[] array = new String[list.size()];
            this.webSockets = list.toArray(array);
        }

        void execute() throws IOException {
            Files.walkFileTree(PLUGINS_DIR, EnumSet.noneOf(FileVisitOption.class), 1, this);
            Files.walkFileTree(STAGING_INSTALL_DIR, EnumSet.noneOf(FileVisitOption.class), 1, this);
        }

        boolean getResult() {
            return this.result;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Map existingConfig;
            if (Files.isDirectory(file, new LinkOption[0]) && (existingConfig = ImaPluginInstaller.parseConfig(file, false)) != null && this.checkForConflicts(existingConfig, this.allowOverwrite)) {
                this.result = true;
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        boolean checkForConflicts(Map<String, Object> existingConfig, boolean allowOverwrite) {
            String existingName = (String)existingConfig.get("Name");
            if (existingName.compareToIgnoreCase(this.name) == 0) {
                if (!allowOverwrite) {
                    System.err.println("Plugin already exists: " + existingName);
                    return true;
                }
                String existingProtocol = (String)existingConfig.get("Protocol");
                if (existingProtocol.compareToIgnoreCase(this.protocol) != 0) {
                    System.err.println("Protocol change is not allowed for existing plug-in: Name=" + existingName + " CurrentProtocol=" + existingProtocol + " NewProtocol=" + this.protocol);
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.webSockets.length; ++i) {
                String ws;
                int j = 0;
                while ((ws = (String)existingConfig.get("WebSocket." + j)) != null) {
                    if (ws.compareToIgnoreCase(this.webSockets[i]) == 0) {
                        System.err.println("The value of WebSocket is not unique across plug-ins: WebSocket=" + ws + " ExistingPlugin=" + existingName + " NewPlugin=" + this.name);
                        return true;
                    }
                    ++j;
                }
            }
            return false;
        }
    }

    private static final class Remover
    extends SimpleFileVisitor<Path> {
        private final Path folder;

        Remover(Path dir) {
            this.folder = dir;
        }

        void execute() throws IOException {
            Files.walkFileTree(this.folder, EnumSet.noneOf(FileVisitOption.class), 128, this);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path folder, IOException exc) throws IOException {
            if (exc == null) {
                Files.delete(folder);
                return FileVisitResult.CONTINUE;
            }
            throw exc;
        }
    }

    private static final class Copier
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path destination;
        private final boolean replaceExisting;

        Copier(Path src, Path dst, boolean overwrite) {
            this.source = src;
            this.destination = dst;
            this.replaceExisting = overwrite;
        }

        void execute() throws IOException {
            Files.walkFileTree(this.source, EnumSet.noneOf(FileVisitOption.class), 128, this);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path srcFolder, BasicFileAttributes attrs) throws IOException {
            if (!Files.isSymbolicLink(srcFolder)) {
                Path targetFolder = this.destination.resolve(this.source.relativize(srcFolder));
                if (this.replaceExisting) {
                    Files.copy(srcFolder, targetFolder, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(srcFolder, targetFolder, new CopyOption[0]);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path srcFile, BasicFileAttributes attrs) throws IOException {
            if (!Files.isSymbolicLink(srcFile)) {
                Path targetFile = this.destination.resolve(this.source.relativize(srcFile));
                if (this.replaceExisting) {
                    Files.copy(srcFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(srcFile, targetFile, new CopyOption[0]);
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

