/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.impl.ImaChannel;
import com.ibm.ima.plugin.impl.ImaPluginTraceImpl;
import com.ibm.ima.plugin.impl.ImaTrace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;

public class ImaPluginMain {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    static String ifname = "127.0.0.1";
    static int port = 9103;
    static int trclevel = 6;
    static String trcdest = "stdout";
    static volatile boolean stopping = false;
    static Map<String, Object> props;
    private static ServerSocket serverSocket;
    static ImaPluginTraceImpl trace;
    static boolean daemon;

    public static void help() {
        System.out.println("imaplugin: ");
        System.out.println("   -0 ... -9 = Set the trce level.  0=off  default=5");
        System.out.println("   -i ifname = Restrict to a single IP address. @=all, default=127.0.0.1");
        System.out.println("   -p        = Set the port number (1-65535). default=9103");
        System.out.println("   -t file   = Set the trace destination.  default=stdout");
        System.out.println("   -d        = Set daemon mode, trace is overridden by server config after startup");
        System.exit(255);
    }

    static String getStringProperty(Map<String, Object> map, String name) {
        Object obj = map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "" + obj;
    }

    static int getIntProperty(Map<String, Object> map, String name, int defval) {
        Object obj = map.get(name);
        if (obj == null) {
            return defval;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return defval;
    }

    public static void setConfig(Map<String, Object> xprops) {
        props = xprops;
        int tracemax = ImaPluginMain.getIntProperty(props, "TraceMax", -1);
        if (tracemax > 0) {
            if (tracemax < 2) {
                tracemax = 2;
            }
            if (tracemax > 2000) {
                tracemax = 2000;
            }
            tracemax = tracemax * 1024 * 1024;
            trace.setFileMax(tracemax);
        }
        if (daemon) {
            String tracefile = ImaPluginMain.getStringProperty(props, "TracePluginFile");
            int tracelevel = ImaPluginMain.getIntProperty(props, "TracePluginLevel", -1);
            if (tracelevel < 0) {
                tracelevel = ImaPluginMain.getIntProperty(props, "TraceLevel", -1);
            }
            if (tracefile != null || tracelevel >= 0) {
                if (tracelevel >= 0) {
                    trace.setTraceLevel(tracelevel);
                }
                if (tracefile != null && !tracefile.equals(ImaPluginMain.trace.destination)) {
                    trace.setTraceFile(tracefile, true);
                }
                ImaTrace.trace(2, "Configure IBM MessageSight plug-in process: Port=" + port + " Interface=" + ifname + " TraceLevel=" + trclevel);
            }
        }
    }

    public static Map<String, Object> getConfig() {
        return props;
    }

    public static String getStringConfig(String name) {
        if (props == null) {
            return null;
        }
        Object obj = props.get(name);
        if (obj == null) {
            return null;
        }
        return "" + obj;
    }

    public static int getIntConfig(String name, int deflt) {
        int ret = deflt;
        Object obj = props.get(name);
        if (obj != null) {
            if (obj instanceof Boolean) {
                ret = (Boolean)obj != false ? 1 : 0;
            } else if (obj instanceof Number) {
                ret = ((Number)obj).intValue();
            } else {
                try {
                    ret = Integer.parseInt("" + obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public static boolean getBooleanConfig(String name, boolean deflt) {
        int val = ImaPluginMain.getIntConfig(name, deflt ? 1 : 0);
        return val != 0;
    }

    public static void terminate(int rc, String reason) {
        try {
            stopping = true;
            serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ImaPluginMain.processArgs(args);
        System.out.println("Eclipse Amlen plug-in process");
        System.out.println("Copyright (C) 2014-2021 Contributors to the Eclipse Foundation.");
        trace = ImaTrace.init(trcdest, trclevel, false);
        ImaTrace.trace(2, "Start Eclipse Amlen plug-in process: Port=" + port + " Interface=" + ifname + " TraceLevel=" + trclevel);
        InetAddress iface = null;
        try {
            if ("@".equals(ifname)) {
                serverSocket = new ServerSocket(port, 1024);
            } else {
                iface = InetAddress.getByName(ifname);
                serverSocket = new ServerSocket(port, 1024, iface);
            }
            serverSocket.setReuseAddress(true);
        }
        catch (IOException iex) {
            ImaTrace.trace(1, "Error creating plug-in server socket.");
            ImaTrace.traceException(1, iex);
            stopping = true;
        }
        while (!stopping) {
            try {
                Socket clientSock = serverSocket.accept();
                new ImaChannel(clientSock).start();
            }
            catch (Exception iex) {
                if (stopping) continue;
                ImaTrace.trace(1, "Error accepting plug-in server socket.");
                ImaTrace.traceException(1, iex);
                stopping = true;
            }
        }
        ImaTrace.trace(2, "End IBM MessageSight plugin processor");
        System.exit(0);
    }

    static void processArgs(String[] args) {
        int i;
        String argp = "";
        block7: for (i = 0; i < args.length; ++i) {
            argp = args[i];
            if (argp.length() > 1 && argp.charAt(0) == '-') {
                switch (argp.charAt(1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        trclevel = argp.charAt(1) - 48;
                        break;
                    }
                    case 'i': {
                        if (++i >= args.length) continue block7;
                        ifname = args[i];
                        break;
                    }
                    case 'p': {
                        if (++i >= args.length || (port = Integer.parseInt(args[i])) >= 1 && port <= 35575) continue block7;
                        System.out.println("Port not valid: " + argp);
                        ImaPluginMain.help();
                        break;
                    }
                    case 't': {
                        if (++i >= args.length) continue block7;
                        trcdest = args[i];
                        break;
                    }
                    case 'd': {
                        daemon = true;
                        break;
                    }
                    default: {
                        System.out.println("Unknown switch: " + argp);
                        ImaPluginMain.help();
                        break;
                    }
                }
                continue;
            }
            System.out.println("Unknown argument: " + argp);
            ImaPluginMain.help();
        }
        if (i > args.length) {
            System.out.println("Trailing switch not valid: " + argp);
        }
    }

    static {
        daemon = false;
    }
}

