#!/usr/bin/sh
# Copyright (c) 2015-2021 Contributors to the Eclipse Foundation
# 
# See the NOTICE file(s) distributed with this work for additional
# information regarding copyright ownership.
# 
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0
# 
# SPDX-License-Identifier: EPL-2.0
#

SERVERTYPE=$1

LOGFILE="/var/lib/amlen-server/diag/logs/syncCerts.log"
CERTTAR="/var/lib/amlen-server/data/hasync/certdir.tar"


if [[ $SERVERTYPE = "primary" ]]
then

    date > $LOGFILE
    echo "Backup files on Primary" >> $LOGFILE
    cd /var/lib/amlen-server/data
    /bin/tar -czv -f ${CERTTAR} certificates >> $LOGFILE 2>&1    
   
else

    echo >> $LOGFILE
    date >> $LOGFILE
    echo "Restore file on Standby" >> $LOGFILE
    
    cd /var/lib/amlen-server/data
    mv certificates certificates.org
    tar xhvf ${CERTTAR} >> $LOGFILE 2>&1
    if [ -d /var/lib/amlen-server/data/certificates ]
    then
        rm -rf certificates.org >> $LOGFILE 2>&1
    else
        mv certificates.org certificates >> $LOGFILE 2>&1
    fi
    
    # copy config file transferred from v1 system to config dir
    if [ -d /var/lib/amlen-server/data/ima ]
    then
        echo "Process v1 configuration" >> $LOGFILE 2>&1
        mkdir -p /var/lib/amlen-server/data/config >> $LOGFILE 2>&1
        cp /var/lib/amlen-server/data/ima/config/server_dynamic.cfg /var/lib/amlen-server/data/config/. >> $LOGFILE 2>&1
        cp /var/lib/amlen-server/data/ima/config/mqcbridge_dynamic.cfg /var/lib/amlen-server/data/config/. >> $LOGFILE 2>&1
    fi

    # check if certs are transferred from v1 system
    if [ -d /var/lib/amlen-server/data//usr/share/amlen-server/certificates ]
    then
        cp -r /var/lib/amlen-server/data//usr/share/amlen-server/certificates /var/lib/amlen-server/data/. >> $LOGFILE 2>&1
    fi

    # delete unwanted dirs transferred from v1 system
    if [ -d /var/lib/amlen-server/data/home ]
    then
        rm -r /var/lib/amlen-server/data/home >> $LOGFILE 2>&1
        rm -r /var/lib/amlen-server/data/etc >> $LOGFILE 2>&1
        rm -r /var/lib/amlen-server/data/opt >> $LOGFILE 2>&1
        rm -r /var/lib/amlen-server/data/ima >> $LOGFILE 2>&1
    fi

fi

