/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.impl.ImaPluginAction;
import com.ibm.ima.plugin.impl.ImaPluginMain;
import com.ibm.ima.plugin.impl.ImaTrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;

public class ImaChannel
extends Thread {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    Socket sock;
    InputStream in;
    OutputStream out;
    int id = 0;
    boolean closed = false;

    ImaChannel(Socket sock) throws IOException {
        this.sock = sock;
        this.in = sock.getInputStream();
        this.out = sock.getOutputStream();
        this.setDaemon(true);
    }

    private void close() {
        if (!this.closed) {
            this.closed = true;
            ImaPluginMain.terminate(0, "Connection to IMA server is closed.");
        }
    }

    void setID(int id) {
        this.id = id;
    }

    @Override
    public void run() {
        IOException e = null;
        byte[] result = new byte[32768];
        block4: while (!this.closed && e == null) {
            int readlen;
            block12: {
                try {
                    int read_bytes = 0;
                    for (readlen = 0; readlen < 6; readlen += read_bytes) {
                        read_bytes = this.in.read(result, readlen, 6 - readlen);
                        if (read_bytes >= 0) continue;
                        ImaTrace.trace(4, "Connection closed by client: " + this.id);
                        break;
                    }
                    if (read_bytes < 0) {
                    }
                    break block12;
                }
                catch (IOException ioe) {
                    e = ioe;
                }
                break;
            }
            int datalen = ImaChannel.getIntBig(result, 2);
            if (result[1] > 15 || datalen > 0xFFFFFF) {
                e = new IOException("The connection data not valid: " + this.id);
                break;
            }
            if (datalen + 6 >= result.length) {
                byte[] ba = new byte[datalen + 1000];
                System.arraycopy(result, 0, ba, 0, 6);
                result = ba;
            }
            datalen += 6;
            int pos = 6;
            try {
                do {
                    if ((readlen = this.in.read(result, pos, datalen - pos)) >= 0) continue;
                    ImaTrace.trace(4, "Connection closed by client: " + this.id);
                    continue block4;
                } while ((pos += readlen) != datalen);
                ImaPluginAction act = new ImaPluginAction(this, result, datalen);
                act.process();
            }
            catch (IOException ioe) {
                e = ioe;
            }
        }
        if (!this.closed) {
            String err = "Channel closed: id=" + this.id;
            if (e != null) {
                err = err + ' ' + e.toString();
            }
            ImaTrace.trace(4, err);
            this.close();
        }
    }

    void send(ByteBuffer bb) {
        byte[] x = bb.array();
        try {
            this.out.write(x, 0, bb.limit());
        }
        catch (IOException e) {
            ImaTrace.trace(4, "Error sending data to server.");
            ImaTrace.traceException(4, e);
            this.close();
        }
    }

    static int getIntBig(byte[] buff, int offset) {
        return (buff[offset] & 0xFF) << 24 | (buff[offset + 1] & 0xFF) << 16 | (buff[offset + 2] & 0xFF) << 8 | buff[offset + 3] & 0xFF;
    }

    @Override
    public String toString() {
        return "ImaChannel id=" + this.id + " sock=" + this.sock;
    }
}

