/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.ImaConnection;
import com.ibm.ima.plugin.ImaConnectionListener;
import com.ibm.ima.plugin.ImaDestinationType;
import com.ibm.ima.plugin.ImaEndpoint;
import com.ibm.ima.plugin.ImaMessage;
import com.ibm.ima.plugin.ImaSubscription;
import com.ibm.ima.plugin.ImaSubscriptionType;
import com.ibm.ima.plugin.ImaTransactionListener;
import com.ibm.ima.plugin.impl.ImaChannel;
import com.ibm.ima.plugin.impl.ImaEndpointImpl;
import com.ibm.ima.plugin.impl.ImaMessageImpl;
import com.ibm.ima.plugin.impl.ImaPluginAction;
import com.ibm.ima.plugin.impl.ImaPluginImpl;
import com.ibm.ima.plugin.impl.ImaPluginUtils;
import com.ibm.ima.plugin.impl.ImaSubscriptionImpl;
import com.ibm.ima.plugin.impl.ImaTransactionImpl;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ImaConnectionImpl
implements ImaConnection {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    int connectID;
    int state;
    int index;
    private String address;
    private int port;
    String protocol;
    String protocolFamily;
    String clientID;
    private Object userData;
    private String user;
    private String password;
    private boolean allowSteal = false;
    private boolean transactionCapable = true;
    private String certname;
    private ImaEndpointImpl endpoint;
    private int flags;
    private byte[] savedData;
    boolean isClosed = false;
    private char http_op;
    private Map<String, Object> http_props;
    private Map<String, Object> http_out;
    private int keepAlive = 60;
    private int maxMsgInflight = 128;
    private int processedMsgCount;
    private boolean suspended = false;
    static final ThreadLocal<byte[]> tmpByteArray = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4096];
        }
    };
    ImaPluginImpl plugin;
    ImaChannel channel;
    int seqnum;
    volatile int needed = 0;
    ImaConnectionListener listener;
    private volatile int subscriptionCount = 1;
    static ConcurrentHashMap<Integer, ImaConnectionImpl> connects = new ConcurrentHashMap();
    HashMap<String, ImaSubscriptionImpl> subscriptions = new HashMap();
    HashMap<Integer, ImaPluginAction> work = new HashMap();
    static Charset utf8 = Charset.forName("UTF-8");
    static final int F_Secure = 1;
    static final int F_Reliable = 2;
    static final int F_Internal = 4;
    static final int F_Client = 8;

    ImaConnectionImpl(ImaChannel channel, int connectid, Map<String, Object> map) {
        String plugin_name;
        this.protocol = ImaConnectionImpl.getStringProperty(map, "Protocol");
        this.protocolFamily = ImaConnectionImpl.getStringProperty(map, "ProtocolFamily");
        this.clientID = ImaConnectionImpl.getStringProperty(map, "ClientID");
        this.address = ImaConnectionImpl.getStringProperty(map, "ClientAddr");
        this.endpoint = ImaEndpointImpl.getEndpoint(ImaConnectionImpl.getStringProperty(map, "Endpoint"), true);
        this.user = ImaConnectionImpl.getStringProperty(map, "User");
        this.password = ImaConnectionImpl.getStringProperty(map, "Password");
        this.index = ImaConnectionImpl.getIntProperty(map, "Index", 0);
        this.port = ImaConnectionImpl.getIntProperty(map, "Port", 0);
        this.certname = ImaConnectionImpl.getStringProperty(map, "CommonName");
        this.channel = channel;
        if (ImaConnectionImpl.getIntProperty(map, "Internal", 0) != 0) {
            this.flags |= 4;
        }
        if (ImaConnectionImpl.getIntProperty(map, "Secure", 0) != 0) {
            this.flags |= 1;
        }
        if (ImaConnectionImpl.getIntProperty(map, "Reliable", 1) != 0) {
            this.flags |= 2;
        }
        if ((plugin_name = ImaConnectionImpl.getStringProperty(map, "Plugin")) != null) {
            this.plugin = ImaPluginImpl.getPlugin(plugin_name);
        }
        if (this.plugin != null && (this.plugin.getCapabilities() & 0x100) != 0) {
            this.transactionCapable = false;
        }
        this.connectID = connectid;
        this.state = 1;
        connects.put(this.connectID, this);
    }

    ImaConnectionImpl(ImaPluginImpl plugin, int connectid, String address, int port, ImaEndpointImpl endpoint, int flags) {
        this.connectID = connectid;
        this.index = connectid;
        this.address = address;
        this.port = port;
        this.endpoint = endpoint;
        this.flags = flags;
        this.plugin = plugin;
        if (plugin != null && (plugin.getCapabilities() & 0x100) != 0) {
            this.transactionCapable = false;
        }
        connects.put(this.connectID, this);
    }

    static String getStringProperty(Map<String, Object> map, String name) {
        Object obj = map.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "" + obj;
    }

    static int getIntProperty(Map<String, Object> map, String name, int defval) {
        Object obj = map.get(name);
        if (obj == null) {
            return defval;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return defval;
    }

    private void accept() {
        this.protocolFamily = this.plugin.getProtocolFamily();
        if (this.protocol == null || this.protocol.isEmpty()) {
            this.protocol = this.protocolFamily;
        }
        this.state = 2;
        ImaPluginAction action = new ImaPluginAction(51, 256, 4);
        action.setObject(this);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        action.bb = ImaPluginUtils.putStringValue(action.bb, this.protocol);
        action.bb = ImaPluginUtils.putStringValue(action.bb, this.plugin.getProtocolFamily());
        action.bb = ImaPluginUtils.putStringValue(action.bb, this.plugin.getName());
        action.send(this.channel);
    }

    @Override
    public void setProtocol(String protocol) {
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("The protocol must be set before authenticate.");
        }
        this.protocol = protocol;
    }

    @Override
    public void setKeepAlive(int timeout) {
        this.keepAlive = timeout;
        if (this.state == 1 || this.state == 2 || this.state == 5) {
            return;
        }
        ImaPluginAction action = new ImaPluginAction(60, 256, 2);
        action.bb = ImaPluginUtils.putIntValue(action.bb, this.connectID);
        action.bb = ImaPluginUtils.putIntValue(action.bb, this.keepAlive);
        action.send(this.channel);
    }

    public synchronized int setWork(ImaPluginAction action) {
        if (this.work.isEmpty()) {
            this.seqnum = 1;
        }
        int seqnum = ++this.seqnum;
        this.work.put(seqnum, action);
        return seqnum;
    }

    public synchronized ImaPluginAction getWork(int seqnum) {
        ImaPluginAction ret = this.work.get(seqnum);
        if (ret != null) {
            this.work.remove(seqnum);
        }
        return ret;
    }

    @Override
    public void setIdentity(String clientid, String user, String password) {
        this.setIdentity(clientid, user, password, 3, false);
    }

    public void setIdentity(String clientid, String user, String password, int auth) {
        this.setIdentity(this.clientID, user, password, auth, false);
    }

    @Override
    public void setIdentity(String clientid, String user, String password, int auth, boolean allowSteal) {
        if (this.state != 2) {
            throw new IllegalStateException("The connection must be in accepted state.");
        }
        this.clientID = clientid;
        this.user = user;
        this.password = password;
        this.allowSteal = allowSteal;
        this.authenticate(auth);
    }

    @Override
    public void setCommonName(String certname) {
        if (this.state != 2 && this.state != 1) {
            throw new IllegalStateException("The connection must be in handshake or accepted state.");
        }
        this.certname = certname;
    }

    @Override
    public void authenticate(int authaction) {
        if (this.state != 2) {
            throw new IllegalStateException("The connection must be in acceted state to authenticate.");
        }
        this.state = authaction == 1 ? 4 : 3;
        ImaPluginAction action = new ImaPluginAction(52, 1024, 5);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        ImaPluginUtils.putIntValue(action.bb, this.seqnum);
        ImaPluginUtils.putByteValue(action.bb, (byte)authaction);
        ImaPluginUtils.putIntValue(action.bb, this.keepAlive);
        ImaPluginUtils.putIntValue(action.bb, this.maxMsgInflight);
        HashMap<String, Object> cmap = new HashMap<String, Object>(6);
        cmap.put("ClientID", this.clientID);
        if (this.user != null) {
            cmap.put("User", this.user);
        }
        if (this.password != null) {
            cmap.put("Password", this.password);
        }
        if (this.certname != null) {
            cmap.put("CommonName", this.certname);
        }
        cmap.put("Protocol", this.protocol);
        cmap.put("AllowSteal", this.allowSteal);
        cmap.put("TransactionCapable", this.transactionCapable);
        action.bb = ImaPluginUtils.putMapValue(action.bb, cmap);
        action.send(this.channel);
    }

    @Override
    public void close() {
        this.close(0, "Connection closed");
    }

    @Override
    public synchronized void close(int rc, String reason) {
        if (!this.isClosed) {
            this.state = 5;
            this.isClosed = true;
            connects.remove(this.connectID);
            ImaPluginAction action = new ImaPluginAction(58, 256, 4);
            ImaPluginUtils.putIntValue(action.bb, this.connectID);
            ImaPluginUtils.putIntValue(action.bb, 0);
            ImaPluginUtils.putIntValue(action.bb, rc);
            action.bb = ImaPluginUtils.putStringValue(action.bb, reason);
            action.send(this.channel);
        }
    }

    @Override
    public ImaConnectionListener getConnectionListener() {
        return this.listener;
    }

    @Override
    public String getCertName() {
        return this.certname;
    }

    @Override
    public String getClientAddress() {
        return this.address;
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public int getClientPort() {
        return this.port;
    }

    @Override
    public ImaEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getProtocolFamily() {
        return this.protocolFamily;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isClient() {
        return (this.flags & 8) != 0;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isReliable() {
        return (this.flags & 2) != 0;
    }

    @Override
    public boolean isSecure() {
        return (this.flags & 1) != 0;
    }

    @Override
    public String simpleSubscriptionName() {
        return "" + this.subscriptionCount++;
    }

    @Override
    public ImaSubscription newSubscription(String topic) {
        ImaSubscriptionImpl sub = new ImaSubscriptionImpl(ImaDestinationType.topic, topic, this.simpleSubscriptionName(), ImaSubscriptionType.NonDurable, false, false, this);
        return sub;
    }

    @Override
    public ImaSubscription newSubscription(ImaDestinationType desttype, String dest, String name, ImaSubscriptionType subType, boolean nolocal, boolean transacted) {
        if (transacted && !this.transactionCapable) {
            throw new RuntimeException("Connection is not transaction capable");
        }
        ImaSubscriptionImpl sub = new ImaSubscriptionImpl(desttype, dest, name, subType, nolocal, transacted, this);
        return sub;
    }

    public ImaMessage receiveRetained(int seqnum, String topic) {
        return null;
    }

    @Override
    public void requiredData(int needed) {
        this.needed = needed;
    }

    @Override
    public void send(ImaMessage message, ImaDestinationType desttype, String dest, Object ackObj) {
        this.send(message, desttype, dest, ackObj, null);
    }

    public void send(ImaMessage message, ImaDestinationType desttype, String dest, Object ackObj, ImaTransactionImpl transaction) {
        if (!(message instanceof ImaMessageImpl)) {
            throw new IllegalArgumentException("The message is not valid");
        }
        if (this.state != 4) {
            throw new IllegalStateException("The connection must be open to send a message.");
        }
        long handle = 0L;
        if (transaction != null) {
            if (!(transaction instanceof ImaTransactionImpl)) {
                throw new IllegalArgumentException("The transaction is not valid");
            }
            if (transaction.inUse() || !transaction.isValid()) {
                throw new RuntimeException("ImaTransaction object is not valid: inUse=" + transaction.inUse() + " isValid=" + transaction.isValid());
            }
            handle = transaction.handle;
        }
        ImaMessageImpl msg = (ImaMessageImpl)message;
        if (desttype == null && (desttype = msg.destType) == null) {
            desttype = ImaDestinationType.topic;
        }
        if (dest == null) {
            dest = msg.dest;
        }
        int flags = ImaMessageImpl.fromQoS(msg.qos) + (msg.retain << 3);
        if (msg.persistent) {
            flags |= 4;
        }
        if (desttype == ImaDestinationType.queue) {
            flags |= 0x20;
        }
        ImaPluginAction action = new ImaPluginAction(57, 1024, 6);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        if (ackObj != null) {
            int seqnum = this.setWork(action);
            ImaPluginUtils.putIntValue(action.bb, seqnum);
            action.setObject(ackObj);
        } else {
            ImaPluginUtils.putIntValue(action.bb, 0);
        }
        ImaPluginUtils.putByteValue(action.bb, (byte)ImaMessageImpl.fromMessageType(message.getMessageType()));
        ImaPluginUtils.putByteValue(action.bb, (byte)flags);
        if (desttype == ImaDestinationType.queue) {
            ImaPluginUtils.putStringValue(action.bb, dest);
        } else {
            ImaPluginUtils.putNullValue(action.bb);
        }
        ImaPluginUtils.putLongValue(action.bb, handle);
        action.bb = ImaPluginUtils.putMapValue(action.bb, msg.props, msg, desttype, dest);
        try {
            action.send(this.channel, msg.body, msg.body != null ? msg.body.length : 0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
    }

    @Override
    public void publish(ImaMessage message, String topic, Object ackObj) {
        this.send(message, ImaDestinationType.topic, topic, ackObj);
    }

    @Override
    public void sendData(String data) {
        byte[] b = data.getBytes(utf8);
        this.sendData(b, 0, b.length, true);
    }

    @Override
    public void sendData(byte[] data) {
        this.sendData(data, 0, data.length, false);
    }

    @Override
    public void sendData(byte[] b, int offset, int len, boolean isText) {
        ImaPluginAction action = new ImaPluginAction(50, len + 16, 2);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        ImaPluginUtils.putByteValue(action.bb, isText ? (byte)1 : 2);
        ImaPluginUtils.putNullValue(action.bb);
        ImaPluginUtils.putByteArrayValue(action.bb, b, offset, len);
        action.send(this.channel);
    }

    void invokeSubscription(ImaSubscriptionImpl sub, boolean ack) {
        ImaDestinationType desttype;
        int flags = 0;
        switch (sub.getReliability()) {
            case qos1: {
                flags = 4;
                break;
            }
            case qos2: {
                flags = 8;
                break;
            }
        }
        if (sub.getNoLocal()) {
            flags |= 2;
        }
        if ((desttype = sub.getDestinationType()) != null && desttype == ImaDestinationType.queue) {
            flags |= 1;
        }
        ImaPluginAction action = new ImaPluginAction(53, 1024, 8);
        int seqnum = 0;
        if (ack) {
            action.setObject(sub);
            seqnum = this.setWork(action);
        }
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        ImaPluginUtils.putIntValue(action.bb, seqnum);
        ImaPluginUtils.putByteValue(action.bb, (byte)flags);
        ImaPluginUtils.putByteValue(action.bb, (byte)sub.getShareType());
        ImaPluginUtils.putByteValue(action.bb, (byte)(sub.transacted ? 1 : 0));
        action.bb = ImaPluginUtils.putStringValue(action.bb, sub.getDestination());
        action.bb = ImaPluginUtils.putStringValue(action.bb, sub.getName());
        action.bb = ImaPluginUtils.putNullValue(action.bb);
        action.send(this.channel);
        if (!ack) {
            this.subscriptions.put(sub.getName(), sub);
            sub.isSubscribed = true;
        }
    }

    void closeSubscription(ImaSubscriptionImpl sub) {
        ImaPluginAction action = new ImaPluginAction(55, 256, 4);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        int seqnum = this.setWork(action);
        ImaPluginUtils.putIntValue(action.bb, seqnum);
        action.setObject(sub);
        ImaPluginUtils.putStringValue(action.bb, sub.getName());
        ImaPluginUtils.putIntValue(action.bb, sub.getShareType());
        action.send(this.channel);
    }

    @Override
    public void destroySubscription(Object waiter, String name, ImaSubscriptionType subType) {
        if (this.state != 4) {
            throw new IllegalStateException("The connection is not open.");
        }
        ImaPluginAction action = new ImaPluginAction(56, 256, 4);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        int seqnum = this.setWork(action);
        ImaPluginUtils.putIntValue(action.bb, seqnum);
        action.setObject(waiter);
        ImaPluginUtils.putStringValue(action.bb, name);
        ImaPluginUtils.putIntValue(action.bb, ImaSubscriptionImpl.fromSubscriptionType(subType));
        action.send(this.channel);
    }

    @Override
    public void log(String msgid, int level, String category, String msgformat, Object ... args) {
        this.plugin.log(msgid, level, category, msgformat, args);
    }

    public ImaMessage receiveRetained(String topic) {
        return null;
    }

    @Override
    public void deleteRetained(String topic, Object correlate) {
        if (this.state != 4) {
            throw new IllegalStateException("The connection must be open.");
        }
        ImaPluginAction action = new ImaPluginAction(62, 256, 3);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        if (correlate != null) {
            int seqnum = this.setWork(action);
            ImaPluginUtils.putIntValue(action.bb, seqnum);
            action.setObject(correlate);
        } else {
            ImaPluginUtils.putIntValue(action.bb, 0);
        }
        ImaPluginUtils.putStringValue(action.bb, topic);
        action.send(this.channel);
    }

    @Override
    public void deleteRetained(String topic) {
        this.deleteRetained(topic, null);
    }

    boolean pluginLookup(byte[] body, int length) {
        if (this.isClosed) {
            return false;
        }
        if (length == 0) {
            if (this.protocol == null) {
                this.protocol = "";
            }
            this.plugin = ImaPluginAction.findPlugin(this.protocol);
            if (this.plugin == null) {
                this.close(0, "No plugin defined for protocol: " + this.protocol);
                return false;
            }
        } else {
            byte[] data = Arrays.copyOfRange(body, 0, length);
            int index = ImaPluginAction.findPlugin(this, data);
            if (index < 0) {
                if (index == -1) {
                    StringBuffer sb = new StringBuffer(1024);
                    int maxLength = data.length < 64 ? data.length : 64;
                    sb.append("[ ");
                    for (int i = 0; i < maxLength; ++i) {
                        sb.append(data[i]);
                        if (data[i] > 31 && data[i] < 127) {
                            sb.append('(').append((char)data[i]).append(')');
                        }
                        sb.append(' ');
                    }
                    sb.append(']');
                    this.close(0, "No plugin defined for: " + sb.toString());
                } else {
                    this.savedData = data;
                }
                return false;
            }
            this.plugin = ImaPluginAction.plugins[index];
            if (this.protocol == null) {
                this.protocol = this.plugin.getName();
            }
        }
        this.listener = this.plugin.plugin.onConnection(this, this.protocol);
        if (this.listener == null) {
            this.close(0, "Connection is rejected by the plugin");
            return false;
        }
        this.accept();
        return true;
    }

    void onData(byte[] body) {
        if (!this.isClosed) {
            byte[] data = body;
            int dataLength = body.length;
            if (this.savedData != null) {
                data = tmpByteArray.get();
                if (data.length < (dataLength = this.savedData.length + body.length)) {
                    data = new byte[dataLength];
                    tmpByteArray.set(data);
                }
                System.arraycopy(this.savedData, 0, data, 0, this.savedData.length);
                System.arraycopy(body, 0, data, this.savedData.length, body.length);
                this.savedData = null;
            }
            if (this.state == 1 && !this.pluginLookup(data, dataLength)) {
                return;
            }
            int offset = 0;
            while (dataLength > 0 && !this.isClosed && dataLength >= this.needed) {
                this.needed = 0;
                int used = this.listener.onData(data, offset, dataLength);
                if (used > 0) {
                    offset += used;
                    dataLength -= used;
                    continue;
                }
                if (used >= 0) break;
                dataLength = 0;
                break;
            }
            if (dataLength > 0) {
                this.savedData = Arrays.copyOfRange(data, offset, dataLength);
            }
        }
    }

    void onMessage(String subname, ImaMessageImpl msg) {
        ImaSubscriptionImpl sub = this.subscriptions.get(subname);
        this.listener.onMessage(sub, msg);
        ++this.processedMsgCount;
        if (!this.suspended && this.processedMsgCount >= this.maxMsgInflight >> 2) {
            this.sendResumeRequest();
            this.processedMsgCount = 0;
        }
    }

    void onHttpData(byte[] body, char op, String path, String query, Map<String, Object> props) {
        String httpop = null;
        String content_type = null;
        switch (op) {
            case 'G': 
            case 'H': {
                httpop = "GET";
                body = null;
                break;
            }
            case 'P': {
                httpop = "POST";
                break;
            }
            case 'U': {
                httpop = "PUT";
                break;
            }
            case 'D': {
                httpop = "DELETE";
            }
        }
        if (body != null && props != null) {
            content_type = "" + props.get("]Content-Type");
        }
        this.http_props = props;
        this.http_op = op;
        if (this.state == 1 && !this.pluginLookup(null, 0)) {
            return;
        }
        this.listener.onHttpData(httpop, path, query, content_type, body);
    }

    void acknowledge(ImaMessageImpl msg, int rc, ImaTransactionImpl transaction) {
        ImaPluginAction action = new ImaPluginAction(61, 128, 4);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        ImaPluginUtils.putIntValue(action.bb, msg.seqnum);
        ImaPluginUtils.putIntValue(action.bb, rc);
        if (transaction != null) {
            if (transaction.inUse() || !transaction.isValid()) {
                throw new RuntimeException("ImaTransaction object is not valid: inUse=" + transaction.inUse() + " isValid=" + transaction.isValid());
            }
            ImaPluginUtils.putLongValue(action.bb, transaction.handle);
        } else {
            ImaPluginUtils.putLongValue(action.bb, 0L);
        }
        action.send(this.channel);
    }

    void onLivenessCheck() {
        boolean keepAlive = false;
        if (!this.isClosed) {
            if (this.listener != null) {
                keepAlive = this.listener.onLivenessCheck();
            }
            if (keepAlive) {
                return;
            }
            this.close(160, "The connection timed out");
        }
    }

    void onComplete(Object[] hdrs) {
        int seqnum = ((Number)hdrs[1]).intValue();
        int rc = ((Number)hdrs[2]).intValue();
        ImaPluginAction action = this.getWork(seqnum);
        if (action != null) {
            if (action.obj instanceof ImaTransactionImpl) {
                ImaTransactionImpl transaction = (ImaTransactionImpl)action.obj;
                transaction.onComplete(action.action, rc, hdrs[3]);
                return;
            }
            String reason = (String)hdrs[3];
            switch (action.action) {
                case 57: {
                    this.listener.onComplete(action.obj, rc, reason);
                    break;
                }
                case 53: {
                    this.onSubscribe((ImaSubscriptionImpl)action.obj, rc, reason);
                    break;
                }
                case 55: {
                    this.onCloseSubscription((ImaSubscriptionImpl)action.obj, rc, reason);
                    break;
                }
                default: {
                    this.listener.onComplete(action.obj, rc, reason);
                    break;
                }
            }
        } else {
            String reason = (String)hdrs[3];
            this.listener.onComplete(this.listener, rc, reason);
        }
    }

    void onSubscribe(ImaSubscriptionImpl sub, int rc, String reason) {
        if (rc == 0) {
            this.subscriptions.put(sub.getName(), sub);
            sub.isSubscribed = true;
        }
        this.listener.onComplete(sub, rc, reason);
    }

    void onCloseSubscription(ImaSubscriptionImpl sub, int rc, String reason) {
        this.subscriptions.remove(sub.getName());
        sub.isSubscribed = false;
        this.listener.onComplete(sub, rc, reason);
    }

    @Override
    public void sendHttpData(int rc, String content_type, byte[] bytes) {
        this.sendHttpData(rc, 0, content_type, bytes);
    }

    @Override
    public void sendHttpData(int rc, int options, String content_type, byte[] bytes) {
        if (this.http_op == '\u0000') {
            throw new IllegalStateException("HTTP calls are only allowed while processing an onHttpData");
        }
        switch (rc) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 400: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 409: 
            case 410: 
            case 413: 
            case 415: 
            case 500: 
            case 501: 
            case 503: {
                if (rc == 204) {
                    content_type = null;
                    bytes = new byte[]{};
                    break;
                }
                if (content_type != null && content_type.length() != 0) break;
                content_type = "text/plain";
                if (bytes != null) break;
                bytes = new byte[]{};
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid HTTP return code");
            }
        }
        ImaPluginAction action = new ImaPluginAction(63, 1024, 4);
        ImaPluginUtils.putIntValue(action.bb, this.connectID);
        ImaPluginUtils.putIntValue(action.bb, rc);
        action.bb = ImaPluginUtils.putStringValue(action.bb, content_type);
        action.bb = ImaPluginUtils.putIntValue(action.bb, options);
        action.bb = ImaPluginUtils.putMapValue(action.bb, this.http_out);
        action.bb = ImaPluginUtils.putByteArrayValue(action.bb, bytes, 0, bytes.length);
        action.send(this.channel);
        this.http_op = '\u0000';
        this.http_props = null;
        this.http_out = null;
    }

    @Override
    public void sendHttpData(int rc, String content_type, String data) {
        this.sendHttpData(rc, 0, content_type, data.getBytes(utf8));
    }

    @Override
    public void sendHttpData(int rc, int options, String content_type, String data) {
        this.sendHttpData(rc, options, content_type, data.getBytes(utf8));
    }

    @Override
    public String getHttpCookie(String name) {
        if (this.http_props == null) {
            return null;
        }
        return "" + this.http_props.get(name);
    }

    @Override
    public Set<String> getHttpCookieSet() {
        if (this.http_props == null) {
            return null;
        }
        Set<String> keyset = this.http_props.keySet();
        HashSet<String> myset = new HashSet<String>(keyset);
        for (String key : myset) {
            if (key.length() <= 0 || key.charAt(0) != ']') continue;
            myset.remove(key);
        }
        return myset;
    }

    @Override
    public String getHttpHeader(String name) {
        if (this.http_props == null) {
            return null;
        }
        Object obj = this.http_props.get("]" + name);
        if (obj == null || !(obj instanceof String)) {
            return null;
        }
        return "" + obj;
    }

    @Override
    public void setHttpHeader(String name, String value) {
        if (this.http_out == null) {
            this.http_out = new HashMap<String, Object>();
            if (this.http_op == '\u0000') {
                throw new IllegalStateException("HTTP calls are only allowed while processing an onHttpData");
            }
        }
        this.http_out.put("]" + name, value);
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public void suspendMessageDelivery() {
        this.suspended = true;
    }

    @Override
    public void resumeMessageDelivery() {
        this.suspended = false;
        if (this.processedMsgCount >= this.maxMsgInflight >> 2) {
            this.sendResumeRequest();
            this.processedMsgCount = 0;
        }
    }

    @Override
    public void createTransaction(ImaTransactionListener l) {
        new ImaTransactionImpl(this, l);
    }

    private void sendResumeRequest() {
        ImaPluginAction action = new ImaPluginAction(64, 64, 2);
        action.bb = ImaPluginUtils.putIntValue(action.bb, this.connectID);
        action.bb = ImaPluginUtils.putIntValue(action.bb, this.processedMsgCount);
        action.send(this.channel);
    }

    @Override
    public void getRetainedMessage(String topic, Object correlate) {
        if (topic == null) {
            throw new NullPointerException("Topic is null.");
        }
        ImaPluginAction action = new ImaPluginAction(65, 64, 3);
        action.bb = ImaPluginUtils.putIntValue(action.bb, this.connectID);
        int seqnum = this.setWork(action);
        ImaPluginUtils.putIntValue(action.bb, seqnum);
        action.setObject(correlate);
        action.bb = ImaPluginUtils.putStringValue(action.bb, topic);
        action.send(this.channel);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("ImaConnection Connect=").append(this.connectID).append(" ClientAddr=").append(this.address).append(" Port=").append(this.port).append(" Protocol=").append(this.protocol);
        if (this.endpoint != null) {
            sb.append(" Endpoint=\"").append(this.endpoint.getName()).append('\"');
        }
        if (this.clientID != null) {
            sb.append(" ClientID=\"").append(this.clientID).append('\"');
        }
        if (this.user != null) {
            sb.append(" User=\"").append(this.user).append('\"');
        }
        if (this.certname != null) {
            sb.append(" CommonName=\"").append(this.certname).append('\"');
        }
        return new String(sb);
    }
}

