/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ImaPluginTraceImpl {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    private static final SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z' ");
    private static final Charset utf8;
    public int traceLevel = 0;
    public String destination = "stdout";
    PrintWriter writer;
    ImaPluginTraceImpl parent;
    FileChannel fchannel;
    int maxSize = 0x6400000;
    private final Date date = new Date();

    public ImaPluginTraceImpl(String destination, int level, boolean append) {
        this.parent = null;
        if (destination == null) {
            destination = "stdout";
        }
        this.IMATraceInit(destination, level, append);
    }

    public ImaPluginTraceImpl(ImaPluginTraceImpl parent, int level) {
        this.parent = parent;
        if (level >= 0 && level <= 9) {
            this.setTraceLevel(level);
        }
    }

    public void setFileMax(int max) {
        this.maxSize = max;
    }

    private void IMATraceInit(String destination, int level, boolean append) {
        if (level < 0 || level > 9) {
            throw new RuntimeException("The IMA trace level is not valid. Valid values are 0 to 9.");
        }
        this.setTraceLevel(level);
        if (destination != null) {
            this.setTraceFile(destination, append);
        }
    }

    public void trace(String message) {
        if (message == null) {
            return;
        }
        if (this.parent != null) {
            this.parent.trace(message);
        } else {
            PrintWriter pw = this.writer;
            if (pw != null) {
                this.date.setTime(System.currentTimeMillis());
                pw.println(iso8601.format(this.date) + message);
                pw.flush();
            }
        }
        if (this.fchannel != null) {
            this.checkRoll();
        }
    }

    public void traceException(Throwable ex) {
        if (ex != null) {
            if (this.parent != null) {
                this.parent.traceException(ex);
            } else {
                PrintWriter pw = this.writer;
                if (pw != null) {
                    ex.printStackTrace(pw);
                    pw.flush();
                }
            }
        }
        if (this.fchannel != null) {
            this.checkRoll();
        }
    }

    public synchronized void checkRoll() {
        if (this.fchannel == null) {
            return;
        }
        try {
            if (this.fchannel.position() > (long)this.maxSize) {
                int dot = this.destination.lastIndexOf(46);
                final String backup = dot >= 0 ? this.destination.substring(0, dot) + "_back" + this.destination.substring(dot) : this.destination + "_back";
                FileOutputStream fos = null;
                fos = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        File destFile = new File(ImaPluginTraceImpl.this.destination);
                        File backupFile = new File(backup);
                        ImaPluginTraceImpl.this.writer.close();
                        ImaPluginTraceImpl.this.writer = null;
                        destFile.renameTo(backupFile);
                        FileOutputStream fos = new FileOutputStream(ImaPluginTraceImpl.this.destination, false);
                        ImaPluginTraceImpl.this.fchannel = fos.getChannel();
                        return fos;
                    }
                });
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, utf8);
                this.writer = new PrintWriter(osw);
            }
        }
        catch (Exception e) {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)System.out, utf8);
            this.fchannel = null;
            this.writer = new PrintWriter(osw);
            e.printStackTrace(this.writer);
        }
    }

    public synchronized int setTraceFile(String filename, boolean append) {
        if (filename == null) {
            throw new RuntimeException("The trace Destination is not valid");
        }
        this.destination = filename.trim();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        final boolean appendx = append;
        try {
            OutputStreamWriter osw;
            if (this.destination.equals("stdout")) {
                osw = new OutputStreamWriter((OutputStream)System.out, utf8);
                this.fchannel = null;
            } else if (this.destination.equals("stderr")) {
                osw = new OutputStreamWriter((OutputStream)System.err, utf8);
                this.fchannel = null;
            } else {
                FileOutputStream fos = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws FileNotFoundException {
                        FileOutputStream fos = new FileOutputStream(ImaPluginTraceImpl.this.destination, appendx);
                        ImaPluginTraceImpl.this.fchannel = fos.getChannel();
                        return fos;
                    }
                });
                osw = new OutputStreamWriter((OutputStream)fos, utf8);
            }
            this.writer = new PrintWriter(osw);
        }
        catch (Exception e) {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)System.out, utf8);
            this.fchannel = null;
            this.writer = new PrintWriter(osw);
            e.printStackTrace(this.writer);
        }
        return 1;
    }

    public synchronized int setTraceLevel(int level) {
        if (level >= 0 && level <= 9) {
            this.traceLevel = level;
            return 1;
        }
        return 0;
    }

    public boolean isTraceable(int level) {
        return level <= this.traceLevel;
    }

    public String getTraceDestination() {
        return this.destination;
    }

    static {
        iso8601.setTimeZone(TimeZone.getDefault());
        utf8 = Charset.forName("UTF-8");
    }
}

