/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.ImaConnection;
import com.ibm.ima.plugin.ImaDestinationType;
import com.ibm.ima.plugin.ImaReliability;
import com.ibm.ima.plugin.ImaSubscription;
import com.ibm.ima.plugin.ImaSubscriptionType;
import com.ibm.ima.plugin.impl.ImaConnectionImpl;

public class ImaSubscriptionImpl
implements ImaSubscription {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    private ImaDestinationType desttype;
    private String dest;
    private String name;
    private ImaSubscriptionType share;
    private ImaReliability qos = ImaReliability.qos2;
    private boolean nolocal;
    boolean isSubscribed;
    private ImaConnectionImpl connect;
    private Object userData;
    final boolean transacted;

    ImaSubscriptionImpl(ImaDestinationType desttype, String dest, String name, ImaSubscriptionType subType, boolean nolocal, boolean transacted, ImaConnectionImpl connect) {
        this.desttype = desttype;
        this.dest = dest;
        this.name = name;
        this.share = subType;
        this.nolocal = nolocal;
        this.connect = connect;
        this.transacted = transacted;
        this.isSubscribed = false;
        if (this.share == null) {
            this.share = ImaSubscriptionType.NonDurable;
        }
    }

    static ImaSubscriptionType toSubscriptionType(int share) {
        switch (share) {
            case 0: {
                return ImaSubscriptionType.NonDurable;
            }
            case 1: {
                return ImaSubscriptionType.Durable;
            }
        }
        return ImaSubscriptionType.NonDurable;
    }

    static int fromSubscriptionType(ImaSubscriptionType share) {
        switch (share) {
            case NonDurable: {
                return 0;
            }
            case Durable: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void subscribe() {
        if (this.isSubscribed) {
            throw new IllegalStateException("The subscription is already subscribed");
        }
        if (this.connect.state != 4) {
            throw new IllegalStateException("The connection is not open.");
        }
        this.connect.invokeSubscription(this, true);
    }

    @Override
    public void subscribeNoAck() {
        if (this.isSubscribed) {
            throw new IllegalStateException("The subscription is already subscribed");
        }
        if (this.connect.state != 4) {
            throw new IllegalStateException("The connection is not open. state=" + this.connect.state);
        }
        this.connect.invokeSubscription(this, false);
    }

    @Override
    public void close() {
        if (this.connect.state == 5) {
            this.isSubscribed = false;
        }
        if (this.isSubscribed) {
            this.connect.closeSubscription(this);
        }
    }

    @Override
    public ImaConnection getConnection() {
        return this.connect;
    }

    @Override
    public String getDestination() {
        return this.dest;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getNoLocal() {
        return this.nolocal;
    }

    @Override
    public ImaDestinationType getDestinationType() {
        return this.desttype;
    }

    @Override
    public ImaSubscriptionType getSubscriptionType() {
        return this.share;
    }

    int getShareType() {
        return ImaSubscriptionImpl.fromSubscriptionType(this.share);
    }

    @Override
    public void setReliability(ImaReliability qos) {
        if (this.transacted && qos == ImaReliability.qos0) {
            throw new RuntimeException("qos0 reliability is not allowed for transacted subscription");
        }
        this.qos = qos;
    }

    @Override
    public ImaReliability getReliability() {
        return this.qos;
    }

    @Override
    public boolean isSubscribed() {
        return this.isSubscribed;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("ImaSubscription={name=").append(this.name).append(" dest=").append(this.dest).append(" type=").append((Object)this.desttype).append(" qos=").append((Object)this.qos).append(" nolocal=").append(this.nolocal).append(" isSubscribed=").append(this.isSubscribed).append(" connect=").append(String.valueOf(this.connect));
        if (this.userData != null) {
            sb.append(" userData=").append(this.userData);
        }
        sb.append('}');
        return sb.toString();
    }
}

