/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.impl;

import com.ibm.ima.plugin.ImaConnection;
import com.ibm.ima.plugin.ImaTransaction;
import com.ibm.ima.plugin.ImaTransactionListener;
import com.ibm.ima.plugin.impl.ImaChannel;
import com.ibm.ima.plugin.impl.ImaConnectionImpl;
import com.ibm.ima.plugin.impl.ImaPluginAction;
import com.ibm.ima.plugin.impl.ImaPluginUtils;

final class ImaTransactionImpl
implements ImaTransaction {
    private final ImaConnectionImpl connection;
    private final ImaChannel channel;
    private final int connID;
    private final ImaTransactionListener listener;
    private boolean inUse = false;
    long handle = 0L;
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";

    public ImaTransactionImpl(ImaConnectionImpl connection, ImaTransactionListener listener) {
        if (listener == null) {
            throw new RuntimeException("Transaction listener is null");
        }
        this.connection = connection;
        this.listener = listener;
        this.connID = connection.connectID;
        this.channel = connection.channel;
        ImaPluginAction action = new ImaPluginAction(66, 128, 2);
        action.setObject(this);
        int seqnum = connection.setWork(action);
        ImaPluginUtils.putIntValue(action.bb, this.connID);
        ImaPluginUtils.putIntValue(action.bb, seqnum);
        action.send(this.channel);
    }

    @Override
    public ImaConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean inUse() {
        return this.inUse;
    }

    @Override
    public boolean isValid() {
        return this.handle != 0L;
    }

    @Override
    public ImaTransactionListener getTransactionListener() {
        return this.listener;
    }

    void onComplete(int action, int rc, Object data) {
        String reason = null;
        this.inUse = false;
        if (rc == 0) {
            this.handle = (Long)data;
        } else {
            reason = (String)data;
        }
        switch (action) {
            case 67: {
                this.listener.onCommit(this, rc, reason);
                break;
            }
            case 68: {
                this.listener.onRollback(this, rc, reason);
                break;
            }
            case 66: {
                this.listener.onCreate(this, rc, reason);
            }
        }
    }

    private void invokeAction(int act) {
        if (this.inUse) {
            throw new RuntimeException("Transaction is in use");
        }
        if (this.handle == 0L) {
            throw new RuntimeException("Transaction handle is null");
        }
        this.inUse = true;
        ImaPluginAction action = new ImaPluginAction(act, 128, 3);
        action.setObject(this);
        int seqnum = this.connection.setWork(action);
        ImaPluginUtils.putIntValue(action.bb, this.connID);
        ImaPluginUtils.putIntValue(action.bb, seqnum);
        ImaPluginUtils.putLongValue(action.bb, this.handle);
        this.handle = 0L;
        action.send(this.channel);
    }

    @Override
    public void commit() {
        this.invokeAction(67);
    }

    @Override
    public void rollback() {
        this.invokeAction(68);
    }
}

