/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ima.plugin.util;

public class ImaBase64 {
    public static final String COPYRIGHT = "\n\nCopyright (c) 2014-2021 Contributors to the Eclipse Foundation\nSee the NOTICE file(s) distributed with this work for additional\ninformation regarding copyright ownership.\n\nThis program and the accompanying materials are made available under the\nterms of the Eclipse Public License 2.0 which is available at\nhttp://www.eclipse.org/legal/epl-2.0\n\nSPDX-License-Identifier: EPL-2.0\n\n";
    static String b64digit = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static byte[] b64val = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    private ImaBase64() {
    }

    public static String toBase64(byte[] from) {
        int j = 0;
        int val = 0;
        int left = from.length;
        int len = (from.length + 2) / 3 * 3;
        char[] to = new char[len / 3 * 4];
        for (int i = 0; i < len; i += 3) {
            val = (from[i] & 0xFF) << 16;
            if (left > 1) {
                val |= (from[i + 1] & 0xFF) << 8;
            }
            if (left > 2) {
                val |= from[i + 2] & 0xFF;
            }
            to[j++] = b64digit.charAt(val >> 18 & 0x3F);
            to[j++] = b64digit.charAt(val >> 12 & 0x3F);
            to[j++] = left > 1 ? (int)b64digit.charAt(val >> 6 & 0x3F) : 61;
            to[j++] = left > 2 ? (int)b64digit.charAt(val & 0x3F) : 61;
            left -= 3;
        }
        return new String(to);
    }

    public static byte[] fromBase64(String from) {
        int j = 0;
        int value = 0;
        int bits = 0;
        if (from.length() % 4 != 0) {
            return null;
        }
        if (from.length() == 0) {
            return new byte[0];
        }
        int tolen = from.length() / 4 * 3;
        if (from.charAt(from.length() - 1) == '=') {
            --tolen;
        }
        if (from.charAt(from.length() - 2) == '=') {
            --tolen;
        }
        byte[] to = new byte[tolen];
        for (int i = 0; i < from.length(); ++i) {
            char ch = from.charAt(i);
            int bval = b64val[ch];
            if (ch == '=' && i + 2 < from.length()) {
                bval = -1;
            }
            if (bval >= 0) {
                value = value << 6 | bval;
                if ((bits += 6) < 8) continue;
                bits -= 8;
                if (j >= to.length) continue;
                to[j++] = (byte)(value >> bits & 0xFF);
                continue;
            }
            if (bval != -1) continue;
            return null;
        }
        return to;
    }
}

