/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.core;

import java.io.File;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.model.SigningAndKeysModelManager;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;

public class BackwardKeystoreManager {
    private static final String ANDMORE_TOOLS_PATH = String.valueOf(File.separator) + "eclipseandmore" + File.separator + "tools";
    private static final String USER_HOME_PATH = System.getProperty("user.home");
    private static final String TOOLS_FULL_PATH = String.valueOf(USER_HOME_PATH) + ANDMORE_TOOLS_PATH;
    private static final String KS_FILENAME_NEW = String.valueOf(TOOLS_FULL_PATH) + File.separatorChar + "andmore.keystore";
    private static final String KS_TYPE = "JCEKS";
    private static final String KS_DEFAULT_PASSWD = "passwd";
    private static final String KS_PASSWD_NODE = "org.eclipse.andmore.platform.tools.sign.core";
    private static final String KS_PASSWD_ATTRIBUTE = "kspasswd";

    private String removeOldKeystorePassword() {
        String oldPassword;
        block5: {
            oldPassword = KS_DEFAULT_PASSWD;
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = null;
            try {
                if (preferences.nodeExists(KS_PASSWD_NODE)) {
                    node = preferences.node(KS_PASSWD_NODE);
                    try {
                        oldPassword = node.get(KS_PASSWD_ATTRIBUTE, KS_DEFAULT_PASSWD);
                    }
                    catch (StorageException storageException) {
                        oldPassword = KS_DEFAULT_PASSWD;
                    }
                    node.remove(KS_PASSWD_ATTRIBUTE);
                    preferences.remove(KS_PASSWD_NODE);
                    node.flush();
                    break block5;
                }
                oldPassword = null;
            }
            catch (Exception e) {
                AndmoreLogger.error(BackwardKeystoreManager.class, (String)e.getMessage(), (Throwable)e);
            }
        }
        return oldPassword;
    }

    public void mapOldKeystore() {
        File andmoreKeystoreFile = new File(KS_FILENAME_NEW);
        if (andmoreKeystoreFile.exists()) {
            KeyStoreNode keyStoreNode = new KeyStoreNode(andmoreKeystoreFile, KS_TYPE);
            try {
                SigningAndKeysModelManager.getInstance().mapKeyStore(keyStoreNode);
                String oldPassword = this.removeOldKeystorePassword();
                if (oldPassword != null) {
                    PasswordProvider passwordProvider = new PasswordProvider(keyStoreNode.getFile());
                    passwordProvider.saveKeyStorePassword(oldPassword);
                    List<IKeyStoreEntry> iKeyStoreEntries = keyStoreNode.getEntries(oldPassword);
                    if (iKeyStoreEntries != null) {
                        for (IKeyStoreEntry keyStoreEntry : iKeyStoreEntries) {
                            passwordProvider.savePassword(keyStoreEntry.getAlias(), oldPassword);
                        }
                    }
                }
            }
            catch (Exception e) {
                EclipseUtils.showErrorDialog((String)NLS.bind((String)CertificateManagerNLS.KeystoreManagerView_ErrorImportingBackwardKeystore, (Object)andmoreKeystoreFile), (String)e.getMessage());
            }
        }
    }
}

