/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PasswordProvider {
    private static final String PREF_ROOT_NODE = "org.eclipse.andmore.android.certmanager_passwords";
    private static final String KS_PASSWORD_KEY = "KS_PASSWORD";
    private final File keyStoreFile;
    private final ISecurePreferences securePreferences;
    private boolean canSavePassword = true;

    public PasswordProvider(File keyStoreFile) {
        this(keyStoreFile, KeyStoreManager.getInstance().isKeystoreMapped(keyStoreFile));
    }

    public PasswordProvider(File keyStoreFile, boolean canSavePassword) {
        this.keyStoreFile = keyStoreFile;
        this.securePreferences = SecurePreferencesFactory.getDefault();
        this.canSavePassword = canSavePassword;
    }

    public String getKeyStorePassword(boolean promptPassword, boolean useSavedPassword) throws KeyStoreManagerException {
        return this.getPassword(KS_PASSWORD_KEY, promptPassword, useSavedPassword);
    }

    public String getKeyStorePassword(boolean promptPassword) throws KeyStoreManagerException {
        return this.getPassword(KS_PASSWORD_KEY, promptPassword, true);
    }

    public String getPassword(String alias, boolean promptPassword) throws KeyStoreManagerException {
        return this.getPassword(alias, promptPassword, true);
    }

    public String getPassword(String alias, boolean promptPassword, boolean useSavedPassword) throws KeyStoreManagerException {
        String password = null;
        if (useSavedPassword) {
            if (this.securePreferences != null) {
                String prefKey = alias;
                password = this.getSavedPasswd(prefKey);
            } else {
                throw new KeyStoreManagerException(CertificateManagerNLS.PasswordProvider_Error_WhileSaving);
            }
        }
        if (password == null && promptPassword) {
            password = this.promptPassword(alias);
        }
        return password;
    }

    private String getSavedPasswd(String prefKey) {
        String password = null;
        if (this.securePreferences.nodeExists(PREF_ROOT_NODE)) {
            ISecurePreferences node = this.securePreferences.node(PREF_ROOT_NODE);
            try {
                if (node.nodeExists(this.keyStoreFile.getAbsolutePath())) {
                    ISecurePreferences ksNode = node.node(this.keyStoreFile.getAbsolutePath());
                    password = ksNode.get(prefKey, null);
                }
            }
            catch (StorageException storageException) {}
        }
        return password;
    }

    private String promptPassword(final String alias) throws KeyStoreManagerException {
        final String[] result = new String[1];
        final Boolean[] canProceed = new Boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                KeyStorePasswdDialog dialog = new KeyStorePasswdDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), PasswordProvider.this.keyStoreFile, alias);
                int diagStatus = dialog.open();
                if (diagStatus == 0) {
                    result[0] = dialog.getPasswd();
                    PasswordProvider.this.canSavePassword = KeyStoreManager.getInstance().isKeystoreMapped(PasswordProvider.this.keyStoreFile);
                    canProceed[0] = dialog.mustSavePasswd();
                } else {
                    canProceed[0] = false;
                    result[0] = null;
                }
            }
        });
        if (canProceed[0].booleanValue() && this.canSavePassword) {
            if (this.securePreferences != null) {
                this.savePassword(alias, result[0]);
            } else {
                EclipseUtils.showWarningDialog((String)CertificateManagerNLS.PasswordProvider_DialogTitle, (String)CertificateManagerNLS.PasswordProvider_Error_WhileSaving);
            }
        }
        return result[0];
    }

    public void saveKeyStorePassword(String password) throws KeyStoreManagerException {
        this.savePassword(KS_PASSWORD_KEY, password);
    }

    public void savePassword(String alias, String password) throws KeyStoreManagerException {
        this.canSavePassword = KeyStoreManager.getInstance().isKeystoreMapped(this.keyStoreFile);
        if (this.canSavePassword) {
            String prefKey = alias != null ? alias : KS_PASSWORD_KEY;
            ISecurePreferences rootNode = this.securePreferences.node(PREF_ROOT_NODE);
            try {
                ISecurePreferences ksNode = rootNode.node(this.keyStoreFile.getAbsolutePath());
                ksNode.put(prefKey, password, true);
                ksNode.flush();
            }
            catch (Exception exception) {
                throw new KeyStoreManagerException(CertificateManagerNLS.PasswordProvider_Error_WhileSaving);
            }
        }
    }

    public void deleteKeyStoreSavedPasswordNode() throws KeyStoreManagerException {
        this.deleteSavedPassword(null);
    }

    public void deleteKeyStoreSavedPassword() throws KeyStoreManagerException {
        this.deleteSavedPassword(KS_PASSWORD_KEY);
    }

    public void deleteSavedPassword(String alias) throws KeyStoreManagerException {
        ISecurePreferences ksNode = this.getKeyStoreNode();
        if (ksNode != null) {
            if (alias == null) {
                ksNode.removeNode();
            } else {
                ksNode.remove(alias);
                if (ksNode.keys().length == 0) {
                    ksNode.removeNode();
                }
            }
            try {
                ksNode.flush();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
                throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.PasswordProvider_Error_WhileRemovingPassword, (Object)this.keyStoreFile.getName()));
            }
        }
    }

    public void cleanModel(List<String> aliasList) throws KeyStoreManagerException {
        ISecurePreferences keyStoreNode = this.getKeyStoreNode();
        if (keyStoreNode != null) {
            String[] savedKeys;
            String[] stringArray = savedKeys = keyStoreNode.keys();
            int n = savedKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String savedAlias = stringArray[n2];
                if (!savedAlias.equals(KS_PASSWORD_KEY) && !aliasList.contains(savedAlias)) {
                    keyStoreNode.remove(savedAlias);
                }
                ++n2;
            }
            try {
                keyStoreNode.flush();
            }
            catch (IOException iOException) {
                throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.PasswordProvider_Error_WhileRemovingPassword, (Object)this.keyStoreFile.getName()));
            }
        }
    }

    private ISecurePreferences getKeyStoreNode() {
        ISecurePreferences rootNode;
        ISecurePreferences ksNode = null;
        if (this.securePreferences.nodeExists(PREF_ROOT_NODE) && (rootNode = this.securePreferences.node(PREF_ROOT_NODE)).nodeExists(this.keyStoreFile.getAbsolutePath())) {
            ksNode = rootNode.node(this.keyStoreFile.getAbsolutePath());
        }
        return ksNode;
    }

    public boolean isPasswordSaved() {
        return this.isPasswordSaved(KS_PASSWORD_KEY);
    }

    public boolean isPasswordSaved(String prefKey) {
        ISecurePreferences ksNode = null;
        boolean isSaved = false;
        if (this.securePreferences.nodeExists(PREF_ROOT_NODE)) {
            ISecurePreferences rootNode = this.securePreferences.node(PREF_ROOT_NODE);
            ksNode = rootNode.node(this.keyStoreFile.getAbsolutePath());
            try {
                String value = ksNode.get(prefKey, null);
                isSaved = value != null;
            }
            catch (StorageException storageException) {
                AndmoreLogger.debug((String)("It was not possible to get if the " + prefKey + " is saved or not"));
                isSaved = false;
            }
        }
        return isSaved;
    }

    private final class KeyStorePasswdDialog
    extends Dialog {
        private final File keyStoreFile;
        private String passwd;
        private boolean savePasswd;
        private Text paswordText;
        private Button saveCheckBox;
        private final String alias;

        private KeyStorePasswdDialog(Shell parentShell, File keyStoreFile, String alias) {
            super(parentShell);
            this.keyStoreFile = keyStoreFile;
            this.alias = alias;
        }

        protected Control createDialogArea(Composite parent) {
            Composite mainComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            mainComposite.setLayout((Layout)gridLayout);
            Label messageLabel = new Label(mainComposite, 0);
            GridData gridData = new GridData(16384, 0x1000000, false, false, 2, 2);
            messageLabel.setLayoutData((Object)gridData);
            if (this.alias.equals(PasswordProvider.KS_PASSWORD_KEY)) {
                this.getShell().setText(CertificateManagerNLS.PasswordProvider_DialogTitle);
                messageLabel.setText(NLS.bind((String)CertificateManagerNLS.PasswordProvider_MessageLabel, (Object)this.keyStoreFile.getName()));
            } else {
                this.getShell().setText(CertificateManagerNLS.CertificateBlock_KeyPassword_Label);
                messageLabel.setText(NLS.bind((String)CertificateManagerNLS.PasswordProvider_Key_MessageLabel, (Object)this.alias));
            }
            Label passwdLabel = new Label(mainComposite, 0);
            gridData = new GridData(16384, 0x1000000, false, false);
            passwdLabel.setLayoutData((Object)gridData);
            passwdLabel.setText(CertificateManagerNLS.PasswordProvider_PasswordLabel);
            this.paswordText = new Text(mainComposite, 0x400800);
            gridData = new GridData(4, 0x1000000, true, false);
            this.paswordText.setLayoutData((Object)gridData);
            this.saveCheckBox = new Button(mainComposite, 32);
            this.saveCheckBox.setText(CertificateManagerNLS.PasswordProvider_SaveThisPassword);
            this.saveCheckBox.setSelection(false);
            gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
            this.saveCheckBox.setLayoutData((Object)gridData);
            this.saveCheckBox.setVisible(KeyStoreManager.getInstance().isKeystoreMapped(this.keyStoreFile));
            return super.createDialogArea(parent);
        }

        protected void okPressed() {
            this.passwd = this.paswordText.getText();
            this.savePasswd = this.saveCheckBox.getSelection();
            super.okPressed();
        }

        public String getPasswd() {
            return this.passwd;
        }

        public boolean mustSavePasswd() {
            return this.savePasswd;
        }
    }
}

