/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.packaging.sign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.andmore.android.certmanager.packaging.sign.ManifestEntry;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignException;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignatureFile;
import org.eclipse.andmore.android.common.log.AndmoreLogger;

public class ManifestDigester {
    private final Manifest manifest;
    private HashMap<String, ManifestEntry> entries = null;

    public ManifestDigester(Manifest manifest) {
        this.manifest = manifest;
        this.initialize();
    }

    private void initialize() {
        Map<String, Attributes> manifestEntries = this.manifest.getEntries();
        this.entries = new HashMap(manifestEntries.size());
        for (String entryName : manifestEntries.keySet()) {
            this.entries.put(entryName, new ManifestEntry(entryName, manifestEntries.get(entryName)));
        }
    }

    public String getDigestedString() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (ManifestEntry entry : this.entries.values()) {
            builder.append(entry.toDigestedManifestEntry());
            builder.append("\r\n");
        }
        return builder.toString();
    }

    public HashMap<String, ManifestEntry> getEntries() {
        return this.entries;
    }

    public byte[] getDigestedManifestMainAttributes() throws SignException {
        Manifest auxManifest = new Manifest();
        Attributes auxMainAttributes = auxManifest.getMainAttributes();
        Attributes mainAttributes = this.manifest.getMainAttributes();
        for (Object attributeKey : mainAttributes.keySet()) {
            String name = attributeKey.toString();
            String value = mainAttributes.getValue(name);
            auxMainAttributes.putValue(name, value);
        }
        byte[] result = ManifestDigester.getDigestedManifest(auxManifest);
        AndmoreLogger.info(SignatureFile.class, (String)"Created digest for main manifest attributes");
        return result;
    }

    public byte[] getDigestedManifest() throws SignException {
        return ManifestDigester.getDigestedManifest(this.manifest);
    }

    public static byte[] getDigestedManifest(Manifest manifest) throws SignException {
        byte[] digestedManifestBytes = null;
        ByteArrayOutputStream baos = null;
        try {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                baos = new ByteArrayOutputStream();
                manifest.write(baos);
                messageDigest.reset();
                digestedManifestBytes = messageDigest.digest(baos.toByteArray());
            }
            catch (IOException e) {
                AndmoreLogger.error(SignatureFile.class, (String)("I/O error encoding manifest digest: " + e.getMessage()));
                throw new SignException("I/O error encoding manifest digest", e);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                AndmoreLogger.error(SignatureFile.class, (String)"Error getting message digester");
                throw new SignException("Could digest the manifest");
            }
        }
        catch (Throwable throwable) {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (baos != null) {
                baos.close();
            }
        }
        catch (IOException iOException) {}
        if (digestedManifestBytes == null) {
            AndmoreLogger.error(SignatureFile.class, (String)"Error encoding manifest digest");
            throw new SignException("Could not encode manifest digest");
        }
        AndmoreLogger.info(SignatureFile.class, (String)"Created manifest digest");
        return digestedManifestBytes;
    }
}

