/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.action;

import org.eclipse.andmore.android.certmanager.command.BackupHandler;
import org.eclipse.andmore.android.certmanager.command.CertificatePropertiesHandler;
import org.eclipse.andmore.android.certmanager.command.ChangeKeyStoreTypeHandler;
import org.eclipse.andmore.android.certmanager.command.ChangePasswordKeyHandler;
import org.eclipse.andmore.android.certmanager.command.ChangePasswordKeystoreHandler;
import org.eclipse.andmore.android.certmanager.command.CreateKeyHandler;
import org.eclipse.andmore.android.certmanager.command.DeleteKeyHandler;
import org.eclipse.andmore.android.certmanager.command.DeleteKeystoreHandler;
import org.eclipse.andmore.android.certmanager.command.ImportKeyStoreEntriesHandler;
import org.eclipse.andmore.android.certmanager.command.RefreshHandler;
import org.eclipse.andmore.android.certmanager.command.SignExternalPackagesHandler;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PopupMenuActionDelegate
implements IObjectActionDelegate {
    public void run(IAction action) {
        ActionHandlers type = ActionHandlers.getActionHandlerbyId(action.getId());
        IHandler handler = null;
        if (type != null) {
            handler = type.getHandler();
        }
        if (handler != null) {
            ExecutionEvent event = new ExecutionEvent();
            try {
                handler.execute(event);
            }
            catch (ExecutionException e) {
                AndmoreLogger.error(PopupMenuActionDelegate.class, (String)e.getMessage(), (Throwable)e);
                EclipseUtils.showErrorDialog((String)"Execution error", (String)e.getMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    static enum ActionHandlers {
        SIGN_PACKAGE("org.eclipse.andmore.android.certmanager.core.ui.action.addSignature"){

            @Override
            public IHandler getHandler() {
                return new SignExternalPackagesHandler();
            }
        }
        ,
        BACKUP_KEYSTORE("org.eclipse.andmore.android.certmanager.core.ui.action.backupKeystore"){

            @Override
            public IHandler getHandler() {
                return new BackupHandler();
            }
        }
        ,
        DELETE_KEYSTORE("org.eclipse.andmore.android.certmanager.core.ui.action.deleteKeystore"){

            @Override
            public IHandler getHandler() {
                return new DeleteKeystoreHandler();
            }
        }
        ,
        PROPERTIES_KEYSTORE("org.eclipse.andmore.android.certmanager.core.ui.action.certificateProperties"){

            @Override
            public IHandler getHandler() {
                return new CertificatePropertiesHandler();
            }
        }
        ,
        CHANGE_KEYSTORE_PASSWORD("org.eclipse.andmore.android.certmanager.core.ui.action.changeKeystorePassword"){

            @Override
            public IHandler getHandler() {
                return new ChangePasswordKeystoreHandler();
            }
        }
        ,
        CHANGE_KEY_PASSWORD("org.eclipse.andmore.android.certmanager.core.ui.action.changeKeyPassword"){

            @Override
            public IHandler getHandler() {
                return new ChangePasswordKeyHandler();
            }
        }
        ,
        CREATE_KEY("org.eclipse.andmore.android.certmanager.core.ui.action.createKey"){

            @Override
            public IHandler getHandler() {
                return new CreateKeyHandler();
            }
        }
        ,
        DELETE_KEY("org.eclipse.andmore.android.certmanager.core.ui.action.deleteEntry"){

            @Override
            public IHandler getHandler() {
                return new DeleteKeyHandler();
            }
        }
        ,
        REFRESH("org.eclipse.andmore.android.certmanager.core.ui.action.refresh"){

            @Override
            public IHandler getHandler() {
                return new RefreshHandler();
            }
        }
        ,
        CHANGE_KEYSTORE_TYPE("org.eclipse.andmore.android.certmanager.core.ui.action.changeKeystoreType"){

            @Override
            public IHandler getHandler() {
                return new ChangeKeyStoreTypeHandler();
            }
        }
        ,
        IMPORT_KEYSTORE_ENTRIES("org.eclipse.andmore.android.certmanager.core.ui.action.importKeystoreEntries"){

            @Override
            public IHandler getHandler() {
                return new ImportKeyStoreEntriesHandler();
            }
        };

        private final String actionId;

        private ActionHandlers(String actionId) {
            this.actionId = actionId;
        }

        public abstract IHandler getHandler();

        public static ActionHandlers getActionHandlerbyId(String id) {
            ActionHandlers ret = null;
            ActionHandlers[] actionHandlersArray = ActionHandlers.values();
            int n = actionHandlersArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionHandlers h = actionHandlersArray[n2];
                if (h.actionId.equals(id)) {
                    ret = h;
                    break;
                }
                ++n2;
            }
            return ret;
        }
    }
}

