/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.dialogs.importks;

import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportEntriesDialog
extends TitleAreaDialog {
    private static final String WIZARD_BANNER = "icons/wizban/import_entries_wiz.png";
    private static final String HELP_ID = "org.eclipse.andmore.android.certmanager.import_entries_dialog";
    private IKeyStore sourceKeyStore;
    private IKeyStore targetKeyStore;
    private Text passwdText;
    protected String sourcePassword = "";
    private Table entriesTable;
    private CheckboxTableViewer entriesTableViewer;
    private final Map<String, String> aliasMap = new HashMap<String, String>();
    private Combo keyStoreCombo;
    private Combo targetKsCombo;
    protected List<String> selectedAlias = new ArrayList<String>();

    public ImportEntriesDialog(Shell parentShell, IKeyStore keyStore) {
        super(parentShell);
        this.setShellStyle(67680);
        this.targetKeyStore = keyStore;
        this.setTitleImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)WIZARD_BANNER).createImage());
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(CertificateManagerNLS.ImportKeyStoreDialog_Dialog_Title);
        this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_Default_Message);
        this.setTitle(CertificateManagerNLS.ImportKeyStoreDialog_Dialog_Title);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Group SourceGroup = new Group(container, 0);
        SourceGroup.setText(CertificateManagerNLS.ImportKeyStoreDialog_Source_Group);
        SourceGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        SourceGroup.setLayout((Layout)new GridLayout(1, false));
        Composite keyStoreComposite = new Composite((Composite)SourceGroup, 0);
        keyStoreComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        keyStoreComposite.setLayout((Layout)new GridLayout(3, false));
        Label keyStoreLabel = new Label(keyStoreComposite, 0);
        keyStoreLabel.setText(CertificateManagerNLS.ImportKeyStoreDialog_KeyStore_Label);
        this.keyStoreCombo = new Combo(keyStoreComposite, 8);
        this.keyStoreCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label passwdLabel = new Label(keyStoreComposite, 0);
        passwdLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        passwdLabel.setText(CertificateManagerNLS.ImportKeyStoreDialog_Password_Label);
        this.passwdText = new Text(keyStoreComposite, 0x400800);
        this.passwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportEntriesDialog.this.sourcePassword = ImportEntriesDialog.this.passwdText.getText();
            }
        });
        this.passwdText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
                ImportEntriesDialog.this.loadEntries();
            }
        });
        this.passwdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button loadButton = new Button(keyStoreComposite, 0);
        GridData gd_loadButton = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_loadButton.widthHint = 80;
        loadButton.setLayoutData((Object)gd_loadButton);
        loadButton.setText(CertificateManagerNLS.ImportKeyStoreDialog_Load_Button);
        Composite entriesComposite = new Composite((Composite)SourceGroup, 0);
        GridData gd_entriesComposite = new GridData(4, 4, true, true, 1, 1);
        gd_entriesComposite.heightHint = 200;
        entriesComposite.setLayoutData((Object)gd_entriesComposite);
        entriesComposite.setLayout((Layout)new GridLayout(1, true));
        this.entriesTableViewer = CheckboxTableViewer.newCheckList((Composite)entriesComposite, (int)67616);
        this.entriesTableViewer.setContentProvider((IContentProvider)new EntriesContentProvider());
        this.entriesTable = this.entriesTableViewer.getTable();
        this.entriesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    ImportEntriesDialog.this.validateUi();
                    TableItem item = (TableItem)e.item;
                    if (item.getChecked()) {
                        ImportEntriesDialog.this.selectedAlias.add(item.getText(0));
                    } else {
                        ImportEntriesDialog.this.selectedAlias.remove(item.getText(0));
                    }
                }
            }
        });
        this.entriesTable.setHeaderVisible(true);
        GridData gd_entriesTable = new GridData(4, 4, true, true, 1, 1);
        gd_entriesTable.heightHint = 250;
        this.entriesTable.setLayoutData((Object)gd_entriesTable);
        TableViewerColumn aliasViewerColumn = new TableViewerColumn((TableViewer)this.entriesTableViewer, 0);
        TableColumn tblclmnAlias = aliasViewerColumn.getColumn();
        tblclmnAlias.setWidth(100);
        tblclmnAlias.setText(CertificateManagerNLS.ImportKeyStoreDialog_Alias_Column);
        aliasViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((EntryModel)element).getAlias();
            }
        });
        TableViewerColumn passwordViewerColumn_1 = new TableViewerColumn((TableViewer)this.entriesTableViewer, 0);
        passwordViewerColumn_1.setEditingSupport((EditingSupport)new PasswordEditingSupport((ColumnViewer)this.entriesTableViewer));
        TableColumn tblclmnPassword = passwordViewerColumn_1.getColumn();
        tblclmnPassword.setWidth(100);
        tblclmnPassword.setText(CertificateManagerNLS.ImportKeyStoreDialog_Passwd_Column);
        passwordViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((EntryModel)element).getPasswd().replaceAll(".", "*");
            }
        });
        TableViewerColumn verifiedViewerColumn_2 = new TableViewerColumn((TableViewer)this.entriesTableViewer, 0);
        TableColumn tblclmnVerified = verifiedViewerColumn_2.getColumn();
        tblclmnVerified.setWidth(130);
        tblclmnVerified.setText(CertificateManagerNLS.ImportKeyStoreDialog_Verified_Column);
        verifiedViewerColumn_2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((EntryModel)element).isVerified() ? CertificateManagerNLS.ImportKeyStoreDialog_Verified_Pass_Yes : CertificateManagerNLS.ImportKeyStoreDialog_Verified_Pass_Wrong;
            }
        });
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportEntriesDialog.this.loadEntries();
            }
        });
        this.keyStoreCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ImportEntriesDialog.this.sourceKeyStore = (IKeyStore)ImportEntriesDialog.this.keyStoreCombo.getData(ImportEntriesDialog.this.keyStoreCombo.getText());
                IKeyStore keyStore = (IKeyStore)ImportEntriesDialog.this.keyStoreCombo.getData(ImportEntriesDialog.this.keyStoreCombo.getText());
                try {
                    ImportEntriesDialog.this.sourcePassword = keyStore.getPasswordProvider().getKeyStorePassword(false);
                }
                catch (KeyStoreManagerException e1) {
                    AndmoreLogger.error((String)("Error while accessing keystore manager. " + e1.getMessage()));
                }
                if (ImportEntriesDialog.this.sourcePassword == null) {
                    ImportEntriesDialog.this.sourcePassword = "";
                }
                ImportEntriesDialog.this.passwdText.setText(ImportEntriesDialog.this.sourcePassword);
                ImportEntriesDialog.this.loadEntries();
                ImportEntriesDialog.this.updateTargetCombo();
                ImportEntriesDialog.this.validateUi();
            }
        });
        Group targetGroup = new Group(container, 0);
        targetGroup.setLayout((Layout)new GridLayout(2, false));
        targetGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        targetGroup.setText(CertificateManagerNLS.ImportKeyStoreDialog_Target_Group);
        Label targetKsLabel = new Label((Composite)targetGroup, 0);
        targetKsLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        targetKsLabel.setText(CertificateManagerNLS.ImportKeyStoreDialog_KeyStore_Label);
        this.targetKsCombo = new Combo((Composite)targetGroup, 8);
        this.targetKsCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.targetKsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String selectedItem = ImportEntriesDialog.this.targetKsCombo.getText();
                ImportEntriesDialog.this.targetKeyStore = (IKeyStore)ImportEntriesDialog.this.targetKsCombo.getData(selectedItem);
                ImportEntriesDialog.this.validateUi();
            }
        });
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
        try {
            List<IKeyStore> keyStores = keyStoreManager.getKeyStores();
            for (IKeyStore keyStore : keyStores) {
                File ksFile = keyStore.getFile();
                String comboItem = String.valueOf(ksFile.getName()) + " - " + ksFile.getAbsolutePath();
                this.keyStoreCombo.add(comboItem);
                this.keyStoreCombo.setData(comboItem, (Object)keyStore);
                if (keyStore.equals(this.sourceKeyStore)) {
                    this.keyStoreCombo.select(this.keyStoreCombo.indexOf(comboItem));
                    continue;
                }
                this.targetKsCombo.add(comboItem);
                this.targetKsCombo.setData(comboItem, (Object)keyStore);
                if (!keyStore.equals(this.targetKeyStore)) continue;
                this.targetKsCombo.select(this.targetKsCombo.indexOf(comboItem));
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            this.setErrorMessage(CertificateManagerNLS.ImportKeyStoreDialog_Error_Loading_Keystores);
        }
        return area;
    }

    protected Control createHelpControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), HELP_ID);
        return super.createHelpControl(parent);
    }

    private void updateTargetCombo() {
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
        try {
            this.targetKsCombo.clearSelection();
            this.targetKsCombo.setItems(new String[0]);
            List<IKeyStore> keyStores = keyStoreManager.getKeyStores();
            for (IKeyStore keyStore : keyStores) {
                if (keyStore == this.sourceKeyStore) continue;
                File ksFile = keyStore.getFile();
                String comboItem = String.valueOf(ksFile.getName()) + " - " + ksFile.getAbsolutePath();
                this.targetKsCombo.add(comboItem);
                this.targetKsCombo.setData(comboItem, (Object)keyStore);
                if (!keyStore.equals(this.targetKeyStore)) continue;
                this.targetKsCombo.select(this.targetKsCombo.indexOf(comboItem));
            }
            if (this.targetKsCombo.getSelectionIndex() == -1) {
                this.targetKeyStore = null;
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            this.setErrorMessage(CertificateManagerNLS.ImportKeyStoreDialog_Error_Loading_Keystores);
        }
    }

    private void loadEntries() {
        try {
            this.aliasMap.clear();
            if (!this.sourcePassword.isEmpty()) {
                List<String> aliases = this.sourceKeyStore.getAliases(this.sourcePassword);
                this.entriesTableViewer.setInput(aliases);
            } else {
                this.entriesTableViewer.setInput(new ArrayList());
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            this.setErrorMessage(CertificateManagerNLS.ImportKeyStoreDialog_Error_Loading_Entries);
            this.entriesTableViewer.setInput(new ArrayList());
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.setErrorMessage(CertificateManagerNLS.ImportKeyStoreDialog_Invalid_Keystore_Passwd);
            this.entriesTableViewer.setInput(new ArrayList());
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    public void validateUi() {
        boolean isValid = true;
        this.setErrorMessage(null);
        if (isValid && this.sourceKeyStore == null) {
            isValid = false;
            this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_Select_Source_Ks);
        }
        if (isValid && (this.sourcePassword == null || this.sourcePassword.isEmpty())) {
            isValid = false;
            this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_Type_SourceKs_Passwd);
        }
        if (isValid) {
            try {
                if (!this.sourceKeyStore.isPasswordValid(this.sourcePassword)) {
                    isValid = false;
                    this.setErrorMessage("Wrong source keystore password.");
                }
            }
            catch (KeyStoreManagerException e) {
                isValid = false;
                this.setErrorMessage("Unable to access source keystore.\n" + e.getMessage());
            }
            catch (InvalidPasswordException invalidPasswordException) {
                isValid = false;
                this.setErrorMessage("Wrong source keystore password.");
            }
        }
        if (isValid) {
            List input = (List)this.entriesTableViewer.getInput();
            if (input != null) {
                int itemCount = input.size();
                if (itemCount == 0) {
                    isValid = false;
                    this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_No_Entries_To_Import, 2);
                }
                if (this.entriesTableViewer.getCheckedElements().length == 0) {
                    isValid = false;
                    this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_No_Entries_To_Import, 2);
                } else {
                    int i = 0;
                    while (i < itemCount) {
                        EntryModel entryModel = (EntryModel)this.entriesTableViewer.getElementAt(i);
                        if (this.entriesTableViewer.getChecked((Object)entryModel) && !entryModel.isVerified()) {
                            isValid = false;
                            this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_Wrong_Entries_Passwd, 2);
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                isValid = false;
                this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_No_Entries_To_Import, 2);
            }
        }
        if (isValid && this.targetKeyStore == null) {
            isValid = false;
            this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_Select_Target_Kesytore);
        }
        if (!isValid) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(CertificateManagerNLS.ImportKeyStoreDialog_Default_Message);
        }
    }

    public IKeyStore getKeyStore() {
        return this.sourceKeyStore;
    }

    public Map<String, String> getAliases() {
        HashMap<String, String> selectedAliasMap = new HashMap<String, String>(this.selectedAlias.size());
        for (String alias : this.selectedAlias) {
            selectedAliasMap.put(alias, this.aliasMap.get(alias));
        }
        return selectedAliasMap;
    }

    public IKeyStore getTargetKeyStore() {
        return this.targetKeyStore;
    }

    public String getPassword() {
        return this.sourcePassword;
    }

    public class EntriesContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ImportEntriesDialog.this.validateUi();
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<EntryModel> modelList = null;
            if (inputElement instanceof List) {
                List inputList = (List)inputElement;
                modelList = new ArrayList<EntryModel>(inputList.size());
                for (Object element : inputList) {
                    if (!(element instanceof String)) continue;
                    String alias = (String)element;
                    EntryModel entryModel = new EntryModel(alias);
                    modelList.add(entryModel);
                }
            }
            return modelList.toArray();
        }
    }

    public class EntryModel {
        private final String alias;
        private String passwd;
        private boolean verified;

        public EntryModel(String alias) {
            this.alias = alias;
            try {
                String savedPass = ImportEntriesDialog.this.sourceKeyStore.getPasswordProvider().getPassword(alias, false);
                this.setPasswd(savedPass != null ? savedPass : "");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                this.setPasswd("");
            }
        }

        public String toString() {
            return this.alias;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
            try {
                KeyStore.Entry entry = ImportEntriesDialog.this.sourceKeyStore.getKeyStore().getEntry(this.alias, new KeyStore.PasswordProtection(passwd.toCharArray()));
                this.setVerified(entry != null);
            }
            catch (Exception exception) {
                this.setVerified(false);
            }
            ImportEntriesDialog.this.aliasMap.put(this.alias, passwd);
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isVerified() {
            return this.verified;
        }

        private void setVerified(boolean verified) {
            this.verified = verified;
            ImportEntriesDialog.this.validateUi();
        }
    }

    private final class PasswordEditingSupport
    extends EditingSupport {
        private PasswordEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)ImportEntriesDialog.this.entriesTable, 0x400000);
        }

        protected Object getValue(Object element) {
            return ((EntryModel)element).getPasswd();
        }

        protected void setValue(Object element, Object value) {
            EntryModel model = (EntryModel)element;
            model.setPasswd((String)value);
            this.getViewer().update(element, null);
        }
    }
}

