/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.model;

import java.io.File;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.core.KeyStoreUtils;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.InvalidPasswordException;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.AbstractTreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.EntryDummyNode;
import org.eclipse.andmore.android.certmanager.ui.model.EntryNode;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.preferences.DialogWithToggleUtils;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class KeyStoreNode
extends AbstractTreeNode
implements IKeyStore {
    public static final String WARN_ABOUT_UNSUPPORTED_ENTRIES_PREFERENCE = "org.eclipse.andmore.android.certmanager.warnAboutUnsupportedEntries";
    private static final String DUMMY_NODE = "DUMMY_NODE";
    private final File keyStoreFile;
    private KeyStore keyStore;
    private Date lastBackupDate;
    private String type;
    private final Map<String, ITreeNode> entries = new LinkedHashMap<String, ITreeNode>();
    private final String KEYSTORE_NONSAVED_PASSWORD_ICON_PATH = "icons/keystore.png";
    private final String KEYSTORE_SAVED_PASSWORD_ICON_PATH = "icons/keystore_saved_password.png";
    private static final String WRONG_KEYSTORE_TYPE_ICON_PATH = "icons/keystore_incorrect_type.png";
    private final PasswordProvider passwordProvider;
    private boolean ignoreRefresh;
    private boolean quiet;
    private boolean skipNextReload = false;
    private boolean typeVerified;

    public KeyStoreNode(File path) {
        this.keyStoreFile = path;
        this.passwordProvider = new PasswordProvider(this.keyStoreFile);
        this.updateStatus();
    }

    public KeyStoreNode(File path, String type) {
        this.keyStoreFile = path;
        this.type = type;
        this.passwordProvider = new PasswordProvider(this.keyStoreFile);
        this.updateStatus();
    }

    public KeyStoreNode(File keyStoreFile, KeyStore keyStore) {
        this(keyStoreFile);
        this.keyStore = keyStore;
        this.type = keyStore.getType();
    }

    @Override
    public PasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    @Override
    public String getKeyStorePassword(boolean promptPassword) {
        String password = null;
        boolean keepTrying = true;
        while (keepTrying) {
            try {
                try {
                    keepTrying = false;
                    password = this.getPasswordProvider().getKeyStorePassword(promptPassword);
                    if (password == null) continue;
                    this.isPasswordValid(password);
                }
                catch (InvalidPasswordException invalidPasswordException) {
                    this.getPasswordProvider().deleteKeyStoreSavedPasswordNode();
                    password = null;
                    keepTrying = true;
                }
            }
            catch (KeyStoreManagerException e) {
                password = null;
                keepTrying = false;
                AndmoreLogger.info(this.getClass(), (String)(String.valueOf(CertificateManagerNLS.KeyStoreNode_CouldNotGetKeyStorePassword) + e.getLocalizedMessage()));
            }
        }
        return password;
    }

    @Override
    public File getFile() {
        return this.keyStoreFile;
    }

    @Override
    public KeyStore getKeyStore() throws KeyStoreManagerException {
        return this.getKeyStore(true);
    }

    public KeyStore getKeyStore(boolean load) throws KeyStoreManagerException {
        if (this.keyStore == null) {
            boolean tryAgain = false;
            boolean useSavedPass = true;
            String password = null;
            do {
                if (tryAgain) {
                    useSavedPass = false;
                }
                password = this.passwordProvider.getKeyStorePassword(true, useSavedPass);
                tryAgain = false;
                if (password != null) {
                    try {
                        this.keyStore = this.loadKeystore(password.toCharArray());
                        this.setTooltip(null);
                        if (!load) continue;
                        this.loadEntries();
                    }
                    catch (InvalidPasswordException invalidPasswordException) {
                        tryAgain = true;
                    }
                    continue;
                }
                this.setTooltip(CertificateManagerNLS.KeyStoreNode_CouldNotLoadKeystore_Tooltip);
            } while (tryAgain);
        }
        return this.keyStore;
    }

    public KeyStore getKeyStore(String password) throws KeyStoreManagerException, InvalidPasswordException {
        if (this.keyStore == null && password != null) {
            this.keyStore = this.loadKeystore(password.toCharArray());
            this.loadEntries();
        } else {
            this.isPasswordValid(password);
        }
        return this.keyStore;
    }

    @Override
    public boolean isPasswordValid(String password) throws KeyStoreManagerException, InvalidPasswordException {
        KeyStore myKeyStore = null;
        if (password == null) {
            throw new InvalidPasswordException(CertificateManagerNLS.KeyStoreNode_Password_NotNull);
        }
        myKeyStore = this.loadKeystore(password.toCharArray());
        return myKeyStore != null;
    }

    protected KeyStore loadKeystore(char[] password) throws KeyStoreManagerException, InvalidPasswordException {
        KeyStore keyStore = null;
        this.setNodeStatus(Status.OK_STATUS);
        this.setTooltip(null);
        try {
            if (!this.typeVerified && this.type.equalsIgnoreCase("jceks") && (keyStore = KeyStoreUtils.loadKeystore(this.keyStoreFile, password, "JKS")) != null) {
                EclipseUtils.showWarningDialog((String)CertificateManagerNLS.KeyStoreNode_Wrong_KeystoreType_Title, (String)NLS.bind((String)CertificateManagerNLS.KeyStoreNode_Wrong_KeystoreType_Message, (Object)this.getName()));
                this.setType("JKS");
                this.typeVerified = true;
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.setNodeStatus((IStatus)new Status(4, "org.eclipse.andmore.android.certmanager", CertificateManagerNLS.KeyStoreNode_InvalidPassword));
            throw invalidPasswordException;
        }
        try {
            keyStore = KeyStoreUtils.loadKeystore(this.keyStoreFile, password, this.type);
            this.setNodeStatus(Status.OK_STATUS);
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            this.setNodeStatus((IStatus)new Status(4, "org.eclipse.andmore.android.certmanager", 1, CertificateManagerNLS.KeyStoreNode_KeystoreTypeWrong_NodeStatus, null));
            throw keyStoreManagerException;
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.setNodeStatus((IStatus)new Status(4, "org.eclipse.andmore.android.certmanager", CertificateManagerNLS.KeyStoreNode_InvalidPassword));
            throw invalidPasswordException;
        }
        return keyStore;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.keyStoreFile == null ? 0 : this.keyStoreFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyStoreNode)) {
            return false;
        }
        KeyStoreNode other = (KeyStoreNode)obj;
        return !(this.keyStoreFile == null ? other.keyStoreFile != null : !this.keyStoreFile.equals(other.keyStoreFile));
    }

    public String toString() {
        return String.valueOf(this.getName()) + " - ( " + this.getId() + " )";
    }

    @Override
    public void refresh() throws KeyStoreManagerException {
        if (!this.ignoreRefresh) {
            if (!this.skipNextReload) {
                this.keyStore = null;
                this.skipNextReload = false;
            }
            this.entries.clear();
            this.updateStatus();
            if (this.getNodeStatus().isOK()) {
                this.quiet = true;
                this.loadEntries();
                this.quiet = false;
                this.passwordProvider.cleanModel(new ArrayList<String>(this.entries.keySet()));
            }
        } else {
            this.setIgnoreRefresh(false);
        }
    }

    private void setIgnoreRefresh(boolean ignoreRefresh) {
        this.ignoreRefresh = ignoreRefresh;
    }

    @Override
    public String getId() {
        return this.keyStoreFile.getAbsolutePath();
    }

    @Override
    public String getName() {
        return this.keyStoreFile.getName();
    }

    @Override
    public ImageDescriptor getIcon() {
        ImageDescriptor descr = null;
        descr = !this.isStoreTypeCorrect() ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)WRONG_KEYSTORE_TYPE_ICON_PATH) : (this.isPasswordSaved() ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)"icons/keystore_saved_password.png") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)"icons/keystore.png"));
        return descr;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<ITreeNode> getChildren() throws KeyStoreManagerException {
        ArrayList<ITreeNode> children = new ArrayList<ITreeNode>(this.entries.values());
        return children;
    }

    private void loadEntries() throws KeyStoreManagerException {
        ITreeNode entryNode;
        if (this.entries.size() == 1 && (entryNode = this.entries.get(DUMMY_NODE)) != null) {
            this.entries.remove(DUMMY_NODE);
            KeyStoreModelEventManager.getInstance().fireEvent(entryNode, KeyStoreModelEvent.EventType.REMOVE);
        }
        this.entries.clear();
        KeyStore keyStore = this.getKeyStore(false);
        if (keyStore != null) {
            Enumeration<String> aliases;
            try {
                aliases = keyStore.aliases();
            }
            catch (KeyStoreException e) {
                throw new KeyStoreManagerException(NLS.bind((String)CertificateManagerNLS.KeyStoreModel_Error_GettingAliasesFromKeystore, (Object)this.getName()), e);
            }
            ArrayList<String> keyPairEntries = new ArrayList<String>();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                EntryNode keyStoreEntry = new EntryNode(this, alias);
                if (!keyStoreEntry.isKeyPairEntry()) {
                    this.entries.put(alias, keyStoreEntry);
                    continue;
                }
                keyPairEntries.add(alias);
                String msg = NLS.bind((String)CertificateManagerNLS.KeyStoreNode_KeyPairNotMapped_LogMessage, (Object)alias);
                AndmoreLogger.debug((String)msg);
            }
            if (keyPairEntries != null && !keyPairEntries.isEmpty()) {
                DialogWithToggleUtils.showInformation((String)WARN_ABOUT_UNSUPPORTED_ENTRIES_PREFERENCE, (String)CertificateManagerNLS.KeyStoreNode_KeyPairNotMapped_Title, (String)CertificateManagerNLS.KeyStoreNode_KeyPairNotMapped_Message);
            }
            if (this.entries.isEmpty()) {
                this.entries.put(DUMMY_NODE, new EntryDummyNode(this));
            }
        } else {
            this.setNodeStatus((IStatus)new Status(4, "org.eclipse.andmore.android.certmanager", CertificateManagerNLS.KeyStoreNode_UseRefresh_StatusNode));
        }
    }

    private void updateStatus() {
        this.setNodeStatus(Status.OK_STATUS);
        if (!this.keyStoreFile.exists()) {
            this.setNodeStatus((IStatus)new Status(4, "org.eclipse.andmore.android.certmanager", CertificateManagerNLS.KeyStoreNode_KeystoreFileNotFound));
        }
    }

    @Override
    public void addChild(ITreeNode newChild) {
        ITreeNode entryNode;
        if (this.entries.size() == 1 && (entryNode = this.entries.get(DUMMY_NODE)) != null) {
            this.entries.remove(DUMMY_NODE);
            KeyStoreModelEventManager.getInstance().fireEvent(entryNode, KeyStoreModelEvent.EventType.REMOVE);
        }
        if (newChild instanceof IKeyStoreEntry || newChild instanceof EntryDummyNode) {
            entryNode = (EntryNode)newChild;
            String alias = ((EntryNode)entryNode).getAlias();
            this.entries.put(alias, entryNode);
            if (!this.quiet && !(newChild instanceof EntryDummyNode)) {
                KeyStoreModelEventManager.getInstance().fireEvent(newChild, KeyStoreModelEvent.EventType.ADD);
            }
        }
    }

    @Override
    public Date getLastBackupDate() {
        return this.lastBackupDate;
    }

    @Override
    public void setLastBackupDate(Date lastBackupDate) {
        this.lastBackupDate = lastBackupDate;
        try {
            KeyStoreManager.getInstance().setBackupDate(this, lastBackupDate);
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            AndmoreLogger.error((String)"Could not set backup date for keystore");
        }
        KeyStoreModelEventManager.getInstance().fireEvent(this, KeyStoreModelEvent.EventType.UPDATE);
    }

    @Override
    public String getType() {
        return this.type != null ? this.type : KeyStore.getDefaultType().toUpperCase();
    }

    @Override
    public void setType(String type) throws KeyStoreManagerException {
        this.type = type;
        KeyStoreManager.getInstance().updateKeyStoreType(this);
    }

    @Override
    public List<IKeyStoreEntry> getEntries(String password) throws KeyStoreManagerException, InvalidPasswordException {
        this.getKeyStore(password);
        ArrayList<IKeyStoreEntry> children = new ArrayList<IKeyStoreEntry>(this.entries.size());
        for (ITreeNode treeNode : this.entries.values()) {
            if (!(treeNode instanceof IKeyStoreEntry)) continue;
            children.add((IKeyStoreEntry)((Object)treeNode));
        }
        return children;
    }

    @Override
    public IKeyStoreEntry getEntry(String alias, String keystorePassword) throws KeyStoreManagerException, InvalidPasswordException {
        IKeyStoreEntry result = null;
        for (IKeyStoreEntry entry : this.getEntries(keystorePassword)) {
            if (!entry.getAlias().equalsIgnoreCase(alias)) continue;
            result = entry;
        }
        return result;
    }

    @Override
    public List<String> getAliases(String password) throws KeyStoreManagerException, InvalidPasswordException {
        this.getKeyStore(password);
        ArrayList<String> children = new ArrayList<String>(this.entries.size());
        for (ITreeNode treeNode : this.entries.values()) {
            if (!(treeNode instanceof IKeyStoreEntry)) continue;
            children.add(((IKeyStoreEntry)((Object)treeNode)).getAlias());
        }
        return children;
    }

    @Override
    public void removeKey(String alias) throws KeyStoreManagerException {
        String password = this.passwordProvider.getKeyStorePassword(true, true);
        if (password != null) {
            KeyStoreUtils.deleteEntry(this.keyStore, password.toCharArray(), this.keyStoreFile, alias);
            try {
                this.forceReload(password.toCharArray(), false);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                AndmoreLogger.debug((String)"Could reload ks after removing entry, invalid password");
            }
            ITreeNode entryNode = this.entries.remove(alias);
            KeyStoreModelEventManager.getInstance().fireEvent(entryNode, KeyStoreModelEvent.EventType.REMOVE);
            if (this.entries.isEmpty()) {
                EntryDummyNode entryDummyNode = new EntryDummyNode(this);
                this.entries.put(DUMMY_NODE, entryDummyNode);
                KeyStoreModelEventManager.getInstance().fireEvent(entryDummyNode, KeyStoreModelEvent.EventType.ADD);
            }
        } else {
            throw new KeyStoreManagerException(String.valueOf(CertificateManagerNLS.KeyStoreNode_NotFoundOrIncorrectPasswordToDeleteEntry) + alias);
        }
    }

    @Override
    public void removeKeys(List<String> aliases) throws KeyStoreManagerException {
        String password = this.passwordProvider.getKeyStorePassword(true, true);
        if (password != null) {
            for (String alias : aliases) {
                KeyStoreUtils.deleteEntry(this.keyStore, password.toCharArray(), this.keyStoreFile, alias);
                ITreeNode entryNode = this.entries.remove(alias);
                KeyStoreModelEventManager.getInstance().fireEvent(entryNode, KeyStoreModelEvent.EventType.REMOVE);
            }
            try {
                this.forceReload(password.toCharArray(), false);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                AndmoreLogger.debug((String)"Could reload ks after removing entry, invalid password");
            }
            if (this.entries.isEmpty()) {
                EntryDummyNode entryDummyNode = new EntryDummyNode(this);
                this.entries.put(DUMMY_NODE, entryDummyNode);
                KeyStoreModelEventManager.getInstance().fireEvent(entryDummyNode, KeyStoreModelEvent.EventType.ADD);
            }
        } else {
            throw new KeyStoreManagerException(CertificateManagerNLS.KeyStoreNode_IncorrectPasswordToDeleteEntries_Error);
        }
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        boolean result = super.testAttribute(target, name, value);
        if (name.equals("org.eclipse.andmore.android.certmanager.core.property.nodeStatus")) {
            if (value.equals("org.eclipse.andmore.android.certmanager.core.property.nodeStatusError")) {
                if (!this.isStoreTypeCorrect()) {
                    result = false;
                } else if (!this.keyStoreFile.exists()) {
                    result = true;
                    this.setTooltip(CertificateManagerNLS.KeyStoreNode_ErrorKeystoreNotFound);
                }
            } else if (value.equals("org.eclipse.andmore.android.certmanager.core.property.keystoreTypeOk")) {
                result = this.isStoreTypeCorrect();
            }
        }
        return result;
    }

    @Override
    public void forceReload(char[] password, boolean updateUi) throws KeyStoreManagerException, InvalidPasswordException {
        this.keyStore = this.loadKeystore(password);
        if (updateUi) {
            this.skipNextReload = true;
            KeyStoreModelEventManager.getInstance().fireEvent(this, KeyStoreModelEvent.EventType.REFRESH);
        }
    }

    @Override
    protected boolean isPasswordSaved() {
        PasswordProvider pp = new PasswordProvider(this.getFile());
        return pp.isPasswordSaved();
    }

    protected boolean isStoreTypeCorrect() {
        return this.getNodeStatus().getCode() != 1;
    }
}

