/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.job.CreateKeyJob;
import org.eclipse.andmore.android.certmanager.ui.composite.NewKeyBlock;
import org.eclipse.andmore.android.certmanager.ui.model.CertificateDetailsInfo;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.wizards.CreateKeystoreWizard;
import org.eclipse.andmore.android.wizards.BaseWizardPage;
import org.eclipse.andmore.android.wizards.elements.IBaseBlock;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.wizard.IWizard;

public class CreateKeyWizardPage
extends BaseWizardPage {
    private IKeyStore keystore = null;
    private String alias = null;
    private String keyStorePass;
    public static final String CREATE_SELF_SIGNED_CERTIFICATE_HELP_ID = "org.eclipse.andmore.android.certmanager.create-self-cert";
    private IJobChangeListener createKeyJobListener = null;

    public CreateKeyWizardPage(IKeyStore keystore) {
        super((IBaseBlock)new NewKeyBlock(), CertificateManagerNLS.CreateSelfSignedCertificateWizardPage_Title, CertificateManagerNLS.CreateSelfSignedCertificateWizardPage_Description, CREATE_SELF_SIGNED_CERTIFICATE_HELP_ID);
        ((NewKeyBlock)this.block).setBaseWizardPage(this);
        this.keystore = keystore;
    }

    public CreateKeyWizardPage(IKeyStore keystore, String keystorePassword, IJobChangeListener createKeyJobListener) {
        this(keystore);
        this.setKeyStorePass(keystorePassword);
        this.createKeyJobListener = createKeyJobListener;
    }

    public String getAlias() {
        return ((NewKeyBlock)this.block).getAlias();
    }

    public String getCommonName() {
        return ((NewKeyBlock)this.block).getCommonName();
    }

    public String getOrganization() {
        return ((NewKeyBlock)this.block).getOrganization();
    }

    public String getOrganizationUnit() {
        return ((NewKeyBlock)this.block).getOrganizationUnit();
    }

    public String getLocality() {
        return ((NewKeyBlock)this.block).getLocality();
    }

    public String getState() {
        return ((NewKeyBlock)this.block).getState();
    }

    public String getCountry() {
        return ((NewKeyBlock)this.block).getCountry();
    }

    public String getValidity() {
        return ((NewKeyBlock)this.block).getValidity();
    }

    public String getEntryPassword() {
        return ((NewKeyBlock)this.block).getKeyPassword();
    }

    public String getEntryConfirmPassword() {
        return ((NewKeyBlock)this.block).getKeyConfirmPassword();
    }

    public boolean needToSaveKeyEntryPassword() {
        return ((NewKeyBlock)this.block).needToSaveKeyPassword();
    }

    public boolean createKey() {
        boolean successfullyCreated = true;
        this.alias = this.getAlias();
        if (this.isPageCompleteWithAllFieldsBlank()) {
            successfullyCreated = true;
        } else {
            CertificateDetailsInfo certificateDetailsInfo = new CertificateDetailsInfo(this.alias, this.getCommonName(), this.getOrganization(), this.getOrganizationUnit(), this.getLocality(), this.getCountry(), this.getState(), this.getValidity(), this.getEntryPassword());
            CreateKeyJob createKeyJob = new CreateKeyJob("Create key job", (NewKeyBlock)this.block, certificateDetailsInfo, this.keystore, this.keyStorePass);
            if (this.createKeyJobListener != null) {
                createKeyJob.addJobChangeListener(this.createKeyJobListener);
            }
            createKeyJob.schedule();
            successfullyCreated = true;
        }
        return successfullyCreated;
    }

    public void setKeyStore(IKeyStore keystoreNode) {
        this.keystore = keystoreNode;
    }

    public boolean isPageCompleteWithAllFieldsBlank() {
        boolean result = false;
        IWizard wizardContext = this.getWizard();
        if (wizardContext instanceof CreateKeystoreWizard && !this.isCurrentPage() && this.areAllFieldsBlank()) {
            result = true;
        }
        return result;
    }

    private boolean areAllFieldsBlank() {
        boolean result = false;
        if (this.getAlias().isEmpty() && this.getCommonName().isEmpty() && this.getOrganization().isEmpty() && this.getOrganizationUnit().isEmpty() && this.getLocality().isEmpty() && this.getState().isEmpty() && this.getCountry().isEmpty() && this.getEntryPassword().isEmpty() && this.getEntryConfirmPassword().isEmpty()) {
            result = true;
        }
        return result;
    }

    public boolean isPageComplete() {
        if (this.block == null) {
            return true;
        }
        return this.block.isPageComplete() || this.isPageCompleteWithAllFieldsBlank();
    }

    public String getTrueAlias() {
        return this.alias;
    }

    public void setKeyStorePass(String password) {
        this.keyStorePass = password;
    }

    public IKeyStore getKeystore() {
        return this.keystore;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ((NewKeyBlock)this.block).setFocus();
        }
    }
}

