/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.core.PasswordProvider;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.model.SigningAndKeysModelManager;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateKeystorePage
extends WizardPage {
    private static final String CREATE_KEYSTORE_HELP_ID = "org.eclipse.andmore.android.certmanager.new_keystore";
    private Text keystoreFilenameText;
    private ComboViewer keystoreTypeComboViewer;
    private Text keystorePasswordText;
    private Text keystoreConfirmPasswordText;
    private String keystorePassword;
    private boolean initialValidation = true;
    private boolean userChangedPasswordConfirmation = false;
    private boolean userChangedPassword = false;
    SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            CreateKeystorePage.this.validatePage();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private Button savePassword;
    private Button useTypeAsExtensionCheckBox;
    protected boolean useTypeAsExtensionCheckBoxPreviousState = true;

    protected CreateKeystorePage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 4);
        mainComposite.setLayout((Layout)new GridLayout(3, false));
        mainComposite.setLayoutData((Object)new GridData(1808));
        this.setTitle(CertificateManagerNLS.CreateKeystorePage_CreateKeystore);
        this.setMessage(CertificateManagerNLS.CreateKeystorePage_WizardDefaultMessage);
        this.createFilenameSection(mainComposite);
        this.createKeystoreTypeSection(mainComposite);
        this.createFilenameExtensionSection(mainComposite);
        this.setKeystoreFilenameExtension();
        Label separator1 = new Label(mainComposite, 258);
        separator1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.createKeystorePasswordSection(mainComposite);
        this.createConfirmPasswordSection(mainComposite);
        this.createSavePasswordSection(mainComposite);
        this.validatePage();
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CREATE_KEYSTORE_HELP_ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, CREATE_KEYSTORE_HELP_ID);
    }

    private void createKeystoreTypeSection(Composite parent) {
        Label keystoreTypeLabel = new Label(parent, 0);
        keystoreTypeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        keystoreTypeLabel.setText(CertificateManagerNLS.CreateKeystorePage_KeystoreType);
        this.keystoreTypeComboViewer = new ComboViewer(parent, 8);
        this.keystoreTypeComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.keystoreTypeComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
        this.keystoreTypeComboViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                return (String)element;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.keystoreTypeComboViewer.setInput(KeyStoreManager.getInstance().getAvailableTypes());
        this.keystoreTypeComboViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateKeystorePage.this.useTypeAsExtensionCheckBox.setEnabled(true);
                CreateKeystorePage.this.useTypeAsExtensionCheckBox.setSelection(CreateKeystorePage.this.useTypeAsExtensionCheckBoxPreviousState);
                if (CreateKeystorePage.this.useTypeAsExtensionCheckBox.getSelection()) {
                    CreateKeystorePage.this.setKeystoreFilenameExtension();
                }
            }
        });
        int i = 0;
        while (i < this.keystoreTypeComboViewer.getCombo().getItemCount()) {
            if (this.keystoreTypeComboViewer.getCombo().getItem(i).compareToIgnoreCase(KeyStoreManager.getInstance().getDefaultType()) == 0) {
                this.keystoreTypeComboViewer.getCombo().select(i);
            }
            ++i;
        }
        this.keystoreTypeComboViewer.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CreateKeystorePage.this.useTypeAsExtensionCheckBox != null) {
                    CreateKeystorePage.this.useTypeAsExtensionCheckBox.setEnabled(false);
                    CreateKeystorePage.this.useTypeAsExtensionCheckBox.setSelection(false);
                }
            }
        });
        Label separator2 = new Label(parent, 0);
        separator2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
    }

    protected void setKeystoreFilenameExtension() {
        String keystoreFilename = this.keystoreFilenameText.getText();
        String keystoreType = this.keystoreTypeComboViewer.getCombo().getText();
        List<String> availableTypes = KeyStoreManager.getInstance().getAvailableTypes();
        availableTypes.add(CertificateManagerNLS.CreateKeystorePage_DefaultKeystoreFilenameExtension);
        for (String availableType : availableTypes) {
            String availableTypeExtension = "." + availableType.toLowerCase();
            if (!keystoreFilename.endsWith(availableTypeExtension)) continue;
            keystoreFilename = keystoreFilename.substring(0, keystoreFilename.length() - availableTypeExtension.length());
            break;
        }
        this.keystoreFilenameText.setText(String.valueOf(keystoreFilename) + "." + keystoreType.toLowerCase());
    }

    private void createFilenameExtensionSection(Composite mainComposite) {
        this.useTypeAsExtensionCheckBox = new Button(mainComposite, 32);
        this.useTypeAsExtensionCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.useTypeAsExtensionCheckBox.setText(CertificateManagerNLS.CreateKeystorePage_UseKeystoreTypeAsExtension);
        this.useTypeAsExtensionCheckBox.setSelection(true);
        this.useTypeAsExtensionCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateKeystorePage.this.useTypeAsExtensionCheckBoxPreviousState = CreateKeystorePage.this.useTypeAsExtensionCheckBox.getSelection();
                if (CreateKeystorePage.this.useTypeAsExtensionCheckBox.getSelection()) {
                    CreateKeystorePage.this.setKeystoreFilenameExtension();
                }
            }
        });
    }

    private void createSavePasswordSection(Composite mainComposite) {
        this.savePassword = new Button(mainComposite, 32);
        this.savePassword.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.savePassword.setText(CertificateManagerNLS.CreateKeystorePage_SaveThisPassword);
        this.savePassword.setSelection(false);
    }

    private void createConfirmPasswordSection(Composite mainComposite) {
        Label keystoreConfirmPasswordLabel = new Label(mainComposite, 0);
        keystoreConfirmPasswordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        keystoreConfirmPasswordLabel.setText(CertificateManagerNLS.CreateKeystorePage_KeystoreConfirmPasswordLabel);
        this.keystoreConfirmPasswordText = new Text(mainComposite, 0x400804);
        this.keystoreConfirmPasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keystoreConfirmPasswordText.addSelectionListener(this.selectionListener);
        this.keystoreConfirmPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateKeystorePage.this.userChangedPasswordConfirmation = true;
                CreateKeystorePage.this.validatePage();
            }
        });
        Label separator2 = new Label(mainComposite, 0);
        separator2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
    }

    private void createKeystorePasswordSection(Composite mainComposite) {
        Label keystorePasswordLabel = new Label(mainComposite, 0);
        keystorePasswordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        keystorePasswordLabel.setText(CertificateManagerNLS.CreateKeystorePage_KeystorePasswordLabel);
        this.keystorePasswordText = new Text(mainComposite, 0x400804);
        this.keystorePasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keystorePasswordText.addSelectionListener(this.selectionListener);
        this.keystorePasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateKeystorePage.this.keystorePassword = CreateKeystorePage.this.keystorePasswordText.getText();
                CreateKeystorePage.this.userChangedPassword = true;
                CreateKeystorePage.this.validatePage();
            }
        });
        new Label(mainComposite, 0);
        keystorePasswordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
    }

    private void createFilenameSection(Composite mainComposite) {
        Label keystoreFilenameLabel = new Label(mainComposite, 0);
        keystoreFilenameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        keystoreFilenameLabel.setText(CertificateManagerNLS.CreateKeystorePage_KeystoreFilenameLabel);
        this.keystoreFilenameText = new Text(mainComposite, 2052);
        this.keystoreFilenameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keystoreFilenameText.setText(this.generateKeyStoreFilename());
        this.keystoreFilenameText.addSelectionListener(this.selectionListener);
        this.keystoreFilenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateKeystorePage.this.validatePage();
            }
        });
        Button chooseLocation = new Button(mainComposite, 8);
        chooseLocation.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        chooseLocation.setText(CertificateManagerNLS.CreateKeystorePage_KeystoreFilenameBrowse);
        chooseLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                FileDialog dialog = new FileDialog(shell, 8192);
                String keystoreFilenameStr = dialog.open();
                if (keystoreFilenameStr != null) {
                    CreateKeystorePage.this.keystoreFilenameText.setText(keystoreFilenameStr);
                }
            }
        });
    }

    private void validatePage() {
        boolean pageComplete = true;
        String errorMessage = null;
        String message = CertificateManagerNLS.CreateKeystorePage_WizardDefaultMessage;
        int messageType = 0;
        if (this.initialValidation) {
            pageComplete = false;
            this.initialValidation = false;
        } else {
            if (!this.keystorePasswordText.getText().equals(this.keystoreConfirmPasswordText.getText())) {
                if (this.userChangedPasswordConfirmation) {
                    errorMessage = CertificateManagerNLS.CreateKeystorePage_PasswordDoesNotMatch;
                    pageComplete = false;
                } else {
                    message = CertificateManagerNLS.CreateKeystorePage_ConfirmPasswordInfoMsg;
                    messageType = 1;
                    pageComplete = false;
                }
            }
            if (this.keystorePasswordText.getText().length() < 6) {
                if (this.userChangedPassword) {
                    errorMessage = NLS.bind((String)CertificateManagerNLS.CreateKeystorePage_PasswordMinSizeMessage, (Object)6);
                    pageComplete = false;
                } else {
                    message = CertificateManagerNLS.CreateKeystorePage_SetPasswordInfoMsg;
                    messageType = 1;
                    pageComplete = false;
                }
            }
            if (this.keystoreTypeComboViewer.getCombo().getText().isEmpty()) {
                errorMessage = CertificateManagerNLS.CreateKeystorePage_SetKeystoreType;
                pageComplete = false;
            }
            try {
                File keystoreFile = new File(this.keystoreFilenameText.getText().trim());
                Path keystorePath = new Path(this.keystoreFilenameText.getText().trim());
                if (!keystorePath.isValidPath(keystoreFile.getCanonicalPath())) {
                    throw new IOException();
                }
            }
            catch (IOException iOException) {
                errorMessage = CertificateManagerNLS.CreateKeystorePage_FilenameSyntaxError;
                pageComplete = false;
            }
            if (this.keystoreFilenameText.getText().trim().isEmpty()) {
                errorMessage = CertificateManagerNLS.ImportKeystorePage_FilenameCannotBeEmpty;
                pageComplete = false;
            }
        }
        this.setMessage(message, messageType);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(pageComplete);
    }

    private String generateKeyStoreFilename() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss_SSS");
        String timestamp = dateFormat.format(Calendar.getInstance().getTime());
        String keystoreFilenameStr = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + NLS.bind((String)CertificateManagerNLS.CreateKeystorePage_DefaultKeystoreFilename, (Object)timestamp);
        File keystoreFile = new File(keystoreFilenameStr);
        while (keystoreFile.exists()) {
            timestamp = dateFormat.format(Calendar.getInstance().getTime());
            keystoreFilenameStr = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + NLS.bind((String)CertificateManagerNLS.CreateKeystorePage_DefaultKeystoreFilename, (Object)timestamp);
            keystoreFile = new File(keystoreFilenameStr);
        }
        return keystoreFilenameStr;
    }

    public KeyStoreNode createKeyStore() {
        boolean successfullyCreated = true;
        File keystoreFile = null;
        KeyStoreNode keystoreNode = null;
        try {
            keystoreFile = new File(this.keystoreFilenameText.getText().trim());
            if (this.validateKeyStoreFile(keystoreFile)) {
                keystoreNode = (KeyStoreNode)KeyStoreManager.createKeyStore(keystoreFile, this.keystoreTypeComboViewer.getCombo().getText(), this.keystorePasswordText.getText().toCharArray());
                SigningAndKeysModelManager.getInstance().mapKeyStore(keystoreNode);
            } else {
                successfullyCreated = false;
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            if (keystoreFile != null) {
                keystoreFile.delete();
            }
            EclipseUtils.showErrorDialog((String)CertificateManagerNLS.CreateKeystorePage_ErrorCreatingKeystore, (String)NLS.bind((String)CertificateManagerNLS.CreateKeystorePage_ErrorOnKeyStoreFileCreation, (Object)this.keystoreFilenameText.getText()));
            successfullyCreated = false;
        }
        if (successfullyCreated && this.savePassword.getSelection()) {
            this.savePassword(keystoreFile);
        }
        return successfullyCreated ? keystoreNode : null;
    }

    private void savePassword(File keystoreFile) {
        try {
            PasswordProvider passwordProvider = new PasswordProvider(keystoreFile);
            passwordProvider.saveKeyStorePassword(this.keystorePasswordText.getText());
        }
        catch (KeyStoreManagerException e) {
            EclipseUtils.showWarningDialog((String)CertificateManagerNLS.CreateKeystorePage_CouldNotSavePassword, (String)e.getLocalizedMessage());
        }
    }

    private boolean validateKeyStoreFile(File keystoreFile) {
        Shell shell;
        boolean result = true;
        if (keystoreFile.exists() && (result = MessageDialog.openQuestion((Shell)(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()), (String)CertificateManagerNLS.CreateKeystorePage_ConfirmFileOverwrite, (String)NLS.bind((String)CertificateManagerNLS.CreateKeystorePage_ConfirmReplaceFile, (Object)keystoreFile.getAbsolutePath())))) {
            keystoreFile.delete();
        }
        return result;
    }

    public String getPassword() {
        return this.keystorePassword;
    }
}

