/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.packaging.PackageFile;
import org.eclipse.andmore.android.certmanager.ui.wizards.RemoveExternalPackageSignaturePage;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RemoveExternalPackageSignatureWizard
extends Wizard {
    private RemoveExternalPackageSignaturePage page = null;

    public RemoveExternalPackageSignatureWizard(IStructuredSelection selection) {
        this.setWindowTitle(CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_WINDOW_TITLE);
        this.setNeedsProgressMonitor(true);
        this.page = new RemoveExternalPackageSignaturePage("removeSigPage", selection);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)"icons/wizban/unsign_package_wiz.png"));
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final ArrayList defectivePackages = new ArrayList();
        IRunnableWithProgress finishAction = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                List<String> selectedFiles = RemoveExternalPackageSignatureWizard.this.page.getSelectedPackages();
                monitor.beginTask(CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_WINDOW_TITLE, selectedFiles.size());
                for (String selected : selectedFiles) {
                    block31: {
                        File file = new File(selected);
                        monitor.setTaskName(String.valueOf(CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_OPERATION) + " " + file.getName());
                        if (file != null && file.exists() && file.isFile() && file.canWrite()) {
                            OutputStream fileToWrite = null;
                            JarFile jar = null;
                            PackageFile pack = null;
                            try {
                                jar = new JarFile(file);
                                pack = new PackageFile(jar);
                                try {
                                    pack.removeMetaEntryFiles();
                                }
                                catch (IOException e) {
                                    AndmoreLogger.error((String)RemoveExternalPackageSignatureWizard.class.toString(), (String)"Impossible to delete temporary files");
                                    throw e;
                                }
                                fileToWrite = new FileOutputStream(file);
                                pack.write(fileToWrite);
                                PackageFile.zipAlign(file);
                            }
                            catch (IOException e) {
                                defectivePackages.add(selected);
                                AndmoreLogger.error((String)RemoveExternalPackageSignatureWizard.class.toString(), (String)("Impossible write to package: " + selected + " " + e.getMessage()));
                                System.gc();
                                try {
                                    if (jar != null) {
                                        jar.close();
                                    }
                                    if (pack != null) {
                                        pack.removeTemporaryEntryFiles();
                                    }
                                    if (fileToWrite != null) {
                                        fileToWrite.close();
                                    }
                                    break block31;
                                }
                                catch (IOException iOException) {
                                    AndmoreLogger.error((String)"org.eclipse.andmore.android.certmanager", (String)"Deleting temporary files");
                                }
                                break block31;
                            }
                            catch (SecurityException e) {
                                try {
                                    defectivePackages.add(selected);
                                    AndmoreLogger.error((String)RemoveExternalPackageSignatureWizard.class.toString(), (String)("Impossible write to package: " + selected + " " + e.getMessage()));
                                }
                                catch (Throwable throwable) {
                                    System.gc();
                                    try {
                                        if (jar != null) {
                                            jar.close();
                                        }
                                        if (pack != null) {
                                            pack.removeTemporaryEntryFiles();
                                        }
                                        if (fileToWrite != null) {
                                            fileToWrite.close();
                                        }
                                    }
                                    catch (IOException iOException) {
                                        AndmoreLogger.error((String)"org.eclipse.andmore.android.certmanager", (String)"Deleting temporary files");
                                    }
                                    throw throwable;
                                }
                                System.gc();
                                try {
                                    if (jar != null) {
                                        jar.close();
                                    }
                                    if (pack != null) {
                                        pack.removeTemporaryEntryFiles();
                                    }
                                    if (fileToWrite != null) {
                                        fileToWrite.close();
                                    }
                                    break block31;
                                }
                                catch (IOException iOException) {
                                    AndmoreLogger.error((String)"org.eclipse.andmore.android.certmanager", (String)"Deleting temporary files");
                                }
                                break block31;
                            }
                            System.gc();
                            try {
                                if (jar != null) {
                                    jar.close();
                                }
                                if (pack != null) {
                                    pack.removeTemporaryEntryFiles();
                                }
                                if (fileToWrite != null) {
                                    fileToWrite.close();
                                }
                            }
                            catch (IOException iOException) {
                                AndmoreLogger.error((String)"org.eclipse.andmore.android.certmanager", (String)"Deleting temporary files");
                            }
                        } else {
                            defectivePackages.add(selected);
                        }
                    }
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new ProgressMonitorDialog(this.getShell()), finishAction, null);
        }
        catch (InvocationTargetException invocationTargetException) {
            AndmoreLogger.error((String)RemoveExternalPackageSignatureWizard.class.toString(), (String)"Error running finish actions");
        }
        catch (InterruptedException interruptedException) {
            AndmoreLogger.error((String)RemoveExternalPackageSignatureWizard.class.toString(), (String)"Error running finish actions");
        }
        if (ResourcesPlugin.getWorkspace().getRoot().getLocation().isPrefixOf(this.page.getSourcePath())) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IContainer[] iContainerArray = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(RemoveExternalPackageSignatureWizard.this.page.getSourcePath());
                    int n = iContainerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer container = iContainerArray[n2];
                        container.refreshLocal(2, monitor);
                        ++n2;
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException invocationTargetException) {
                AndmoreLogger.error((String)RemoveExternalPackageSignatureWizard.class.toString(), (String)"Error refreshing workspace");
            }
            catch (InterruptedException interruptedException) {
                AndmoreLogger.error((String)RemoveExternalPackageSignatureWizard.class.toString(), (String)"Error refreshing workspace");
            }
        }
        if (!defectivePackages.isEmpty()) {
            MultiStatus errors = new MultiStatus("org.eclipse.andmore.android.certmanager", 4, CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_ERROR_REASON, null);
            for (String defect : defectivePackages) {
                errors.add((IStatus)new Status(4, "org.eclipse.andmore.android.certmanager", defect));
            }
            ErrorDialog errorBox = new ErrorDialog(this.getShell(), CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_WINDOW_TITLE, CertificateManagerNLS.UNSIGN_EXTERNAL_PKG_WIZARD_ERROR, (IStatus)errors, 4);
            errorBox.open();
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.andmore.android.certmanager.unsign_external_pkg_wiz");
    }
}

