/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.andmore.android.model.manifest.dom.AbstractBuildingBlockNode;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.GrantUriPermissionNode;
import org.eclipse.andmore.android.model.manifest.dom.IntentFilterNode;
import org.eclipse.andmore.android.model.manifest.dom.MetadataNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class ProviderNode
extends AbstractBuildingBlockNode {
    private List<String> propAuthorities = null;
    private Boolean propGrantUriPermissions = null;
    private Integer propInitOrder = null;
    private Boolean propMultiprocess = null;
    private String propReadPermission = null;
    private Boolean propSyncable = null;
    private String propWritePermission = null;

    static {
        defaultProperties.add("android:authorities");
        defaultProperties.add("android:grantUriPermissions");
        defaultProperties.add("android:initOrder");
        defaultProperties.add("android:multiprocess");
        defaultProperties.add("android:readPermission");
        defaultProperties.add("android:syncable");
        defaultProperties.add("android:writePermission");
    }

    public ProviderNode(String name, String initialAuthority) {
        super(name);
        Assert.isLegal((initialAuthority != null ? 1 : 0) != 0);
        this.propAuthorities = new LinkedList<String>();
        this.propAuthorities.add(initialAuthority);
    }

    @Override
    protected boolean canContains(AndroidManifestNode.NodeType nodeType) {
        return nodeType == AndroidManifestNode.NodeType.GrantUriPermission || nodeType == AndroidManifestNode.NodeType.MetaData || nodeType == AndroidManifestNode.NodeType.Comment;
    }

    @Override
    protected void addAdditionalProperties() {
        super.addAdditionalProperties();
        this.properties.put("android:authorities", this.getAuthoritiesList());
        if (this.propGrantUriPermissions != null) {
            this.properties.put("android:grantUriPermissions", this.propGrantUriPermissions.toString());
        }
        if (this.propInitOrder != null) {
            this.properties.put("android:initOrder", this.propInitOrder.toString());
        }
        if (this.propMultiprocess != null) {
            this.properties.put("android:multiprocess", this.propMultiprocess.toString());
        }
        if (this.propReadPermission != null) {
            this.properties.put("android:readPermission", this.propReadPermission);
        }
        if (this.propSyncable != null) {
            this.properties.put("android:syncable", this.propSyncable.toString());
        }
        if (this.propWritePermission != null) {
            this.properties.put("android:writePermission", this.propWritePermission);
        }
    }

    @Override
    public AndroidManifestNode.NodeType getNodeType() {
        return AndroidManifestNode.NodeType.Provider;
    }

    @Override
    protected boolean isNodeValid() {
        return super.isNodeValid() && this.getAuthoritiesList().trim().length() > 0;
    }

    private String getAuthoritiesList() {
        String authorities = "";
        if (this.propAuthorities != null && !this.propAuthorities.isEmpty()) {
            int i = 0;
            while (i < this.propAuthorities.size() - 1) {
                authorities = String.valueOf(authorities) + this.propAuthorities.get(i) + ";";
                ++i;
            }
            authorities = String.valueOf(authorities) + this.propAuthorities.get(this.propAuthorities.size() - 1);
        }
        return authorities;
    }

    public boolean addAuthority(String authority) {
        Assert.isLegal((authority != null ? 1 : 0) != 0);
        boolean added = false;
        String auth = authority.trim();
        if (!this.propAuthorities.contains(auth)) {
            this.propAuthorities.add(auth);
            added = true;
        }
        return added;
    }

    public String[] getAuthorities() {
        String[] authorities = new String[this.propAuthorities.size()];
        authorities = this.propAuthorities.toArray(authorities);
        return authorities;
    }

    public boolean removeAuthority(String authority) {
        Assert.isLegal((authority != null ? 1 : 0) != 0);
        boolean removed = false;
        String auth = authority.trim();
        if (this.propAuthorities.size() > 1 && this.propAuthorities.contains(auth)) {
            this.propAuthorities.remove(auth);
            removed = true;
        }
        return removed;
    }

    public Boolean getGrantUriPermissions() {
        return this.propGrantUriPermissions;
    }

    public void setGrantUriPermissions(Boolean grantUriPermissions) {
        this.propGrantUriPermissions = grantUriPermissions;
    }

    public Integer getInitOrder() {
        return this.propInitOrder;
    }

    public void setInitOrder(Integer initOrder) {
        this.propInitOrder = initOrder;
    }

    public Boolean getMultiprocess() {
        return this.propMultiprocess;
    }

    public void setMultiprocess(Boolean multiprocess) {
        this.propMultiprocess = multiprocess;
    }

    public String getReadPermission() {
        return this.propReadPermission;
    }

    public void setReadPermission(String readPermission) {
        this.propReadPermission = readPermission;
    }

    public Boolean getSyncable() {
        return this.propSyncable;
    }

    public void setSyncable(Boolean syncable) {
        this.propSyncable = syncable;
    }

    public String getWritePermission() {
        return this.propWritePermission;
    }

    public void setWritePermission(String writePermission) {
        this.propWritePermission = writePermission;
    }

    public void addMetadataNode(MetadataNode metadata) {
        if (metadata != null && !this.children.contains(metadata)) {
            this.children.add(metadata);
        }
    }

    public List<MetadataNode> getMetadataNodes() {
        LinkedList<MetadataNode> metadatas = new LinkedList<MetadataNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.MetaData);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            metadatas.add((MetadataNode)node);
            ++n2;
        }
        return metadatas;
    }

    public void removeMetadataNode(MetadataNode metadata) {
        if (metadata != null) {
            this.children.remove(metadata);
        }
    }

    public void addGrantUriPermissionNode(GrantUriPermissionNode grantUriPermission) {
        if (grantUriPermission != null && !this.children.contains(grantUriPermission)) {
            this.children.add(grantUriPermission);
        }
    }

    public List<GrantUriPermissionNode> getGrantUriPermissionsNodes() {
        LinkedList<GrantUriPermissionNode> grantUriPermissions = new LinkedList<GrantUriPermissionNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.GrantUriPermission);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            grantUriPermissions.add((GrantUriPermissionNode)node);
            ++n2;
        }
        return grantUriPermissions;
    }

    public void removeGrantUriPermissionNode(GrantUriPermissionNode grantUriPermission) {
        if (grantUriPermission != null) {
            this.children.remove(grantUriPermission);
        }
    }

    @Override
    protected List<IStatus> getSpecificNodeProblems() {
        return null;
    }

    public void addIntentFilterNode(IntentFilterNode intentFilter) {
        if (intentFilter != null && !this.children.contains(intentFilter)) {
            this.children.add(intentFilter);
        }
    }
}

