/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class CanRefreshStatus
extends MultiStatus {
    public static final int ASK_USER = 16;
    public static final int CANCELABLE = 32;

    public CanRefreshStatus(int severity, String pluginId, IStatus[] newChildren, String message, Throwable exception) {
        super(pluginId, 0, newChildren, message, exception);
        this.setSeverity(severity);
    }

    public CanRefreshStatus(int severity, String pluginId, String message, Throwable exception) {
        super(pluginId, 0, message, exception);
        this.setSeverity(severity);
    }

    public CanRefreshStatus(int severity, String pluginId, IStatus[] newChildren, String message) {
        super(pluginId, 0, newChildren, message, null);
        this.setSeverity(severity);
    }

    public CanRefreshStatus(int severity, String pluginId, String message) {
        super(pluginId, 0, message, null);
        this.setSeverity(severity);
    }

    protected void setSeverity(int severity) {
        Assert.isLegal((severity == 0 || severity == 4 || severity == 2 || severity == 1 || severity == 8 || severity == 16 || severity == 48 ? 1 : 0) != 0);
        if ((severity & 0x10) != 0) {
            super.setSeverity(2);
        }
        this.setCode(severity);
    }

    public boolean matches(int severityMask) {
        if ((severityMask & 0x10) != 0) {
            return (this.getCode() & severityMask) == severityMask;
        }
        return super.matches(severityMask);
    }
}

