/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.common.CommonPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.db.core.model.DbModel;
import org.eclipse.andmore.android.db.core.ui.view.AndmoreDatabaseExplorerView;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DbCoreActivator
extends AbstractUIPlugin {
    private static final String DB_PROPERTY_TESTER_ATT_PROPERTIES = "properties";
    private static final String DB_PROPERTY_TESTER_ATT_NAMESPACE = "namespace";
    private static final String DB_PROPERTY_TESTER_EXTENSION_ID = "org.eclipse.andmore.android.db.core.propertyTesters";
    public static final String PLUGIN_ID = "org.eclipse.andmore.android.db.core";
    private static final String DB_TEMPLATE_PATH = "res/template.db";
    private static List<String> pluginProperties = null;
    private static DbCoreActivator plugin;
    public static final String DATATOOLS_UI_PLUGIN_ID = "org.eclipse.datatools.connectivity.sqm.core.ui";
    public static final String TABLE_ICON = "icons/table.gif";

    public void start(BundleContext context) throws Exception {
        AndmoreLogger.debug(DbCoreActivator.class, (String)"Starting Eclipse Andmore Database Core Plugin...");
        super.start(context);
        plugin = this;
        DbModel.assertDriverExistsAtModel();
        DbModel.cleanPreviousProfiles();
        AndmoreLogger.debug(DbCoreActivator.class, (String)"Eclipse Andmore Database Core Plugin started.");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        DbModel.deleteDriverFromModel();
        super.stop(context);
    }

    public static DbCoreActivator getDefault() {
        return plugin;
    }

    private File getResourceFile(String pathAtPlugin) {
        URL location = this.getBundle().getEntry(pathAtPlugin);
        File file = null;
        try {
            Path p = new Path(FileLocator.toFileURL((URL)location).getFile());
            file = p.toFile();
        }
        catch (IOException iOException) {
            AndmoreLogger.error((String)NLS.bind((String)"Could not get resource file {0}", (Object)pathAtPlugin));
        }
        return file;
    }

    public String getDriverPath() {
        return CommonPlugin.getDefault().getDriverPath();
    }

    private File getTemplateDbFile() {
        return this.getResourceFile(DB_TEMPLATE_PATH);
    }

    public void copyTemplateDbFile(File target, boolean overwrite) throws IOException {
        AndmoreLogger.debug((String)NLS.bind((String)"Attempting to copy db template file to {0}", (Object)target.getAbsolutePath()));
        File templateDbFile = this.getTemplateDbFile();
        if (overwrite && target.exists()) {
            target.delete();
        }
        if (!overwrite && target.exists()) {
            throw new IOException("Target file already exists");
        }
        AndmoreLogger.debug((String)NLS.bind((String)"Creating parent folders for file: {0}", (Object)target.getAbsolutePath()));
        target.getParentFile().mkdirs();
        FileUtil.copyFile((File)templateDbFile, (File)target);
        AndmoreLogger.debug((String)NLS.bind((String)"DB template file succesfully copyed to {0}", (Object)target.getAbsolutePath()));
    }

    public static AndmoreDatabaseExplorerView getAndmoreDatabaseExplorerView() {
        IViewPart view = EclipseUtils.getActiveView((String)"org.eclipse.andmore.android.db.databaseView");
        if (view instanceof AndmoreDatabaseExplorerView) {
            return (AndmoreDatabaseExplorerView)view;
        }
        return null;
    }

    public static List<String> getPluginProperties() {
        if (pluginProperties == null) {
            IConfigurationElement[] confElements;
            pluginProperties = new ArrayList<String>();
            IExtension propertyTesters = Platform.getExtensionRegistry().getExtension(DB_PROPERTY_TESTER_EXTENSION_ID);
            IConfigurationElement[] iConfigurationElementArray = confElements = propertyTesters.getConfigurationElements();
            int n = confElements.length;
            int n2 = 0;
            while (n2 < n) {
                String[] properties;
                IConfigurationElement confElement = iConfigurationElementArray[n2];
                String namespace = confElement.getAttribute(DB_PROPERTY_TESTER_ATT_NAMESPACE);
                String property = confElement.getAttribute(DB_PROPERTY_TESTER_ATT_PROPERTIES);
                String[] stringArray = properties = property.split(",");
                int n3 = properties.length;
                int n4 = 0;
                while (n4 < n3) {
                    String prop = stringArray[n4];
                    String namespacedProperty = namespace.concat(".").concat(prop);
                    pluginProperties.add(namespacedProperty);
                    ++n4;
                }
                ++n2;
            }
        }
        return pluginProperties;
    }
}

