/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class DbRootNodeReader {
    public static final String DB_ROOT_NODE_EXTENSION_POINT_ID = "org.eclipse.andmore.android.db.core.dbRootNode";
    public static final String DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_ID = "id";
    public static final String DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_NAME = "name";
    public static final String DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_ICON = "icon";
    public static final String DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_CLASS = "class";

    public static void loadRootNode(HashMap<String, AbstractTreeNode> treeNodeList) throws PartInitException {
        ArrayList<String> failedNodeNames = new ArrayList<String>();
        treeNodeList.clear();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(DB_ROOT_NODE_EXTENSION_POINT_ID);
        String id = null;
        String name = null;
        if (extPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension aExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = aExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement aConfig = iConfigurationElementArray[n4];
                    id = aConfig.getAttribute(DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_ID);
                    name = aConfig.getAttribute(DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_NAME);
                    String nodeClassName = aConfig.getAttribute(DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_CLASS);
                    AbstractTreeNode treeNode = null;
                    if (nodeClassName != null) {
                        try {
                            treeNode = (AbstractTreeNode)aConfig.createExecutableExtension(DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_CLASS);
                            treeNode.setId(id);
                            treeNode.setName(name);
                            if (aConfig.getAttribute(DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_ICON) != null) {
                                ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.core", (String)aConfig.getAttribute(DB_ROOT_NODE_EXTENSION_POINT_ATTRIBUTE_ICON));
                                treeNode.setIcon(icon);
                            }
                            treeNodeList.put(id, treeNode);
                        }
                        catch (CoreException e) {
                            AndmoreLogger.error(DbRootNodeReader.class, (String)("Unexpected error with the root node extension point. Name:" + name + " ID:" + id), (Throwable)e);
                            failedNodeNames.add(name);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            if (!failedNodeNames.isEmpty()) {
                throw new PartInitException("The following nodes could not be loaded : " + failedNodeNames);
            }
        }
    }
}

