/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.project.ProjectNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.action.IDbCreatorNode;
import org.eclipse.andmore.android.db.core.ui.view.AndmoreDatabaseExplorerView;
import org.eclipse.andmore.android.db.core.ui.wizards.createdb.CreateDatabaseWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DbCreateHandler
extends AbstractHandler
implements IHandler {
    private IDbCreatorNode dbCreatorNode;

    public DbCreateHandler() {
        this.setDbCreatorNode();
    }

    public DbCreateHandler(IDbCreatorNode dbCreatorNode) {
        this.dbCreatorNode = dbCreatorNode;
    }

    private void setDbCreatorNode() {
        this.dbCreatorNode = null;
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        AndmoreDatabaseExplorerView view = DbCoreActivator.getAndmoreDatabaseExplorerView();
        if (view != null && activePart.equals(view)) {
            ITreeNode items = view.getSelectedItemOnTree();
            if (items != null && items instanceof IDbCreatorNode) {
                this.dbCreatorNode = (IDbCreatorNode)items;
                ITreeNode node = view.getSelectedItemOnTree();
                if (node != null) {
                    try {
                        IDbCreatorNode dbCreatorNode = (IDbCreatorNode)node;
                        if (node instanceof IDbCreatorNode) {
                            this.dbCreatorNode = dbCreatorNode;
                        }
                    }
                    catch (Exception e) {
                        AndmoreLogger.info(DbCreateHandler.class, (String)e.getMessage());
                    }
                }
            }
        } else {
            IWorkbenchWindow window;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && !workbench.isClosing() && (window = workbench.getActiveWorkbenchWindow()) != null) {
                ISelection selection = window.getSelectionService().getSelection();
                Object structureSelection = null;
                structureSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : new StructuredSelection();
                Object selectionElement = structureSelection.getFirstElement();
                if (selectionElement != null) {
                    IResource resource = null;
                    if (selectionElement instanceof IResource) {
                        resource = (IResource)selectionElement;
                    } else if (selectionElement instanceof IAdaptable) {
                        try {
                            resource = (IResource)((IAdaptable)selectionElement).getAdapter(IResource.class);
                        }
                        catch (Exception e) {
                            AndmoreLogger.error(DbCreateHandler.class, (String)e.getMessage());
                        }
                    }
                    if (resource != null) {
                        this.dbCreatorNode = new ProjectNode(resource.getProject(), null);
                    }
                }
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.setDbCreatorNode();
        if (this.dbCreatorNode != null) {
            List<ITreeNode> children = this.dbCreatorNode.getChildren();
            ArrayList<String> alreadyAvailableDbs = new ArrayList<String>(children.size());
            for (ITreeNode child : children) {
                alreadyAvailableDbs.add(child.getName());
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            CreateDatabaseWizard createDbWizard = new CreateDatabaseWizard(alreadyAvailableDbs);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)createDbWizard);
            dialog.create();
            dialog.open();
            String dbName = createDbWizard.getDbName();
            List<TableModel> tables = createDbWizard.getTables();
            IStatus status = null;
            try {
                status = this.dbCreatorNode.createDb(dbName, tables);
                if (this.dbCreatorNode instanceof ProjectNode) {
                    ((ProjectNode)this.dbCreatorNode).refreshAssetsFolder();
                }
            }
            catch (Exception e) {
                AndmoreLogger.error(DbCreateHandler.class, (String)e.getMessage());
            }
            if (status != null && !status.isOK()) {
                EclipseUtils.showErrorDialog((String)DbCoreNLS.UI_CreateDatabaseWizardPage_CreateDatabase_Error, (String)NLS.bind((String)DbCoreNLS.UI_CreateDatabaseWizardPage_CreateDatabase_Error_New, (Object)dbName), (IStatus)status);
            }
        }
        return null;
    }
}

