/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.command;

import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITableNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteTableHandler
extends AbstractHandler
implements IHandler {
    private ITreeNode node;

    public DeleteTableHandler() {
    }

    public DeleteTableHandler(ITreeNode node) {
        this.node = node;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.node instanceof ITableNode) {
            IStatus status;
            ITableNode tableNode = (ITableNode)this.node;
            IDbNode dbNode = (IDbNode)tableNode.getParent();
            boolean shouldProceed = EclipseUtils.showQuestionDialog((String)DbCoreNLS.DeleteTableHandler_ConfirmationQuestionDialog_Title, (String)NLS.bind((String)DbCoreNLS.DeleteTableHandler_ConfirmationQuestionDialog_Description, (Object)this.node.getName()));
            if (shouldProceed && (status = dbNode.deleteTable(tableNode)) != null && !status.isOK()) {
                EclipseUtils.showErrorDialog((String)DbCoreNLS.DbNode_CouldNotDeleteTable, (String)status.getMessage());
            }
        }
        return null;
    }
}

