/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.command;

import java.io.File;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.DbModel;
import org.eclipse.andmore.android.db.core.ui.IDbMapperNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class MapDatabaseHandler
extends AbstractHandler
implements IHandler {
    private IDbMapperNode dbMapperNode;

    public MapDatabaseHandler() {
    }

    public MapDatabaseHandler(IDbMapperNode node) {
        this.dbMapperNode = node;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.dbMapperNode != null) {
            Path dbFilePath = null;
            Shell shell = Display.getCurrent().getActiveShell();
            FileDialog dialog = new FileDialog(shell);
            String[] filterExt = new String[]{"*.db", "*.*"};
            dialog.setFilterExtensions(filterExt);
            String dbFilePathString = dialog.open();
            if (dbFilePathString != null) {
                File dbFile = new File(dbFilePathString);
                dbFilePath = new Path(dbFile.getAbsolutePath());
                if (dbFile.exists() && DbModel.isValidSQLiteDatabase(dbFile)) {
                    this.dbMapperNode.map((IPath)dbFilePath);
                } else {
                    EclipseUtils.showErrorDialog((String)DbCoreNLS.MapDatabaseHandler_Title_Error, (String)NLS.bind((String)DbCoreNLS.Invalid_Db_Error, (Object)dbFilePath));
                }
            }
        }
        return null;
    }
}

