/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.ui.IDbMapperNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class UnmapDatabaseHandler
extends AbstractHandler
implements IHandler {
    private IDbMapperNode dbMapperNode;

    public UnmapDatabaseHandler() {
    }

    public UnmapDatabaseHandler(IDbMapperNode node) {
        this.dbMapperNode = node;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStatus status;
        List<ITreeNode> mappedDbNodes = this.dbMapperNode.getChildren();
        List<ITreeNode> dbNodesToUnmap = null;
        if (!mappedDbNodes.isEmpty()) {
            dbNodesToUnmap = this.queryDbPath(mappedDbNodes);
        }
        if ((status = this.dbMapperNode.unmap(dbNodesToUnmap)).getCode() != 8 && !status.isOK()) {
            EclipseUtils.showErrorDialog((String)DbCoreNLS.UnmapDatabaseHandler_Error_Title, (String)DbCoreNLS.UnmapDatabaseHandler_Error_Description, (IStatus)status);
        }
        return null;
    }

    private List<ITreeNode> queryDbPath(List<ITreeNode> mappedDbNodes) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ElementListSelectionDialog listDialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDbNode) {
                    IDbNode dbNode = (IDbNode)element;
                    return dbNode.getName();
                }
                return super.getText(element);
            }
        });
        listDialog.setElements(mappedDbNodes.toArray());
        listDialog.setTitle(DbCoreNLS.UI_UnmapDatabaseAction_Title);
        listDialog.setBlockOnOpen(true);
        listDialog.setMultipleSelection(true);
        listDialog.open();
        Object[] result = listDialog.getResult();
        List<Object> asList = Arrays.asList(result);
        List<ITreeNode> checkedList = Collections.checkedList(asList, ITreeNode.class);
        return checkedList;
    }
}

