/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui;

import java.util.List;
import org.eclipse.andmore.android.common.utilities.PluginUtils;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.ui.AbstractLoadingNodeJob;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.view.AndmoreDatabaseExplorerView;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public final class LoadingJobListener
extends JobChangeAdapter {
    public void scheduled(IJobChangeEvent event) {
        Job job = event.getJob();
        if (job instanceof AbstractLoadingNodeJob) {
            AbstractLoadingNodeJob loadingNodeJob = (AbstractLoadingNodeJob)job;
            ITreeNode node = loadingNodeJob.getNode();
            node.setLoading(true);
        }
        super.scheduled(event);
    }

    public void done(IJobChangeEvent event) {
        AndmoreDatabaseExplorerView view = DbCoreActivator.getAndmoreDatabaseExplorerView();
        if (view != null) {
            final TreeViewer treeViewer = view.getTreeViewer();
            Job job = event.getJob();
            if (job instanceof AbstractLoadingNodeJob) {
                AbstractLoadingNodeJob loadingNodeJob = (AbstractLoadingNodeJob)job;
                ITreeNode node = loadingNodeJob.getNode();
                node.setLoading(false);
                final ITreeNode[] treeNodeContainer = new ITreeNode[]{node};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int size;
                        ITreeNode node = treeNodeContainer[0];
                        List<ITreeNode> children = node.getChildren();
                        if (PluginUtils.getOS() != 1) {
                            treeViewer.setChildCount((Object)node, 0);
                        }
                        if ((size = children.size()) > 0) {
                            ((ILazyTreeContentProvider)treeViewer.getContentProvider()).updateElement((Object)node, 0);
                        }
                        treeViewer.setChildCount((Object)node, size);
                        treeViewer.update((Object)node, null);
                    }
                });
            }
            super.done(event);
        }
    }
}

