/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui;

import java.util.ArrayList;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.DbModel;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.ColumnNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITableNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditorInput;
import org.eclipse.datatools.sqltools.data.internal.ui.extract.ExtractDataWizard;
import org.eclipse.datatools.sqltools.data.internal.ui.load.LoadDataWizard;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TableNode
extends AbstractTreeNode
implements ITableNode {
    private final Table table;
    private final DbModel model;

    public TableNode(Table table, DbModel dbModel, IDbNode parent) {
        super(table.getName(), table.getName(), parent);
        this.table = table;
        this.model = dbModel;
    }

    @Override
    public IStatus browseTableContents() {
        Status browseTableContentsStatus = new Status(0, "org.eclipse.andmore.android.db.core", DbCoreNLS.TableNode_BrowsingTableContentsSuccessStatus);
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            workbenchPage.openEditor((IEditorInput)new TableDataEditorInput(this.table), "org.eclipse.datatools.sqltools.data.internal.ui.editor.tableDataEditor");
        }
        catch (PartInitException e) {
            browseTableContentsStatus = new Status(4, "org.eclipse.andmore.android.db.core", DbCoreNLS.TableNode_BrowsingTableContentsErrorStatus, (Throwable)e);
        }
        return browseTableContentsStatus;
    }

    @Override
    public void refresh() {
        this.clear();
        EList columns = this.table.getColumns();
        ArrayList<ITreeNode> columnNodes = new ArrayList<ITreeNode>(columns.size());
        for (Column column : columns) {
            ColumnNode columnNode = new ColumnNode(column, this.model, (ITreeNode)this);
            columnNodes.add(columnNode);
        }
        this.putChildren(columnNodes);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.getSpecificIcon("org.eclipse.datatools.connectivity.sqm.core.ui", "icons/table.gif");
    }

    @Override
    public void sampleDbContents() {
        this.model.sampleContents(this.table);
    }

    @Override
    public void extractData() {
        ExtractDataWizard wiz = new ExtractDataWizard(this.table);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
        dialog.create();
        dialog.open();
    }

    @Override
    public void loadData() {
        LoadDataWizard wiz = new LoadDataWizard(this.table);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
        dialog.create();
        dialog.open();
    }
}

