/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.wizards;

import java.util.Set;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.wizards.CreateTableWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CreateTableWizard
extends Wizard {
    private TableModel table = null;
    private CreateTableWizardPage tableWizardPage = null;
    private Set<String> notAllowedNames = null;
    private static final String WIZARD_BANNER = "icons/wizban/create_table.png";

    public CreateTableWizard() {
        this.setWindowTitle(DbCoreNLS.CreateTableWizardPage_UI_PageTitle);
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.core", (String)WIZARD_BANNER));
    }

    public boolean performFinish() {
        this.table = this.tableWizardPage.getTable();
        boolean isOK = true;
        if (this.notAllowedNames != null && this.notAllowedNames.contains(this.tableWizardPage.getTable().getName().toUpperCase())) {
            MessageDialog.openError((Shell)this.getShell(), (String)DbCoreNLS.CreateTableWizard_UI_Message_ErrorCreatingTable, (String)DbCoreNLS.ERR_CreateDatabaseWizardPage_TableAlreadyExistTitle);
            isOK = false;
        }
        return isOK;
    }

    public void addPages() {
        this.tableWizardPage = new CreateTableWizardPage();
        this.addPage((IWizardPage)this.tableWizardPage);
        if (this.table != null) {
            this.tableWizardPage.setTable(this.table);
        }
    }

    public void init(TableModel table) {
        this.table = table;
    }

    public TableModel getTable() {
        return this.table;
    }

    public void setNotAllowedNames(Set<String> notAllowedNames) {
        this.notAllowedNames = notAllowedNames;
    }
}

