/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.wizards.createdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.wizards.CreateTableWizard;
import org.eclipse.andmore.android.db.core.ui.wizards.TableLabelProvider;
import org.eclipse.andmore.android.db.core.ui.wizards.createdb.DatabaseCreationFieldValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CreateDatabaseWizardPage
extends WizardPage {
    private Text databaseName;
    private Button addButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private boolean isPageComplete = false;
    private TreeViewer viewer;
    private final TreeNode[] treeNodeArray = new TreeNode[0];
    private final List<String> alreadyAvailableDbs;
    private final List<TableModel> tables = new ArrayList<TableModel>();
    private final String DATABASE_CONTEXT_HELP_ID = "org.eclipse.andmore.android.db.core.create_database_wizard";

    protected CreateDatabaseWizardPage(List<String> alreadyAvailableDbs) {
        super(DbCoreNLS.CreateDatabaseWizardPage_UI_PageTitle);
        this.setTitle(DbCoreNLS.CreateDatabaseWizardPage_UI_CreateNewDatabase);
        this.setMessage(DbCoreNLS.CreateDatabaseWizardPage_UI_CreateNewDBAddingItsFields);
        this.alreadyAvailableDbs = alreadyAvailableDbs;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 0, true, false);
        Composite nameComposite = new Composite(composite, 4);
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        nameComposite.setLayoutData((Object)layoutData);
        layoutData = new GridData(16384, 0, false, false);
        Label dbNameLabel = new Label(nameComposite, 0);
        dbNameLabel.setLayoutData((Object)layoutData);
        dbNameLabel.setText(DbCoreNLS.CreateDatabaseWizardPage_DB_Name_Label);
        layoutData = new GridData(4, 0, true, false);
        this.databaseName = new Text(nameComposite, 2052);
        this.databaseName.setLayoutData((Object)layoutData);
        this.databaseName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateDatabaseWizardPage.this.validatePage();
                CreateDatabaseWizardPage.this.getContainer().updateButtons();
            }
        });
        Composite emptyComposite = new Composite(composite, 131072);
        emptyComposite.setLayout((Layout)new GridLayout(1, false));
        emptyComposite.layout();
        Group tableGroup = new Group(composite, 4);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridData = new GridData(4, 4, true, true);
        tableGroup.setLayout((Layout)gridLayout);
        tableGroup.setLayoutData((Object)gridData);
        tableGroup.setText(DbCoreNLS.CreateDatabaseWizardPage_Table_Group);
        this.viewer = new TreeViewer((Composite)tableGroup, 2564);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.setInput((Object)this.treeNodeArray);
        layoutData = new GridData(4, 4, true, true);
        this.viewer.getTree().setLayoutData((Object)layoutData);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new TreeViewerListener());
        Composite buttonBar = new Composite((Composite)tableGroup, 0);
        layoutData = new GridData(131072, 128, false, true);
        buttonBar.setLayoutData((Object)layoutData);
        buttonBar.setLayout((Layout)new FillLayout(512));
        this.addButton = new Button(buttonBar, 8);
        this.addButton.setText(DbCoreNLS.CreateDatabaseWizardPage_Add_Button);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean tableAdded = false;
                while (!tableAdded) {
                    CreateTableWizard createTableWizard = new CreateTableWizard();
                    WizardDialog dialog = new WizardDialog(CreateDatabaseWizardPage.this.getShell(), (IWizard)createTableWizard);
                    dialog.open();
                    if (dialog.getReturnCode() != 0) break;
                    TableModel newTable = createTableWizard.getTable();
                    if (newTable == null) continue;
                    boolean tableNameAlreadyExists = false;
                    for (TableModel tableModel : CreateDatabaseWizardPage.this.tables) {
                        if (!tableModel.getName().equalsIgnoreCase(newTable.getName())) continue;
                        tableNameAlreadyExists = true;
                        break;
                    }
                    if (!tableNameAlreadyExists) {
                        CreateDatabaseWizardPage.this.tables.add(newTable);
                        ArrayList<TreeNode> treeNodeColletion = new ArrayList<TreeNode>();
                        treeNodeColletion.addAll(Arrays.asList((TreeNode[])CreateDatabaseWizardPage.this.viewer.getInput()));
                        TreeNode treeNode = new TreeNode((Object)newTable);
                        treeNodeColletion.add(treeNode);
                        CreateDatabaseWizardPage.this.viewer.setInput((Object)treeNodeColletion.toArray(new TreeNode[0]));
                        tableAdded = true;
                        continue;
                    }
                    MessageDialog.openError((Shell)CreateDatabaseWizardPage.this.getShell(), (String)DbCoreNLS.CreateDatabaseWizardPage_Table_Already_Exists_Title, (String)NLS.bind((String)DbCoreNLS.CreateDatabaseWizardPage_Table_Already_Exists_Msg, (Object)newTable.getName()));
                }
            }
        });
        this.editButton = new Button(buttonBar, 8);
        this.editButton.setText(DbCoreNLS.CreateDatabaseWizardPage_Edit_Button);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeNode selectedNode = null;
                if (CreateDatabaseWizardPage.this.viewer.getSelection() instanceof ITreeSelection) {
                    ITreeSelection treeSelection = (ITreeSelection)CreateDatabaseWizardPage.this.viewer.getSelection();
                    selectedNode = (TreeNode)treeSelection.getFirstElement();
                    TableModel table = (TableModel)selectedNode.getValue();
                    CreateTableWizard createTableWizard = new CreateTableWizard();
                    createTableWizard.init(table);
                    WizardDialog dialog = new WizardDialog(CreateDatabaseWizardPage.this.getShell(), (IWizard)createTableWizard);
                    dialog.open();
                    TableModel newTable = createTableWizard.getTable();
                    if (newTable != null) {
                        CreateDatabaseWizardPage.this.tables.add(newTable);
                    }
                    CreateDatabaseWizardPage.this.viewer.refresh();
                }
            }
        });
        this.removeButton = new Button(buttonBar, 8);
        this.removeButton.setText(DbCoreNLS.CreateDatabaseWizardPage_Remove_Button);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<TreeNode> treeNodeColletion = new ArrayList<TreeNode>();
                treeNodeColletion.addAll(Arrays.asList((TreeNode[])CreateDatabaseWizardPage.this.viewer.getInput()));
                TreeNode selectedNode = null;
                if (CreateDatabaseWizardPage.this.viewer.getSelection() instanceof ITreeSelection) {
                    ITreeSelection treeSelection = (ITreeSelection)CreateDatabaseWizardPage.this.viewer.getSelection();
                    selectedNode = (TreeNode)treeSelection.getFirstElement();
                    treeNodeColletion.remove(selectedNode);
                    CreateDatabaseWizardPage.this.viewer.setInput((Object)treeNodeColletion.toArray(new TreeNode[0]));
                }
            }
        });
        composite.pack();
        composite.layout();
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.andmore.android.db.core.create_database_wizard");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.andmore.android.db.core.create_database_wizard");
    }

    private void validatePage() {
        DatabaseCreationFieldValidator validator = new DatabaseCreationFieldValidator(this.alreadyAvailableDbs);
        String errorMessage = validator.isValid(this.getDatabaseName());
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
            this.isPageComplete = false;
        } else {
            this.setErrorMessage(null);
            this.isPageComplete = true;
        }
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    public String getDatabaseName() {
        return this.databaseName.getText().trim();
    }

    public List<TableModel> getTables() {
        ArrayList<TreeNode> treeNodeColletion = new ArrayList<TreeNode>();
        treeNodeColletion.addAll(Arrays.asList((TreeNode[])this.viewer.getInput()));
        ArrayList<TableModel> tableCollection = new ArrayList<TableModel>();
        for (TreeNode node : treeNodeColletion) {
            tableCollection.add((TableModel)node.getValue());
        }
        return tableCollection;
    }

    class TreeViewerListener
    implements ISelectionChangedListener {
        TreeViewerListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof ITreeSelection) {
                ITreeSelection treeSelection = (ITreeSelection)event.getSelection();
                if (!treeSelection.isEmpty()) {
                    CreateDatabaseWizardPage.this.editButton.setEnabled(true);
                    CreateDatabaseWizardPage.this.removeButton.setEnabled(true);
                } else {
                    CreateDatabaseWizardPage.this.editButton.setEnabled(false);
                    CreateDatabaseWizardPage.this.removeButton.setEnabled(false);
                }
            }
        }
    }
}

