/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.wizards.createdb;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.osgi.util.NLS;

public class DatabaseCreationFieldValidator
implements IInputValidator {
    private static final String VALIDATOR_PATTERN = "[a-zA-Z0-9 ._-]+(.db)?";
    private static final String DB_EXTENSION = ".db";
    private final Pattern pattern = Pattern.compile("[a-zA-Z0-9 ._-]+(.db)?");
    private final List<String> alreadyAvailableDbs;

    public DatabaseCreationFieldValidator(List<String> alreadyAvailableDbs) {
        this.alreadyAvailableDbs = alreadyAvailableDbs;
    }

    public String isValid(String newText) {
        String msg = null;
        Matcher patternMatcher = this.pattern.matcher(newText);
        if (!patternMatcher.matches()) {
            msg = DbCoreNLS.DatabaseCreationFieldValidator_ValidChars;
        } else {
            String dbFileName = String.valueOf(newText) + DB_EXTENSION;
            if (this.alreadyAvailableDbs.contains(dbFileName)) {
                msg = NLS.bind((String)DbCoreNLS.DatabaseCreationFieldValidator_DB_Already_Exists_Msg, (Object)dbFileName);
            }
        }
        return msg;
    }
}

