/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.CanRefreshStatus;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEvent;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEventManager;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ISaveStateTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.view.SaveStateManager;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.andmore.android.db.devices.model.DeviceDbNode;
import org.eclipse.andmore.android.db.devices.model.DeviceNode;
import org.eclipse.andmore.android.db.devices.model.IDbDeviceMapperNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ExtStorageNode
extends AbstractTreeNode
implements IDbDeviceMapperNode,
ISaveStateTreeNode {
    private static final String MEMENTO_EXTERNAL_STORAGE = "ExternalStorageMapping";
    private static final String MEMENTO_KEY_PREFIX = "MappedPath_";
    private static final String ID_SUFFIX = "_EXT_STOR";
    private static final String ICON_PATH = "icons/obj16/card.png";
    private String serialNumber;
    private Set<IPath> dbNodes;
    private static final Map<String, Set<IPath>> dbNodesMap = new HashMap<String, Set<IPath>>();

    public ExtStorageNode(DeviceNode parent) {
        super((ITreeNode)parent);
        this.setId(String.valueOf(this.serialNumber) + ID_SUFFIX);
        this.serialNumber = parent.getSerialNumber();
        this.setName(DbDevicesNLS.ExtStorageNode_Node_Name);
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.devices", (String)ICON_PATH);
        this.setIcon(icon);
        HashSet<IPath> dbNodes = new HashSet<IPath>(this.getDbNodes(this.serialNumber));
        for (IPath path : dbNodes) {
            this.map(path);
        }
    }

    public IStatus canRefresh() {
        IStatus status = null;
        boolean hasConnectedDb = false;
        for (ITreeNode treeNode : this.getChildren()) {
            if (!(treeNode instanceof DeviceDbNode)) continue;
            DeviceDbNode dbNode = (DeviceDbNode)treeNode;
            hasConnectedDb = dbNode.isConnected();
            break;
        }
        if (hasConnectedDb) {
            status = new CanRefreshStatus(16, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.ExternalStorageNode_ConnectedDbs_Refresh_Message);
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public void refresh() {
        List children = this.getChildren();
        for (ITreeNode child : children) {
            DeviceDbNode dbNode = (DeviceDbNode)child;
            if (!dbNode.remoteFileExists()) {
                dbNode.clear();
                dbNode.setNodeStatus((IStatus)new Status(4, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.ExtStorageNode_RemoteFile_Not_Exist));
                continue;
            }
            dbNode.disconnect();
        }
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public IStatus map(IPath remoteDbPath) {
        DeviceDbNode deviceDbNode = new DeviceDbNode(remoteDbPath, this.serialNumber, (ITreeNode)this);
        this.putChild((ITreeNode)deviceDbNode);
        this.dbNodes.add(remoteDbPath);
        DatabaseModelEventManager.getInstance().fireEvent((ITreeNode)deviceDbNode, DatabaseModelEvent.EVENT_TYPE.SELECT);
        this.saveState(SaveStateManager.getInstance().getPrefNode());
        return Status.OK_STATUS;
    }

    public boolean testAttribute(Object target, String name, String value) {
        boolean canUnmap = false;
        if (name.equals("org.eclipse.andmore.android.db.core.mappedDatabases") && value.equals("org.eclipse.andmore.android.db.core.atLeastOne")) {
            if (!this.getChildren().isEmpty()) {
                canUnmap = true;
            }
        } else {
            super.testAttribute(target, name, value);
        }
        return canUnmap;
    }

    public IStatus unmap(ITreeNode treeNode) {
        IStatus status = Status.OK_STATUS;
        if (treeNode instanceof IDbNode) {
            IDbNode dbNode = (IDbNode)treeNode;
            if (dbNode.isConnected()) {
                status = dbNode.disconnect();
            }
            if (status.isOK()) {
                this.removeChild((ITreeNode)dbNode);
                this.dbNodes.remove(((DeviceDbNode)treeNode).getRemoteDbPath());
            } else {
                status = new Status(4, "org.eclipse.andmore.android.db.core", NLS.bind((String)DbDevicesNLS.ExtStorageNode_Disconnect_Failed, (Object)dbNode.getName(), (Object)status.getMessage()));
            }
        }
        this.saveState(SaveStateManager.getInstance().getPrefNode());
        return status != null ? status : Status.OK_STATUS;
    }

    public IStatus unmap(List<ITreeNode> dbNodeList) {
        MultiStatus status = new MultiStatus("org.eclipse.andmore.android.db.devices", 0, "", null);
        for (ITreeNode dbNode : dbNodeList) {
            status.add(this.unmap(dbNode));
        }
        this.saveState(SaveStateManager.getInstance().getPrefNode());
        return status != null ? status : Status.OK_STATUS;
    }

    private Set<IPath> getDbNodes(String serialNumber_) {
        this.dbNodes = dbNodesMap.get(serialNumber_);
        if (this.dbNodes == null) {
            this.dbNodes = new HashSet<IPath>();
            dbNodesMap.put(serialNumber_, this.dbNodes);
        }
        return this.dbNodes;
    }

    public void saveState(IEclipsePreferences preferences) {
        Preferences node = preferences.node(MEMENTO_EXTERNAL_STORAGE);
        Preferences serialNode = node.node(DDMSFacade.getNameBySerialNumber((String)this.serialNumber));
        int i = 1;
        List children = this.getChildren();
        for (ITreeNode child : children) {
            DeviceDbNode dbNode = (DeviceDbNode)child;
            serialNode.put(MEMENTO_KEY_PREFIX + i, dbNode.getRemoteDbPath().toString());
            ++i;
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            AndmoreLogger.error((String)"Could not contact backing store: ", (String)e.getMessage());
        }
    }

    public void restoreState(IEclipsePreferences preferences) {
        if (this.serialNumber == null) {
            this.serialNumber = ((DeviceNode)this.getParent()).getSerialNumber();
        }
        boolean firstTime = !dbNodesMap.containsKey(this.serialNumber);
        Set<IPath> dbNodes = this.getDbNodes(this.serialNumber);
        if (firstTime) {
            try {
                Preferences deviceNode;
                String[] attributeKeys;
                String deviceName;
                Preferences node;
                if (preferences.nodeExists(MEMENTO_EXTERNAL_STORAGE) && (node = preferences.node(MEMENTO_EXTERNAL_STORAGE)).nodeExists(deviceName = DDMSFacade.getNameBySerialNumber((String)this.serialNumber)) && (attributeKeys = (deviceNode = node.node(deviceName)).keys()).length > 0) {
                    String[] stringArray = attributeKeys;
                    int n = attributeKeys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String mappedPath;
                        String key = stringArray[n2];
                        if (key.startsWith(MEMENTO_KEY_PREFIX) && (mappedPath = deviceNode.get(key, null)) != null) {
                            dbNodes.add((IPath)new Path(mappedPath));
                        }
                        ++n2;
                    }
                }
            }
            catch (BackingStoreException e) {
                AndmoreLogger.error((String)"Could not contact backing store: ", (String)e.getMessage());
            }
        }
    }
}

