/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services.console;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.devices.services.DeviceServicesPlugin;
import org.eclipse.andmore.android.devices.services.i18n.ServicesNLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ADBShellHandler
extends ServiceHandler {
    public static final String CONSOLE_NAME = "ADB Shell";
    private static final String SERIAL_PARAMETER = "-s";
    private static final String SHELL_COMMAND = "shell";
    private static final Map<String, Integer> consolesCache = new HashMap<String, Integer>();
    private static final Map<String, Process> consolesProcesses = new HashMap<String, Process>();
    private final DeviceServicesPlugin.IConsoleKilledListener listener = new DeviceServicesPlugin.IConsoleKilledListener(){

        @Override
        public void consoleKilled(String name) {
            if (consolesProcesses.containsKey(name)) {
                Process p = (Process)consolesProcesses.get(name);
                p.destroy();
                DeviceServicesPlugin.removeConsoleKilledListener(ADBShellHandler.this.listener);
                consolesProcesses.remove(name);
            }
        }
    };

    public IServiceHandler newInstance() {
        return new ADBShellHandler();
    }

    public IStatus runService(IInstance theInstance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        LinkedList<String> command = new LinkedList<String>();
        final IInstance instance = theInstance;
        File sdkPath = new File(SdkUtils.getSdkPath());
        String adbPath = SdkUtils.getAdbPath();
        File adb = new File(adbPath);
        if (sdkPath != null && sdkPath.exists() && sdkPath.isDirectory()) {
            if (adb.exists() && adb.isFile()) {
                if (instance instanceof ISerialNumbered) {
                    final String[] serialNumber = new String[]{((ISerialNumbered)instance).getSerialNumber()};
                    if (serialNumber[0] == null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ProgressMonitorDialog dialog = new ProgressMonitorDialog(new Shell(PlatformUI.getWorkbench().getDisplay()));
                                try {
                                    dialog.run(false, false, new IRunnableWithProgress(){

                                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                            int limit = 20;
                                            SubMonitor theMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                                            theMonitor.beginTask(ServicesNLS.ADBShellHandler_WaitingDeviceToLoad, limit);
                                            int times = 0;
                                            while (serialNumber[0] == null && times < limit) {
                                                theMonitor.worked(1);
                                                Thread.sleep(500L);
                                                serialNumber[0] = ((ISerialNumbered)instance).getSerialNumber();
                                                ++times;
                                            }
                                            theMonitor.setWorkRemaining(0);
                                        }
                                    });
                                }
                                catch (Exception exception) {}
                            }
                        });
                    }
                    if (serialNumber[0] == null) {
                        status = new Status(4, "org.eclipse.andmore.android.devices.services", ServicesNLS.ERR_ADBShellHandler_CouldNotExecuteTheAdbShell);
                        return status;
                    }
                    if (adbPath.contains(" ")) {
                        adbPath = DeviceServicesPlugin.IS_WIN32 ? "\"" + adbPath + "\"" : adbPath.replace(" ", "\\ ");
                    }
                    command.add(adbPath);
                    command.add(SERIAL_PARAMETER);
                    command.add(serialNumber[0]);
                    command.add(SHELL_COMMAND);
                    try {
                        int n;
                        Integer i = consolesCache.get(serialNumber[0]);
                        if (i == null) {
                            n = 1;
                        } else {
                            i = i + 1;
                            n = i;
                        }
                        i = n;
                        consolesCache.put(serialNumber[0], i);
                        String[] cmdArray = command.toArray(new String[4]);
                        StringBuffer sb = new StringBuffer();
                        String[] stringArray = cmdArray;
                        int n2 = cmdArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            String cmd = stringArray[n3];
                            sb.append(cmd);
                            sb.append(" ");
                            ++n3;
                        }
                        Process p = Runtime.getRuntime().exec(cmdArray);
                        String consoleName = "ADB Shell - " + serialNumber[0];
                        if (i != null) {
                            consoleName = String.valueOf(consoleName) + " (" + i + ")";
                        }
                        consolesProcesses.put(consoleName, p);
                        DeviceServicesPlugin.redirectProcessStreamsToConsole(p, consoleName);
                        DeviceServicesPlugin.addConsoleKilledListener(this.listener);
                    }
                    catch (IOException e) {
                        status = new Status(4, "org.eclipse.andmore.android.devices.services", ServicesNLS.ERR_ADBShellHandler_CouldNotExecuteTheAdbShell, (Throwable)e);
                    }
                }
            } else {
                status = new Status(4, "org.eclipse.andmore.android.devices.services", ServicesNLS.ERR_ADBShellHandler_MissingAdbShell);
            }
        } else {
            status = new Status(4, "org.eclipse.andmore.android.devices.services", ServicesNLS.ERR_ADBShellHandler_AndroidSdkIsNotConfigured);
        }
        return status;
    }

    public IStatus updatingService(IInstance arg0, IProgressMonitor arg1) {
        return Status.OK_STATUS;
    }
}

