/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.devices.services.DeviceServicesPlugin;
import org.eclipse.andmore.android.devices.services.i18n.ServicesNLS;
import org.eclipse.andmore.android.utilities.TelnetFrameworkAndroid;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EmulatorConsoleHandler
extends ServiceHandler {
    private static final Map<String, Integer> consolesCache = new HashMap<String, Integer>();
    private static final Map<String, TelnetFrameworkAndroid> telnetsCache = new HashMap<String, TelnetFrameworkAndroid>();
    private final DeviceServicesPlugin.IConsoleKilledListener listener = new DeviceServicesPlugin.IConsoleKilledListener(){

        @Override
        public void consoleKilled(String name) {
            if (telnetsCache.containsKey(name)) {
                TelnetFrameworkAndroid telnet = (TelnetFrameworkAndroid)telnetsCache.get(name);
                if (telnet.isConnected()) {
                    try {
                        telnet.disconnect();
                    }
                    catch (IOException iOException) {
                        EclipseUtils.showInformationDialog((String)ServicesNLS.GEN_Warning, (String)ServicesNLS.WARN_EmulatorConsoleHandler_CouldNotCloseTheConsoleConnection);
                    }
                }
                telnetsCache.remove(name);
                DeviceServicesPlugin.removeConsoleKilledListener(EmulatorConsoleHandler.this.listener);
            }
        }
    };
    public static final String CONSOLE_NAME = "Emulator Console";
    private static final String LOCALHOST = "localhost";

    public IServiceHandler newInstance() {
        return new EmulatorConsoleHandler();
    }

    public IStatus runService(final IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        if (instance instanceof ISerialNumbered) {
            Pattern pattern = Pattern.compile("emulator-([0-9]+)");
            final String[] serialNumber = new String[]{((ISerialNumbered)instance).getSerialNumber()};
            if (serialNumber[0] == null) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(new Shell(PlatformUI.getWorkbench().getDisplay()));
                        try {
                            dialog.run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    int limit = 20;
                                    SubMonitor theMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                                    theMonitor.beginTask(ServicesNLS.ADBShellHandler_WaitingDeviceToLoad, limit);
                                    int times = 0;
                                    while (serialNumber[0] == null && times < limit) {
                                        theMonitor.worked(1);
                                        Thread.sleep(500L);
                                        serialNumber[0] = ((ISerialNumbered)instance).getSerialNumber();
                                        ++times;
                                    }
                                    theMonitor.setWorkRemaining(0);
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            if (serialNumber[0] == null) {
                status = new Status(4, "org.eclipse.andmore.android.devices.services", ServicesNLS.ERR_EmulatorConsoleHandler_CouldNotOpenTheConsoleShell);
                return status;
            }
            Matcher matcher = pattern.matcher(serialNumber[0]);
            if (matcher.matches()) {
                String port = matcher.group(1);
                TelnetFrameworkAndroid telnet = new TelnetFrameworkAndroid();
                try {
                    int n;
                    Integer i = consolesCache.get(serialNumber[0]);
                    if (i == null) {
                        n = 1;
                    } else {
                        i = i + 1;
                        n = i;
                    }
                    i = n;
                    consolesCache.put(serialNumber[0], i);
                    telnet.connect(LOCALHOST, Integer.parseInt(port));
                    InputStream in = telnet.getInputStream();
                    OutputStream out = telnet.getOutputStream();
                    String consoleName = "Emulator Console - " + serialNumber[0];
                    if (i != null) {
                        consoleName = String.valueOf(consoleName) + " (" + i + ")";
                    }
                    telnetsCache.put(consoleName, telnet);
                    DeviceServicesPlugin.addConsoleKilledListener(this.listener);
                    DeviceServicesPlugin.redirectStreamsToConsole(in, out, consoleName);
                }
                catch (IOException e) {
                    status = new Status(4, "org.eclipse.andmore.android.devices.services", ServicesNLS.ERR_EmulatorConsoleHandler_CouldNotOpenTheConsoleShell, (Throwable)e);
                }
            }
        } else {
            status = new Status(4, "org.eclipse.andmore.android.devices.services", ServicesNLS.ERR_EmulatorConsoleHandler_CouldNotRetrieveTheEmulatorPort);
        }
        return status;
    }

    public IStatus updatingService(IInstance instance, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

