/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.emulationui;

import org.eclipse.andmore.android.emulator.core.emulationui.EmuViewerLeafNode;
import org.eclipse.andmore.android.emulator.core.emulationui.EmuViewerNode;
import org.eclipse.andmore.android.emulator.core.emulationui.EmuViewerRootNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractEmuLabelProvider
extends ColumnLabelProvider {
    protected int columnIndex;
    protected int firstColumnIndex;
    private String alternativeColorHost;
    private long alternativeColorBeanId;
    private final Color alternativeColor = new Color((Device)PlatformUI.getWorkbench().getDisplay(), 255, 255, 0);

    public void setFirstColumnIndex(int firstColumnIndex) {
        this.firstColumnIndex = firstColumnIndex;
    }

    public int getFirstColumnIndex() {
        return this.firstColumnIndex;
    }

    public void setAlternativeColorHost(String host) {
        this.alternativeColorHost = host;
    }

    public void setAlternativeColorBeanId(long beanId) {
        this.alternativeColorBeanId = beanId;
    }

    public void update(ViewerCell cell) {
        Object element;
        this.columnIndex = cell.getColumnIndex();
        super.update(cell);
        this.columnIndex = this.firstColumnIndex;
        if (this.alternativeColorHost != null && this.alternativeColorBeanId != -1L && (element = cell.getElement()) instanceof EmuViewerLeafNode) {
            EmuViewerLeafNode node = (EmuViewerLeafNode)element;
            long beanId = node.getBeanId();
            EmuViewerRootNode root = (EmuViewerRootNode)node.getParent().getParent();
            String host = root.getEmulatorIdentifier();
            if (beanId == this.alternativeColorBeanId && host.equals(this.alternativeColorHost)) {
                cell.setBackground(this.alternativeColor);
                ViewerRow highlightedRow = cell.getViewerRow();
                TreeItem highlightedItem = (TreeItem)highlightedRow.getItem();
                Tree tree = (Tree)cell.getControl();
                tree.showItem(highlightedItem);
            }
        }
    }

    public Image getImage(Object element) {
        Image imageToReturn = null;
        if (element instanceof EmuViewerNode && this.isProvidingForFirstColumn()) {
            if (element instanceof EmuViewerRootNode) {
                ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.emulator", (String)"resource/emulator.png");
                if (descriptor != null) {
                    imageToReturn = descriptor.createImage();
                }
            } else {
                imageToReturn = element instanceof EmuViewerLeafNode ? this.getLeafNodeIcon((EmuViewerLeafNode)element) : this.getIntermediateNodeIcon((EmuViewerNode)element);
            }
        }
        return imageToReturn;
    }

    protected boolean isProvidingForFirstColumn() {
        return this.firstColumnIndex == this.columnIndex;
    }

    protected Image getIntermediateNodeIcon(EmuViewerNode node) {
        Image imageToReturn = null;
        ImageDescriptor descriptor = node.getNodeId().equals("sent_to") ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.emulator", (String)"resource/sentbyemulator.png") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.emulator", (String)"resource/receivebyemulator.png");
        if (descriptor != null) {
            imageToReturn = descriptor.createImage();
        }
        return imageToReturn;
    }

    protected abstract Image getLeafNodeIcon(EmuViewerLeafNode var1);

    public abstract String getText(EmuViewerLeafNode var1, int var2);
}

