/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.emulator.core.emulationui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.emulator.core.devfrm.DeviceFrameworkManager;
import org.eclipse.andmore.android.emulator.core.model.IAndroidEmulatorInstance;
import org.eclipse.andmore.android.emulator.i18n.EmulatorNLS;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SrcDestComposite
extends Composite {
    private String emulatorLabelStr;
    private String phoneNumberLabelStr;
    private String selectedEmulator;
    private String selectedPhoneNumber;
    private boolean isValid = false;
    private String errorMessage = NLS.bind((String)EmulatorNLS.ERR_SrcDestComposite_InvalidFillingBase, (Object)EmulatorNLS.ERR_SrcDestComposite_InvalidFillingPhoneNumber, (Object)EmulatorNLS.ERR_SrcDestComposite_InvalidFillingEmulator);
    private Combo runningEmulatorsCombo;
    private Text phoneNumberText;
    private FontMetrics fontMetrics = null;

    public SrcDestComposite(Composite parent, int style, boolean showSrcControls, boolean isEmulatorSrc) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 2;
        this.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        this.setLayoutData(data);
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (isEmulatorSrc) {
            AndmoreLogger.debug((String)"Using emulator as source");
            this.emulatorLabelStr = EmulatorNLS.UI_SrcDestComposite_OriginatingRunningEmulatorLabel;
            this.phoneNumberLabelStr = EmulatorNLS.UI_SrcDestComposite_DestinationPhoneNumberLabel;
            if (showSrcControls) {
                AndmoreLogger.debug((String)"Showing source controls");
                this.createEmulatorUI();
            }
            this.createPhoneNumberUI();
        } else {
            AndmoreLogger.debug((String)"Using phone number as source");
            this.emulatorLabelStr = EmulatorNLS.UI_SrcDestComposite_DestinationRunningEmulatorLabel;
            this.phoneNumberLabelStr = EmulatorNLS.UI_SrcDestComposite_OriginatingPhoneNumberLabel;
            if (showSrcControls) {
                AndmoreLogger.debug((String)"Showing source controls");
                this.createPhoneNumberUI();
            }
            this.createEmulatorUI();
        }
        this.addListeners();
        this.checkData();
    }

    private void createEmulatorUI() {
        Label runningEmulatorsLabel = new Label((Composite)this, 0);
        runningEmulatorsLabel.setText(this.emulatorLabelStr);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.widthHint = this.getLabelWidthHint(runningEmulatorsLabel);
        runningEmulatorsLabel.setLayoutData((Object)data);
        this.runningEmulatorsCombo = new Combo((Composite)this, 2056);
        data = new GridData(4, 4, true, false);
        this.runningEmulatorsCombo.setLayoutData((Object)data);
        this.populateEmulatorCombo();
    }

    private void createPhoneNumberUI() {
        Label phoneNumberLabel = new Label((Composite)this, 0);
        phoneNumberLabel.setText(this.phoneNumberLabelStr);
        GridData data = new GridData(4, 0x1000000, false, false);
        data.widthHint = this.getLabelWidthHint(phoneNumberLabel);
        phoneNumberLabel.setLayoutData((Object)data);
        this.phoneNumberText = new Text((Composite)this, 2048);
        data = new GridData(4, 4, true, false);
        this.phoneNumberText.setLayoutData((Object)data);
        this.phoneNumberText.setTextLimit(40);
    }

    private void addListeners() {
        if (this.runningEmulatorsCombo != null) {
            this.runningEmulatorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SrcDestComposite.this.selectedEmulator = SrcDestComposite.this.getCurrentlySelectedIdentifier();
                    SrcDestComposite.this.checkData();
                }
            });
        }
        if (this.phoneNumberText != null) {
            this.phoneNumberText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SrcDestComposite.this.selectedPhoneNumber = SrcDestComposite.this.phoneNumberText.getText();
                    SrcDestComposite.this.checkData();
                }
            });
        }
    }

    private int getLabelWidthHint(Label label) {
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)label.getText().length());
        return Math.max(widthHint, label.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private void populateEmulatorCombo() {
        HashMap<String, String> identifiersAndNames = new HashMap<String, String>();
        Collection<IAndroidEmulatorInstance> startedInstances = DeviceFrameworkManager.getInstance().getAllStartedInstances();
        for (IAndroidEmulatorInstance instance : startedInstances) {
            identifiersAndNames.put(instance.getInstanceIdentifier(), instance.getName());
        }
        String[] instanceNamesArray = new String[identifiersAndNames.size()];
        String[] identifiersArray = new String[identifiersAndNames.size()];
        int i = 0;
        Set identifiers = identifiersAndNames.keySet();
        for (String identifier : identifiers) {
            String viewerName;
            instanceNamesArray[i] = viewerName = (String)identifiersAndNames.get(identifier);
            identifiersArray[i] = identifier;
            ++i;
        }
        this.runningEmulatorsCombo.setItems(instanceNamesArray);
        this.runningEmulatorsCombo.setData((Object)identifiersArray);
        if (this.runningEmulatorsCombo.getItemCount() == 1) {
            this.runningEmulatorsCombo.select(0);
            this.selectedEmulator = this.getCurrentlySelectedIdentifier();
            this.checkData();
        }
    }

    private String getCurrentlySelectedIdentifier() {
        String currentlySelectedSerial = "";
        int index = this.runningEmulatorsCombo.getSelectionIndex();
        if (index >= 0) {
            String[] serials = (String[])this.runningEmulatorsCombo.getData();
            currentlySelectedSerial = serials[index];
        }
        return currentlySelectedSerial;
    }

    public String getSelectedEmulator() {
        return this.selectedEmulator;
    }

    public String getSelectedPhoneNumber() {
        return this.selectedPhoneNumber;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void checkData() {
        boolean isUsingEmulator;
        this.isValid = false;
        boolean isEmulatorValid = false;
        boolean isPhoneNumberValid = false;
        boolean isUsingPhoneNumber = this.phoneNumberText != null;
        boolean bl = isUsingEmulator = this.runningEmulatorsCombo != null;
        if (!isUsingEmulator || this.selectedEmulator != null && !this.selectedEmulator.equals("")) {
            isEmulatorValid = true;
        }
        if (!isUsingPhoneNumber) {
            isPhoneNumberValid = true;
        } else if (this.selectedPhoneNumber != null && !this.selectedPhoneNumber.equals("")) {
            Pattern p = Pattern.compile("(\\d)+");
            Matcher m = p.matcher(this.selectedPhoneNumber);
            isPhoneNumberValid = m.matches();
        }
        if (isEmulatorValid && isPhoneNumberValid) {
            this.isValid = true;
            this.errorMessage = null;
        } else {
            String phoneNumberError = "";
            String emulatorError = "";
            if (isUsingPhoneNumber && !isPhoneNumberValid) {
                phoneNumberError = EmulatorNLS.ERR_SrcDestComposite_InvalidFillingPhoneNumber;
            }
            if (isUsingEmulator && !isEmulatorValid) {
                emulatorError = EmulatorNLS.ERR_SrcDestComposite_InvalidFillingEmulator;
            }
            this.errorMessage = NLS.bind((String)EmulatorNLS.ERR_SrcDestComposite_InvalidFillingBase, (Object)phoneNumberError, (Object)emulatorError);
        }
    }
}

